/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.myjdownloader;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.simplejson.JSonObject;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.Base64InputStream;
import org.appwork.utils.net.HexInputStream;
import org.appwork.utils.net.httpserver.RawHttpConnectionInterface;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.jdownloader.api.myjdownloader.MyJDownloaderGetRequest;
import org.jdownloader.api.myjdownloader.MyJDownloaderHttpConnection;
import org.jdownloader.api.myjdownloader.MyJDownloaderRequestInterface;
import org.jdownloader.myjdownloader.client.json.JSonRequest;

public class MyJDownloaderPostRequest
extends PostRequest
implements MyJDownloaderRequestInterface {
    private JSonRequest jsonRequest = null;
    private MyJDownloaderGetRequest.GetData requestProperties = MyJDownloaderGetRequest.GetData.EMPTY;
    private InputStream finalInputStream = null;

    public MyJDownloaderPostRequest(MyJDownloaderHttpConnection myJDownloaderHttpConnection) {
        super((RawHttpConnectionInterface)myJDownloaderHttpConnection);
    }

    public String toString() {
        if (this.jsonRequest == null) {
            return "Non JSonRequest\r\n" + super.toString();
        }
        return "RID: " + this.jsonRequest.getRid() + "\r\nAPIVersion: " + this.jsonRequest.getApiVer() + "\r\n" + super.toString();
    }

    public void setRequestedURLParameters(List<KeyValuePair> requestedURLParameters) {
        super.setRequestedURLParameters(requestedURLParameters);
        this.requestProperties = MyJDownloaderGetRequest.parseGetData(requestedURLParameters);
    }

    @Override
    public int getApiVersion() {
        if (this.requestProperties.apiVersion >= 0) {
            return this.requestProperties.apiVersion;
        }
        try {
            JSonRequest jsonr = this.getJsonRequest();
            if (jsonr != null) {
                return jsonr.getApiVer();
            }
            return -1;
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public String getSignature() {
        return this.requestProperties.signature;
    }

    @Override
    public String getJqueryCallback() {
        return this.requestProperties.callback;
    }

    @Override
    public MyJDownloaderHttpConnection getConnection() {
        return (MyJDownloaderHttpConnection)super.getConnection();
    }

    @Override
    public String getRequestConnectToken() {
        return this.getConnection().getRequestConnectToken();
    }

    public synchronized List<KeyValuePair> getPostParameter() throws IOException {
        if (this.postParameterParsed) {
            return this.postParameters;
        }
        this.postParameters = new LinkedList();
        Object[] params = this.getJsonRequest().getParams();
        if (params != null) {
            for (Object parameter : params) {
                if (parameter instanceof JSonObject) {
                    this.postParameters.add(new KeyValuePair(parameter.toString()));
                    continue;
                }
                String jsonParameter = parameter + "";
                this.postParameters.add(new KeyValuePair(jsonParameter));
            }
        }
        this.postParameterParsed = true;
        for (KeyValuePair param : this.postParameters) {
            if (param.key == null) continue;
            if ("callback".equalsIgnoreCase(param.key)) {
                this.requestProperties.callback = param.value;
                continue;
            }
            if ("signature".equalsIgnoreCase(param.key)) {
                this.requestProperties.signature = param.value;
                continue;
            }
            if ("rid".equalsIgnoreCase(param.key)) {
                this.requestProperties.rid = Long.parseLong(param.value);
                continue;
            }
            if ("apiVer".equalsIgnoreCase(param.key)) {
                this.requestProperties.apiVersion = Integer.parseInt(param.value);
                continue;
            }
            if ("diffKA".equalsIgnoreCase(param.key)) {
                this.requestProperties.diffKeepalive = Long.parseLong(param.value);
                continue;
            }
            if (!"diffID".equalsIgnoreCase(param.key)) continue;
            this.requestProperties.diffID = param.value;
        }
        return this.postParameters;
    }

    @Override
    public long getRid() throws IOException {
        if (this.requestProperties.rid >= 0L) {
            return this.requestProperties.rid;
        }
        JSonRequest jsonr = this.getJsonRequest();
        if (jsonr != null) {
            return jsonr.getRid();
        }
        return -1L;
    }

    public JSonRequest getJsonRequest() throws IOException {
        if (this.jsonRequest != null) {
            return this.jsonRequest;
        }
        MyJDownloaderPostRequest myJDownloaderPostRequest = this;
        synchronized (myJDownloaderPostRequest) {
            if (this.jsonRequest != null) {
                return this.jsonRequest;
            }
            this.jsonRequest = (JSonRequest)JSonStorage.getMapper().inputStreamToObject(this.getInputStream(), (TypeRef)new TypeRef<JSonRequest>(){});
            return this.jsonRequest;
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.finalInputStream != null) {
            return this.finalInputStream;
        }
        try {
            InputStream aesInputStream;
            String contentType = this.getRequestHeaders().getValue("Content-Type");
            if (StringUtils.startsWithCaseInsensitive((String)contentType, (String)"application/rsajson")) {
                byte[] key;
                byte[] iv;
                final InputStream is = super.getInputStream();
                InputStream rsaKey = new InputStream(){
                    private boolean eof = false;

                    @Override
                    public void close() throws IOException {
                    }

                    @Override
                    public int read() throws IOException {
                        if (this.eof) {
                            return -1;
                        }
                        int ret = is.read();
                        if (ret == -1) {
                            this.eof = true;
                            return -1;
                        }
                        if (ret == 124) {
                            this.eof = true;
                            return -1;
                        }
                        return ret;
                    }
                };
                Base64InputStream rsaKeyStream = new Base64InputStream(rsaKey);
                Cipher rsaCipher = Cipher.getInstance("RSA");
                rsaCipher.init(2, this.getConnection().getRSAKeyPair().getPrivate());
                byte[] ivAesBytes = IO.readStream((int)-1, (InputStream)new HexInputStream((InputStream)new CipherInputStream((InputStream)rsaKeyStream, rsaCipher)));
                if (ivAesBytes.length == 32) {
                    iv = Arrays.copyOfRange(ivAesBytes, 0, 16);
                    key = Arrays.copyOfRange(ivAesBytes, 16, 32);
                } else {
                    iv = Arrays.copyOfRange(ivAesBytes, 0, 16);
                    key = Arrays.copyOfRange(ivAesBytes, 16, 48);
                }
                this.getConnection().setKey(key);
                this.getConnection().setIv(iv);
                aesInputStream = is;
            } else {
                aesInputStream = super.getInputStream();
            }
            IvParameterSpec ivSpec = new IvParameterSpec(this.getConnection().getIv());
            SecretKeySpec skeySpec = new SecretKeySpec(this.getConnection().getKey(), "AES");
            Cipher aesCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            aesCipher.init(2, (Key)skeySpec, ivSpec);
            this.finalInputStream = new CipherInputStream((InputStream)new Base64InputStream(aesInputStream), aesCipher);
            return this.finalInputStream;
        }
        catch (NoSuchPaddingException e) {
            throw new IOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long getDiffKeepAlive() throws IOException {
        if (this.requestProperties.diffKeepalive >= 0L) {
            return this.requestProperties.diffKeepalive;
        }
        JSonRequest jsonr = this.getJsonRequest();
        if (jsonr != null) {
            return jsonr.getDiffKA();
        }
        return 0L;
    }

    @Override
    public String getDiffID() throws IOException {
        if (this.requestProperties.diffID != null) {
            return this.requestProperties.diffID;
        }
        JSonRequest jsonr = this.getJsonRequest();
        if (jsonr != null) {
            return jsonr.getDiffID();
        }
        return null;
    }

    @Override
    public String getDiffType() throws IOException {
        if (this.requestProperties.diffType != null) {
            return this.requestProperties.diffType;
        }
        JSonRequest jsonr = this.getJsonRequest();
        if (jsonr != null) {
            return jsonr.getDiffType();
        }
        return null;
    }
}

