/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.myjdownloader;

import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultFactory;
import org.appwork.storage.config.annotations.DefaultIntArrayValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.annotations.StorageHandlerFactoryAnnotation;
import org.appwork.storage.config.defaults.AbstractDefaultFactory;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.jdownloader.api.myjdownloader.MyJDownloaderSettingsStorageHandlerFactory;

@StorageHandlerFactoryAnnotation(value=MyJDownloaderSettingsStorageHandlerFactory.class)
public interface MyJDownloaderSettings
extends ConfigInterface {
    @DefaultStringValue(value="api.jdownloader.org")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public String getServerHost();

    @AboutConfig
    @DescriptionForConfigEntry(value="Set preferred IP version to use")
    @DefaultEnumValue(value="SYSTEM")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public HTTPConnectionUtils.IPVERSION getPreferredIPVersion();

    public void setPreferredIPVersion(HTTPConnectionUtils.IPVERSION var1);

    public void setServerHost(String var1);

    @DefaultIntArrayValue(value={80, 10101})
    @AboutConfig
    public int[] getDeviceConnectPorts();

    public void setDeviceConnectPorts(int[] var1);

    @AboutConfig
    public String[] getCustomDeviceIPs();

    public void setCustomDeviceIPs(String[] var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isDebugEnabled();

    public void setDebugEnabled(boolean var1);

    public String getEmail();

    public void setEmail(String var1);

    public String getPassword();

    public void setPassword(String var1);

    @Deprecated
    public String getUniqueDeviceID();

    @AboutConfig
    @RequiresRestart(value="A JDownloader Restart is Required")
    public String getUniqueDeviceIDV2();

    public String getUniqueDeviceIDSaltV2();

    public void setUniqueDeviceIDSaltV2(String var1);

    public void setUniqueDeviceID(String var1);

    public void setUniqueDeviceIDV2(String var1);

    @AboutConfig
    @DefaultFactory(value=DeviceNameFactory.class)
    public String getDeviceName();

    public void setDeviceName(String var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public void setAutoConnectEnabledV2(boolean var1);

    public boolean isAutoConnectEnabledV2();

    @AboutConfig
    @DefaultEnumValue(value="LAN")
    @RequiresRestart(value="A JDownloader Restart is Required")
    public DIRECTMODE getDirectConnectMode();

    public void setDirectConnectMode(DIRECTMODE var1);

    @AboutConfig
    @DefaultIntValue(value=3129)
    @SpinnerValidator(min=1025L, max=65000L)
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DescriptionForConfigEntry(value="Try to use given local port for DirectConnectMode=LAN,LAN_WAN_MANUAL,LAN_WAN_UPNP")
    public int getManualLocalPort();

    public void setManualLocalPort(int var1);

    @AboutConfig
    @DefaultIntValue(value=0)
    public int getLastLocalPort();

    public void setLastLocalPort(int var1);

    @AboutConfig
    @DefaultIntValue(value=0)
    public int getLastUpnpPort();

    public void setLastUpnpPort(int var1);

    @AboutConfig
    @DefaultIntValue(value=3129)
    @RequiresRestart(value="A JDownloader Restart is Required")
    @SpinnerValidator(min=80L, max=65000L)
    @DescriptionForConfigEntry(value="Try to use given remove port for DirectConnectMode=LAN_WAN_MANUAL")
    public int getManualRemotePort();

    public void setManualRemotePort(int var1);

    @AboutConfig
    @DefaultEnumValue(value="NONE")
    public void setLatestError(MyJDownloaderError var1);

    public MyJDownloaderError getLatestError();

    public static enum MyJDownloaderError {
        OUTDATED,
        NONE,
        EMAIL_INVALID,
        ACCOUNT_UNCONFIRMED,
        BAD_LOGINS,
        SERVER_OVERLOAD,
        SERVER_MAINTENANCE,
        SERVER_DOWN,
        IO,
        UNKNOWN,
        NO_INTERNET_CONNECTION;

    }

    public static class DeviceNameFactory
    extends AbstractDefaultFactory<String> {
        public String getDefaultValue(KeyHandler<String> keyHandler) {
            return "JDownloader@" + System.getProperty("user.name", "User");
        }
    }

    public static enum DIRECTMODE {
        NONE,
        LAN,
        LAN_WAN_MANUAL,
        LAN_WAN_UPNP;

    }
}

