/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.myjdownloader.remotemenu;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import jd.controlling.TaskQueue;
import jd.controlling.linkchecker.LinkChecker;
import jd.controlling.linkchecker.LinkCheckerHandler;
import jd.controlling.linkcrawler.CheckableLink;
import jd.controlling.linkcrawler.CrawledLink;
import jd.plugins.DownloadLink;
import org.appwork.utils.Application;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.api.myjdownloader.remotemenu.AbstractMyJDSelectionAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.packagetable.context.CheckStatusAction;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;

public class CheckOnlineStatusAction
extends AbstractMyJDSelectionAction {
    @Override
    public String getID() {
        return "checkonline";
    }

    public CheckOnlineStatusAction() {
        this.setIconKey("ok");
        this.setName(_GUI.T.gui_table_contextmenu_check());
    }

    public void actionPerformed(ActionEvent e) {
        final List<?> children = this.getSelection().getChildren();
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                ArrayList<CheckableLink> checkableLinks = new ArrayList<CheckableLink>(children.size());
                final CheckStatusAction.LinkCheckProgress linkCheckProgress = new CheckStatusAction.LinkCheckProgress();
                for (Object l : children) {
                    if (l instanceof DownloadLink || l instanceof CrawledLink) {
                        checkableLinks.add((CheckableLink)l);
                    }
                    if (!(l instanceof DownloadLink)) continue;
                    DownloadLink link = (DownloadLink)l;
                    link.addPluginProgress(linkCheckProgress);
                }
                LinkChecker<Object> linkChecker = new LinkChecker<Object>(true);
                linkChecker.setLinkCheckHandler(new LinkCheckerHandler<CheckableLink>(){

                    @Override
                    public void linkCheckDone(CheckableLink l) {
                        if (l instanceof DownloadLink) {
                            DownloadLink link = (DownloadLink)l;
                            link.removePluginProgress(linkCheckProgress);
                        }
                    }
                });
                linkChecker.check(checkableLinks);
                return null;
            }
        });
        if (!Application.isHeadless()) {
            DownloadsTableModel.getInstance().setAvailableColumnVisible(true);
        }
    }
}

