/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.plugins;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.appwork.exceptions.WTFException;
import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableDeprecatedSince;
import org.appwork.storage.config.annotations.EnumLabel;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.reflection.Clazz;
import org.jdownloader.api.config.AdvancedConfigQueryStorable;
import org.jdownloader.api.config.EnumOption;
import org.jdownloader.myjdownloader.client.bindings.AdvancedConfigEntryDataStorable;
import org.jdownloader.settings.advanced.AdvancedConfigAPIEntry;
import org.jdownloader.settings.advanced.AdvancedConfigEntry;

public class PluginConfigEntryAPIStorable
extends AdvancedConfigAPIEntry
implements Storable {
    public PluginConfigEntryAPIStorable() {
    }

    @Override
    @AllowNonStorableObjects
    public Object getDefaultValue() {
        return super.getDefaultValue();
    }

    public PluginConfigEntryAPIStorable(AdvancedConfigEntry entry, AdvancedConfigQueryStorable query) {
        KeyHandler<?> kh = entry.getKeyHandler();
        if (query.isDescription()) {
            this.setDocs(entry.getDescription());
        }
        if (query.isDefaultValues()) {
            this.setValue(entry.getDefault());
        }
        if (query.isValues()) {
            this.setValue(entry.getValue());
        }
        if (query.isEnumInfo() && Clazz.isEnum(entry.getClazz())) {
            try {
                ArrayList<EnumOption> enumOptions = this.listEnumOptions(entry.getClazz());
                String[][] constants = new String[enumOptions.size()][2];
                String label = null;
                Enum value = (Enum)entry.getValue();
                for (int i = 0; i < enumOptions.size(); ++i) {
                    EnumOption option = enumOptions.get(i);
                    constants[i] = new String[]{option.getName(), option.getLabel()};
                    if (value == null || !value.name().equals(option.getName())) continue;
                    label = constants[i][1];
                }
                this.setEnumLabel(label);
                this.setEnumOptions(constants);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        String i = kh.getStorageHandler().getConfigInterface().getName();
        this.setInterfaceName(i);
        this.setKey(this.createKey(kh));
        try {
            AdvancedConfigEntryDataStorable.AbstractType abstractType = AdvancedConfigEntryDataStorable.AbstractType.valueOf(kh.getAbstractType().name());
            this.setAbstractType(abstractType);
        }
        catch (Exception e) {
            throw new WTFException((Throwable)e);
        }
        if (query.isValues()) {
            Object value = kh.getValue();
            this.setValue(value);
        }
        if (query.isDefaultValues()) {
            Object def = entry.getDefault();
            this.setDefaultValue(def);
        }
    }

    private ArrayList<EnumOption> listEnumOptions(Class<?> cls) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchFieldException {
        Object[] values;
        ArrayList<EnumOption> ret = new ArrayList<EnumOption>();
        for (Object o : values = (Object[])cls.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
            String label = null;
            EnumLabel lbl = cls.getDeclaredField(o.toString()).getAnnotation(EnumLabel.class);
            if (lbl != null) {
                label = lbl.value();
            } else if (o instanceof LabelInterface) {
                label = ((LabelInterface)o).getLabel();
            }
            ret.add(new EnumOption(o.toString(), label));
        }
        return ret;
    }

    @Override
    @Deprecated
    @StorableDeprecatedSince(value="2022-10-18T00:00+0200")
    public String getType() {
        return super.getType();
    }

    @Override
    @Deprecated
    @StorableDeprecatedSince(value="2022-10-18T00:00+0200")
    public void setType(String type) {
        super.setType(type);
    }
}

