/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import jd.http.Browser;
import org.appwork.exceptions.WTFException;
import org.appwork.remoteapi.exceptions.BadParameterException;
import org.appwork.utils.StringUtils;
import org.jdownloader.api.config.AdvancedConfigQueryStorable;
import org.jdownloader.api.config.InvalidValueException;
import org.jdownloader.api.plugins.PluginAPIStorable;
import org.jdownloader.api.plugins.PluginConfigAdapter;
import org.jdownloader.api.plugins.PluginConfigEntryAPIStorable;
import org.jdownloader.api.plugins.PluginsAPI;
import org.jdownloader.api.plugins.PluginsQueryStorable;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.crawler.CrawlerPluginController;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;

public class PluginsAPIImpl
implements PluginsAPI {
    @Override
    public List<String> getPluginRegex(String url) {
        ArrayList<String> ret = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)url)) {
            String host = Browser.getHost((String)url);
            List<LazyPlugin<?>> plugins = this.getAllPlugins();
            for (LazyPlugin<?> lazyPlugin : plugins) {
                String pattern;
                if (!host.equals(lazyPlugin.getDisplayName()) || !StringUtils.isNotEmpty((String)(pattern = this.getPattern(lazyPlugin)))) continue;
                ret.add(pattern);
            }
        }
        return ret;
    }

    private String getPattern(LazyPlugin<?> lazyPlugin) {
        Pattern ret = lazyPlugin.getCompiledPattern();
        if (ret != null) {
            return ret.pattern();
        }
        return lazyPlugin.getPatternSource();
    }

    @Override
    public List<PluginAPIStorable> getPluginInfos(String url) {
        ArrayList<PluginAPIStorable> ret = new ArrayList<PluginAPIStorable>();
        String host = StringUtils.isEmpty((String)url) ? null : Browser.getHost((String)url);
        List<LazyPlugin<?>> plugins = this.getAllPlugins();
        for (LazyPlugin<?> lazyPlugin : plugins) {
            if (host != null && !host.equals(lazyPlugin.getDisplayName())) continue;
            ret.add(this.createPluginListStorable(lazyPlugin, null));
        }
        return ret;
    }

    @Override
    public HashMap<String, ArrayList<String>> getAllPluginRegex() {
        ArrayList<Object> list;
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        for (LazyHostPlugin lazyHostPlugin : HostPluginController.getInstance().list()) {
            list = (ArrayList<String>)map.get(lazyHostPlugin.getDisplayName());
            if (list == null) {
                list = new ArrayList<String>();
                map.put(lazyHostPlugin.getDisplayName(), list);
            }
            list.add(lazyHostPlugin.getPattern().pattern());
        }
        for (LazyCrawlerPlugin lazyCrawlerPlugin : CrawlerPluginController.getInstance().list()) {
            list = map.get(lazyCrawlerPlugin.getDisplayName());
            if (list == null) {
                list = new ArrayList();
                map.put(lazyCrawlerPlugin.getDisplayName(), list);
            }
            list.add(lazyCrawlerPlugin.getPattern().pattern());
        }
        return map;
    }

    @Override
    public List<PluginAPIStorable> list(PluginsQueryStorable query) {
        ArrayList<PluginAPIStorable> result = new ArrayList<PluginAPIStorable>();
        for (LazyHostPlugin hPlg : HostPluginController.getInstance().list()) {
            try {
                if (!hPlg.isHasConfig()) continue;
                result.add(this.createPluginListStorable(hPlg, query));
            }
            catch (Exception e) {
                throw new WTFException((Throwable)e);
            }
        }
        for (LazyCrawlerPlugin cPlg : CrawlerPluginController.getInstance().list()) {
            try {
                if (!cPlg.isHasConfig()) continue;
                result.add(this.createPluginListStorable(cPlg, query));
            }
            catch (Exception e) {
                throw new WTFException((Throwable)e);
            }
        }
        return result;
    }

    @Override
    public List<PluginConfigEntryAPIStorable> query(AdvancedConfigQueryStorable query) throws BadParameterException {
        ArrayList<PluginConfigEntryAPIStorable> result = new ArrayList<PluginConfigEntryAPIStorable>();
        List<LazyPlugin<?>> plugins = this.getAllPlugins();
        for (LazyPlugin<?> lazyPlugin : plugins) {
            try {
                PluginConfigAdapter adapter = new PluginConfigAdapter(lazyPlugin);
                result.addAll(adapter.listConfigEntries(query));
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public boolean set(String interfaceName, String displayName, String key, Object newValue) throws BadParameterException, InvalidValueException {
        if (StringUtils.isEmpty((String)interfaceName)) {
            throw new BadParameterException("interfaceName is empty");
        }
        if (StringUtils.isEmpty((String)displayName)) {
            throw new BadParameterException("displayName is empty");
        }
        try {
            PluginConfigAdapter adapter = new PluginConfigAdapter(interfaceName, displayName);
            return adapter.setValue(key, newValue);
        }
        catch (ClassNotFoundException e) {
            throw new BadParameterException((Throwable)e, "set:interface:" + interfaceName + "|displayName:" + displayName + "|key:" + key + "|newValue:" + newValue);
        }
    }

    private PluginAPIStorable createPluginListStorable(LazyPlugin<?> lazyPlugin, PluginsQueryStorable query) {
        PluginAPIStorable storable = new PluginAPIStorable();
        storable.setClassName(lazyPlugin.getClassName());
        storable.setDisplayName(lazyPlugin.getDisplayName());
        if (query == null || query.isPattern()) {
            storable.setPattern(this.getPattern(lazyPlugin));
        }
        if (query == null || query.isVersion()) {
            storable.setVersion(Long.toString(lazyPlugin.getVersion()));
        }
        return storable;
    }

    @Override
    public boolean reset(String interfaceName, String displayName, String key) throws BadParameterException, InvalidValueException {
        if (StringUtils.isEmpty((String)interfaceName)) {
            throw new BadParameterException("interfaceName is empty");
        }
        if (StringUtils.isEmpty((String)displayName)) {
            throw new BadParameterException("displayName is empty");
        }
        if (StringUtils.isEmpty((String)key)) {
            throw new BadParameterException("key is empty");
        }
        try {
            PluginConfigAdapter adapter = new PluginConfigAdapter(interfaceName, displayName);
            return adapter.resetValue(key);
        }
        catch (ClassNotFoundException e) {
            throw new BadParameterException((Throwable)e, "reset:interface:" + interfaceName + "|displayName:" + displayName + "|key:" + key);
        }
    }

    @Override
    public Object get(String interfaceName, String displayName, String key) throws BadParameterException {
        try {
            PluginConfigAdapter wrapper = new PluginConfigAdapter(interfaceName, displayName);
            return wrapper.getValue(key);
        }
        catch (ClassNotFoundException e) {
            throw new BadParameterException((Throwable)e, "get:interface:" + interfaceName + "|displayName:" + displayName + "|key:" + key);
        }
    }

    private List<LazyPlugin<?>> getAllPlugins() {
        ArrayList results = new ArrayList();
        results.addAll(HostPluginController.getInstance().list());
        results.addAll(CrawlerPluginController.getInstance().list());
        return results;
    }
}

