/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.system;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jd.SecondLevelLaunch;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.linkcollector.LinkCollector;
import org.appwork.exceptions.WTFException;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.utils.Application;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.ProcMounts;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.ContainerRuntime;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.os.Snap;
import org.appwork.utils.os.hardware.HardwareType;
import org.appwork.utils.os.hardware.HardwareTypeInterface;
import org.jdownloader.api.RemoteAPIController;
import org.jdownloader.api.system.SystemAPI;
import org.jdownloader.api.system.SystemAPIImpl17;
import org.jdownloader.myjdownloader.client.bindings.StorageInformationStorable;
import org.jdownloader.myjdownloader.client.bindings.SystemInformationStorable;
import org.jdownloader.myjdownloader.client.bindings.interfaces.SystemInterface;
import org.jdownloader.updatev2.ForcedShutdown;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.RestartRequest;
import org.jdownloader.updatev2.SmartRlyExitRequest;
import org.jdownloader.updatev2.SmartRlyRestartRequest;

public class SystemAPIImpl
implements SystemAPI {
    private static final List<String> fileSystemFilters;
    private static final List<String> pathFilters;

    public SystemAPIImpl() {
        RemoteAPIController.validateInterfaces(SystemAPI.class, SystemInterface.class);
    }

    @Override
    public void shutdownOS(final boolean force) throws InterruptedException {
        this.stopJD();
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            public int getHookPriority() {
                return Integer.MIN_VALUE;
            }

            public void onShutdown(ShutdownRequest shutdownRequest) {
                try {
                    CrossSystem.shutdownSystem((boolean)force);
                }
                catch (InterruptedException e) {
                    throw new WTFException((Throwable)e);
                }
            }
        });
        RestartController.getInstance().exitAsynch((ShutdownRequest)new ForcedShutdown());
    }

    @Override
    public void standbyOS() throws InterruptedException {
        this.stopJD();
        CrossSystem.standbySystem();
    }

    @Override
    public void hibernateOS() throws InterruptedException {
        this.stopJD();
        CrossSystem.hibernateSystem();
    }

    private void stopJD() throws InterruptedException {
        DownloadWatchDog.getInstance().stopDownloads();
        LinkCollector.getInstance().abort();
        for (int maxWait = 5000; !DownloadWatchDog.getInstance().isIdle() && maxWait >= 0; maxWait -= 500) {
            Thread.sleep(500L);
        }
    }

    @Override
    public void restartJD() throws InterruptedException {
        this.stopJD();
        RestartController.getInstance().asyncRestart((RestartRequest)new SmartRlyRestartRequest());
    }

    @Override
    public void exitJD() throws InterruptedException {
        this.stopJD();
        RestartController.getInstance().exitAsynch((ShutdownRequest)new SmartRlyExitRequest());
    }

    @Override
    public List<StorageInformationStorable> getStorageInfos(String path) {
        if (JVMVersion.isMinimum((long)JVMVersion.JAVA_1_7)) {
            return SystemAPIImpl17.getStorageInfos(path);
        }
        return SystemAPIImpl.getStorageInfos16(path);
    }

    public static List<StorageInformationStorable> getStorageInfos16(String path) {
        ArrayList<StorageInformationStorable> ret = new ArrayList<StorageInformationStorable>();
        ArrayList<File> roots = new ArrayList<File>();
        if (StringUtils.isNotEmpty((String)path)) {
            roots.add(new File(path));
        }
        if (roots.size() == 0) {
            File[] fileRoots;
            if (CrossSystem.isUnix()) {
                try {
                    List procMounts = ProcMounts.list();
                    if (procMounts != null) {
                        for (ProcMounts procMount : procMounts) {
                            if (procMount.isReadOnly() || SystemAPIImpl.isFilteredFileSystem(procMount.getFileSystem()) || SystemAPIImpl.isFilteredPath(procMount.getMountPoint())) continue;
                            String mountPoint = procMount.getMountPoint();
                            roots.add(new File(mountPoint));
                        }
                    }
                }
                catch (IOException procMounts) {
                    // empty catch block
                }
            }
            if (roots.size() == 0 && (fileRoots = File.listRoots()) != null) {
                roots.addAll(Arrays.asList(fileRoots));
            }
        }
        for (File root : roots) {
            StorageInformationStorable storage = new StorageInformationStorable();
            storage.setPath(root.getPath());
            storage.setSize(root.getTotalSpace());
            storage.setFree(root.getUsableSpace());
            ret.add(storage);
        }
        return ret;
    }

    protected static boolean isFilteredFileSystem(String fileSystem) {
        return fileSystemFilters.size() > 0 && fileSystemFilters.contains(fileSystem);
    }

    protected static boolean isFilteredPath(String path) {
        if (pathFilters.size() > 0 && path != null) {
            for (String pathFilter : pathFilters) {
                if (!path.startsWith(pathFilter)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public SystemInformationStorable getSystemInfos() {
        SystemInformationStorable ret = new SystemInformationStorable();
        CrossSystem.OperatingSystem os = CrossSystem.getOS();
        ret.setOperatingSystem(os.name());
        ret.setOsFamily(os.getFamily().name());
        try {
            HardwareTypeInterface hardwareType = HardwareType.getHardware();
            if (hardwareType != null) {
                ret.setHardware(hardwareType.toString());
            }
        }
        catch (Throwable ignore) {
            LoggerFactory.getDefaultLogger().log(ignore);
        }
        try {
            ret.setDocker(ContainerRuntime.isInsideDocker());
        }
        catch (Throwable ignore) {
            LoggerFactory.getDefaultLogger().log(ignore);
        }
        try {
            ret.setSnap(Snap.isInsideSnap());
        }
        catch (Throwable ignore) {
            LoggerFactory.getDefaultLogger().log(ignore);
        }
        ret.setOsString(CrossSystem.getOSString());
        ret.setArchFamily(CrossSystem.getARCHFamily().name());
        ret.setArchString(CrossSystem.getARCHString());
        ret.setJavaVersion(Application.getJavaVersion());
        ret.setJavaVersionString(Application.getJVMVersion());
        ret.setJvm64Bit(Application.is64BitJvm());
        String javaVendor = System.getProperty("java.vm.vendor");
        if (javaVendor == null && (javaVendor = System.getProperty("java.vendor")) == null) {
            javaVendor = System.getProperty("java.specification.vendor");
        }
        ret.setJavaVendor(javaVendor);
        String javaName = System.getProperty("java.vm.name");
        if (javaName == null) {
            javaName = System.getProperty("java.runtime.name");
        }
        ret.setJavaName(javaName);
        ret.setHeadless(Application.isHeadless());
        ret.setOs64Bit(CrossSystem.is64BitOperatingSystem());
        ret.setArch64Bit(CrossSystem.is64BitArch());
        ret.setStartupTimeStamp(SecondLevelLaunch.startup);
        try {
            MemoryUsage memory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            if (memory != null) {
                ret.setHeapUsed(memory.getUsed());
                ret.setHeapCommitted(memory.getCommitted());
                ret.setHeapMax(memory.getMax());
            }
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        return ret;
    }

    static {
        if (CrossSystem.isUnix()) {
            fileSystemFilters = Arrays.asList("usbfs", "fusectl", "hugetlbfs", "binfmt_misc", "cgroup", "pstore", "sysfs", "tmpfs", "proc", "configfs", "debugfs", "mqueue", "devtmpfs", "devpts", "devfs", "securityfs", "nfsd", "fusectl", "fuse.gvfsd-fuse", "rpc_pipefs", "efivarfs", "fuse.lxcfs", "nsfs", "squashfs");
            pathFilters = Arrays.asList("/proc", "/boot", "/sys", "/dev", "/etc", "/run/user", "/usr/lib", "/usr/src", "/var/lib", "/var/log", "/var/tmp");
        } else {
            fileSystemFilters = new ArrayList<String>();
            pathFilters = new ArrayList<String>();
        }
    }
}

