/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.system;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.appwork.utils.Files17;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.api.system.SystemAPIImpl;
import org.jdownloader.logging.LogController;
import org.jdownloader.myjdownloader.client.bindings.StorageInformationStorable;

public class SystemAPIImpl17 {
    private static Path getPath(FileStore fileStore) {
        String rootPath;
        if (CrossSystem.isWindows()) {
            for (Path rootPath2 : FileSystems.getDefault().getRootDirectories()) {
                try {
                    if (!Files.isDirectory(rootPath2, new LinkOption[0]) || !Files.getFileStore(rootPath2).equals(fileStore)) continue;
                    return rootPath2;
                }
                catch (NoSuchFileException noSuchFileException) {
                }
                catch (IOException e) {
                    LogController.CL().log((Throwable)e);
                }
            }
        }
        if ((rootPath = new Regex(fileStore.toString(), "^\\s*(.*?) \\(.*?\\)\\s*$").getMatch(0)) != null) {
            return Paths.get(rootPath, new String[0]);
        }
        return null;
    }

    public static List<StorageInformationStorable> getStorageInfos(String path) {
        ArrayList<StorageInformationStorable> ret = new ArrayList<StorageInformationStorable>();
        LinkedHashMap<Path, FileStore> roots = new LinkedHashMap<Path, FileStore>();
        Path customPath = null;
        if (StringUtils.isNotEmpty((String)path)) {
            try {
                Path pathObj = Paths.get(path, new String[0]);
                roots.put(pathObj, Files.getFileStore(pathObj));
                customPath = pathObj;
            }
            catch (NoSuchFileException pathObj) {
            }
            catch (InvalidPathException e) {
                LogController.CL().log((Throwable)e);
            }
            catch (IOException e) {
                LogController.CL().log((Throwable)e);
            }
        }
        if (roots.isEmpty()) {
            for (FileStore fileStore : Files17.getFileStores()) {
                Path fileStorePath = SystemAPIImpl17.getPath(fileStore);
                if (fileStorePath == null || !Files.isDirectory(fileStorePath, new LinkOption[0])) continue;
                roots.put(fileStorePath, fileStore);
            }
        }
        for (Map.Entry entry : roots.entrySet()) {
            StorageInformationStorable storage = new StorageInformationStorable();
            Path root = (Path)entry.getKey();
            try {
                FileStore store = (FileStore)entry.getValue();
                if (!(customPath != null && customPath.equals(root) || !store.isReadOnly() && !SystemAPIImpl.isFilteredFileSystem(store.type()) && !SystemAPIImpl.isFilteredPath(root.toString()))) continue;
                storage.setPath(root.toString());
                storage.setSize(store.getTotalSpace());
                storage.setFree(store.getUsableSpace());
            }
            catch (IOException e) {
                LogController.CL().log((Throwable)e);
                if (storage.getPath() == null) {
                    storage.setPath(root.toString());
                }
                storage.setError(e.toString());
            }
            ret.add(storage);
        }
        return ret;
    }
}

