/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.api.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.linkchecker.LinkChecker;
import jd.controlling.linkcrawler.CheckableLink;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.remoteapi.exceptions.BadParameterException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.gui.packagehistorycontroller.DownloadPathHistoryManager;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerSelectionInfo;
import org.jdownloader.gui.views.linkgrabber.addlinksdialog.LinkgrabberSettings;
import org.jdownloader.myjdownloader.client.bindings.CleanupActionOptions;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.translate._JDT;
import org.jdownloader.utils.JDFileUtils;

public class PackageControllerUtils<PackageType extends AbstractPackageNode<ChildType, PackageType>, ChildType extends AbstractPackageChildrenNode<PackageType>> {
    private final PackageController<PackageType, ChildType> packageController;

    public PackageControllerUtils(PackageController<PackageType, ChildType> packageController) {
        this.packageController = packageController;
    }

    public List<AbstractNode> getAbstractNodes(long[] linkIds, long[] packageIds) {
        ArrayList<AbstractNode> ret = new ArrayList<AbstractNode>();
        if (packageIds != null && packageIds.length > 0 || linkIds != null && linkIds.length > 0) {
            this.convertIdsToObjects(ret, linkIds, packageIds);
            if (ret.size() == 0) {
                this.convertIdsToObjects(ret, packageIds, linkIds);
            }
        }
        return ret;
    }

    public List<PackageType> getPackages(long ... packageIds) {
        ArrayList ret = new ArrayList();
        if (packageIds != null && packageIds.length > 0) {
            this.convertIdsToObjects(ret, null, packageIds);
        }
        return ret;
    }

    public List<ChildType> getChildren(long ... linkIds) {
        ArrayList ret = new ArrayList();
        if (linkIds != null && linkIds.length > 0) {
            this.convertIdsToObjects(ret, linkIds, null);
        }
        return ret;
    }

    public SelectionInfo<PackageType, ChildType> getSelectionInfo(long[] linkIds, long[] packageIds) {
        return new SelectionInfo(null, this.getAbstractNodes(linkIds, packageIds));
    }

    public PackageType getPackageInstanceByChildrenType(ChildType ct) {
        if (ct instanceof DownloadLink) {
            return (PackageType)FilePackage.getInstance();
        }
        if (ct instanceof CrawledLink) {
            return (PackageType)new CrawledPackage();
        }
        return null;
    }

    public PackageType getPackageInstance(PackageType ct) {
        if (ct instanceof FilePackage) {
            return (PackageType)FilePackage.getInstance();
        }
        if (ct instanceof CrawledPackage) {
            return (PackageType)new CrawledPackage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends AbstractNode> List<T> convertIdsToObjects(List<T> ret, long[] linkIds, long[] packageIds) {
        block15: {
            if (ret == null) {
                ret = new ArrayList<T>();
            }
            HashSet<Long> linklookUp = PackageControllerUtils.createLookupSet(linkIds);
            HashSet<Long> packageLookup = PackageControllerUtils.createLookupSet(packageIds);
            if (linklookUp != null || packageLookup != null) {
                boolean readL = this.packageController.readLock();
                try {
                    for (AbstractPackageNode pkg : this.packageController.getPackages()) {
                        System.out.println(pkg.getName() + " - " + pkg.getUniqueID().getID());
                        if (packageLookup != null && packageLookup.remove(pkg.getUniqueID().getID())) {
                            ret.add(pkg);
                            if (packageLookup == null || packageLookup.size() == 0) {
                                if (linklookUp == null) break;
                                if (linklookUp.size() == 0) {
                                    break;
                                }
                            }
                        }
                        if (linklookUp == null) continue;
                        boolean readL2 = pkg.getModifyLock().readLock();
                        try {
                            for (AbstractPackageChildrenNode child : pkg.getChildren()) {
                                if (!linklookUp.remove(child.getUniqueID().getID())) continue;
                                ret.add(child);
                                if (packageLookup != null && packageLookup.size() != 0 || linklookUp != null && linklookUp.size() != 0) {
                                    continue;
                                }
                                break block15;
                            }
                        }
                        finally {
                            pkg.getModifyLock().readUnlock(readL2);
                        }
                    }
                }
                finally {
                    this.packageController.readUnlock(readL);
                }
            }
        }
        return ret;
    }

    public static HashSet<Long> createLookupSet(long[] linkIds) {
        if (linkIds == null || linkIds.length == 0) {
            return null;
        }
        HashSet<Long> linkLookup = new HashSet<Long>();
        for (long l : linkIds) {
            linkLookup.add(l);
        }
        return linkLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComment(long[] linkIds, long[] packageIds, boolean allPackageLinks, String comment) {
        SelectionInfo<PackageType, ChildType> selectionInfo = this.getSelectionInfo(linkIds, packageIds);
        List<AbstractNode> nodes = selectionInfo.getRawSelection();
        for (AbstractNode node : nodes) {
            boolean readL;
            if (node instanceof DownloadLink) {
                ((DownloadLink)node).setComment(comment);
                continue;
            }
            if (node instanceof CrawledLink) {
                ((CrawledLink)node).setComment(comment);
                continue;
            }
            if (node instanceof FilePackage) {
                FilePackage fp = (FilePackage)node;
                fp.setComment(comment);
                if (!allPackageLinks) continue;
                readL = fp.getModifyLock().readLock();
                try {
                    for (DownloadLink downloadLink : fp.getChildren()) {
                        downloadLink.setComment(comment);
                    }
                    continue;
                }
                finally {
                    fp.getModifyLock().readUnlock(readL);
                    continue;
                }
            }
            if (!(node instanceof CrawledPackage)) continue;
            CrawledPackage cp = (CrawledPackage)node;
            cp.setComment(comment);
            if (!allPackageLinks) continue;
            readL = cp.getModifyLock().readLock();
            try {
                for (CrawledLink crawledLink : cp.getChildren()) {
                    crawledLink.setComment(comment);
                }
            }
            finally {
                cp.getModifyLock().readUnlock(readL);
            }
        }
    }

    public void setEnabled(boolean enabled, long[] linkIds, long[] packageIds) {
        List<ChildType> sdl = this.getSelectionInfo(linkIds, packageIds).getChildren();
        for (AbstractPackageChildrenNode dl : sdl) {
            dl.setEnabled(enabled);
        }
    }

    public void movePackages(long[] packageIds, long afterDestPackageId) {
        List<PackageType> packages;
        List<PackageType> selectedPackages = this.getPackages(packageIds);
        AbstractPackageNode afterDestPackage = null;
        if (afterDestPackageId > 0L && (packages = this.getPackages(afterDestPackageId)).size() > 0) {
            afterDestPackage = (AbstractPackageNode)packages.get(0);
        }
        this.packageController.move(selectedPackages, afterDestPackage);
    }

    public void moveChildren(long[] linkIds, long afterLinkID, long destPackageID) {
        List<PackageType> packages = this.getPackages(destPackageID);
        if (packages.size() > 0) {
            List<ChildType> children;
            List<ChildType> selectedLinks = this.getChildren(linkIds);
            AbstractPackageChildrenNode afterLink = null;
            AbstractPackageNode destpackage = (AbstractPackageNode)packages.get(0);
            if (afterLinkID > 0L && (children = this.getChildren(afterLinkID)).size() > 0) {
                afterLink = (AbstractPackageChildrenNode)children.get(0);
            }
            this.packageController.move(selectedLinks, destpackage, afterLink);
        }
    }

    public long getChildrenChanged(long structureWatermark) {
        if (this.packageController.getBackendChanged() != structureWatermark) {
            return this.packageController.getBackendChanged();
        }
        return -1L;
    }

    public void remove(long[] linkIds, long[] packageIds) {
        List<ChildType> children = this.getChildren(linkIds);
        List<PackageType> packages = this.getPackages(packageIds);
        this.packageController.removeChildren(children);
        for (AbstractPackageNode pkg : packages) {
            this.packageController.removePackage(pkg);
        }
    }

    public void startOnlineStatusCheck(long[] linkIds, long[] packageIds) {
        SelectionInfo<PackageType, ChildType> selection = this.getSelectionInfo(linkIds, packageIds);
        List<ChildType> children = selection.getChildren();
        ArrayList<CheckableLink> checkableLinks = new ArrayList<CheckableLink>(children.size());
        for (AbstractPackageChildrenNode l : children) {
            if (!(l instanceof CheckableLink)) continue;
            checkableLinks.add((CheckableLink)((Object)l));
        }
        if (checkableLinks.size() > 0) {
            LinkChecker<ArrayList<CheckableLink>> linkChecker = new LinkChecker<ArrayList<CheckableLink>>(true);
            linkChecker.check(checkableLinks);
        }
    }

    public HashMap<Long, String> getDownloadUrls(long[] linkIds, long[] packageIds) {
        SelectionInfo<PackageType, ChildType> selection = this.getSelectionInfo(linkIds, packageIds);
        List<ChildType> children = selection.getChildren();
        HashMap<Long, String> result = new HashMap<Long, String>();
        for (AbstractPackageChildrenNode l : children) {
            AbstractPackageChildrenNode<FilePackage> link;
            if (l instanceof DownloadLink) {
                link = (DownloadLink)l;
                result.put(((DownloadLink)link).getUniqueID().getID(), ((DownloadLink)link).getPluginPatternMatcher());
                continue;
            }
            if (!(l instanceof CrawledLink)) continue;
            link = (CrawledLink)l;
            result.put(((CrawledLink)link).getUniqueID().getID(), ((CrawledLink)link).getURL());
        }
        return result;
    }

    public void movetoNewPackage(long[] linkIds, long[] pkgIds, String newPkgName, String downloadPath) throws BadParameterException {
        PackageType newPackage;
        newPkgName = StringUtils.nullify((String)newPkgName);
        downloadPath = StringUtils.nullify((String)downloadPath);
        if (StringUtils.isEmpty((String)newPkgName)) {
            throw new BadParameterException("empty package name");
        }
        SelectionInfo<PackageType, ChildType> selection = this.getSelectionInfo(linkIds, pkgIds);
        if (selection.getChildren().size() > 0 && (newPackage = this.getPackageInstanceByChildrenType((AbstractPackageChildrenNode)selection.getChildren().get(0))) != null) {
            this.setPackageName(newPackage, newPkgName);
            if (!StringUtils.isEmpty((String)downloadPath) && !StringUtils.equalsIgnoreCase((String)downloadPath, (String)"<DEFAULT PATH>")) {
                this.setDirectory(newPackage, downloadPath);
            }
            this.packageController.moveOrAddAt(newPackage, selection.getChildren(), 0, -1);
        }
    }

    public PackageType setPackageName(final PackageType pt, final String pkgName) {
        if (pt.getControlledBy() == null) {
            if (pt instanceof FilePackage) {
                ((FilePackage)pt).setName(pkgName);
            } else if (pt instanceof CrawledPackage) {
                ((CrawledPackage)pt).setName(pkgName);
            }
        } else {
            this.packageController.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    if (pt instanceof FilePackage) {
                        ((FilePackage)pt).setName(pkgName);
                    } else if (pt instanceof CrawledPackage) {
                        ((CrawledPackage)pt).setName(pkgName);
                    }
                    return null;
                }
            });
        }
        return pt;
    }

    public PackageType copyPropertiesTo(PackageType sourcePkg, PackageType destPkg) {
        if (sourcePkg instanceof FilePackage && destPkg instanceof FilePackage) {
            ((FilePackage)sourcePkg).copyPropertiesTo((FilePackage)destPkg);
        } else if (sourcePkg instanceof CrawledPackage && destPkg instanceof CrawledPackage) {
            ((CrawledPackage)sourcePkg).copyPropertiesTo((CrawledPackage)destPkg);
        } else {
            throw new IllegalArgumentException("source and destination package not the same types");
        }
        return destPkg;
    }

    protected void setDirectory(PackageType pt, final String directory) {
        DownloadPathHistoryManager.getInstance().add(directory);
        if (pt instanceof FilePackage) {
            FilePackage fp = (FilePackage)pt;
            String finalDirectory = PackagizerController.replaceDynamicTags(directory, fp.getName(), fp);
            if (fp.getControlledBy() == null) {
                fp.setDownloadDirectory(finalDirectory);
            } else {
                DownloadWatchDog.getInstance().setDownloadDirectory(fp, finalDirectory);
            }
        } else if (pt instanceof CrawledPackage) {
            final CrawledPackage cp = (CrawledPackage)pt;
            if (pt.getControlledBy() == null) {
                cp.setDownloadFolder(directory);
            } else {
                this.packageController.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        cp.setDownloadFolder(directory);
                        return null;
                    }
                });
            }
        }
    }

    public void splitPackageByHoster(long[] linkIds, long[] pkgIds) {
        SelectionInfo<PackageType, ChildType> selection = this.getSelectionInfo(linkIds, pkgIds);
        HashMap splitMap = new HashMap();
        int insertAt = -1;
        for (AbstractNode child : selection.getChildren()) {
            String host;
            ArrayList<AbstractPackageChildrenNode> hostList;
            AbstractPackageChildrenNode cL = (AbstractPackageChildrenNode)child;
            AbstractPackageNode parent = (AbstractPackageNode)cL.getParentNode();
            HashMap<String, ArrayList<AbstractPackageChildrenNode>> parentMap = (HashMap<String, ArrayList<AbstractPackageChildrenNode>>)splitMap.get(parent);
            if (parentMap == null) {
                parentMap = new HashMap<String, ArrayList<AbstractPackageChildrenNode>>();
                splitMap.put(parent, parentMap);
            }
            if ((hostList = (ArrayList<AbstractPackageChildrenNode>)parentMap.get(host = cL.getDomainInfo().getTld())) == null) {
                hostList = new ArrayList<AbstractPackageChildrenNode>();
                parentMap.put(host, hostList);
            }
            hostList.add(cL);
        }
        String nameFactory = ((LinkgrabberSettings)JsonConfig.create(LinkgrabberSettings.class)).getSplitPackageNameFactoryPattern();
        for (Map.Entry next : splitMap.entrySet()) {
            AbstractPackageNode sourcePackage = (AbstractPackageNode)next.getKey();
            HashMap items = (HashMap)next.getValue();
            for (Map.Entry next2 : items.entrySet()) {
                String host = (String)next2.getKey();
                String newPackageName = this.getNewPackageName(nameFactory, sourcePackage.getName(), host);
                PackageType newPkg = this.getPackageInstanceByChildrenType((AbstractPackageChildrenNode)((ArrayList)next2.getValue()).get(0));
                this.copyPropertiesTo(sourcePackage, newPkg);
                this.setPackageName(newPkg, newPackageName);
                this.packageController.moveOrAddAt(newPkg, (List)next2.getValue(), 0, insertAt);
                ++insertAt;
            }
        }
    }

    public String getNewPackageName(String nameFactory, String oldPackageName, String host) {
        if (StringUtils.isEmpty((String)nameFactory)) {
            if (!StringUtils.isEmpty((String)oldPackageName)) {
                return oldPackageName;
            }
            return host;
        }
        nameFactory = !StringUtils.isEmpty((String)oldPackageName) ? nameFactory.replaceAll("\\{PACKAGENAME\\}", oldPackageName) : nameFactory.replaceAll("\\{PACKAGENAME\\}", _JDT.T.LinkCollector_addCrawledLink_variouspackage());
        nameFactory = nameFactory.replaceAll("\\{HOSTNAME\\}", host);
        return nameFactory;
    }

    public void setDownloadDirectory(String directory, long[] packageIds) {
        SelectionInfo<PackageType, ChildType> selection = this.getSelectionInfo(new long[0], packageIds);
        for (SelectionInfo.PackageView<PackageType, ChildType> pkg : selection.getPackageViews()) {
            if (!pkg.isPackageSelected()) continue;
            PackageType pt = pkg.getPackage();
            this.setDirectory(pt, directory);
        }
    }

    public boolean setDownloadPassword(long[] linkIds, long[] pkgIds, String pass) throws BadParameterException {
        SelectionInfo<PackageType, ChildType> selection = this.getSelectionInfo(linkIds, pkgIds);
        List<ChildType> children = selection.getChildren();
        if (children.isEmpty()) {
            throw new BadParameterException("empty selection");
        }
        for (AbstractPackageChildrenNode child : children) {
            if (child instanceof DownloadLink) {
                ((DownloadLink)child).setDownloadPassword(pass);
                continue;
            }
            if (!(child instanceof CrawledLink)) continue;
            ((CrawledLink)child).getDownloadLink().setDownloadPassword(pass);
        }
        return true;
    }

    public boolean cleanup(long[] linkIds, long[] pkgIds, CleanupActionOptions.Action action, CleanupActionOptions.Mode mode, CleanupActionOptions.SelectionType selectionType) throws BadParameterException {
        SelectionInfo selection = CleanupActionOptions.SelectionType.ALL.equals((Object)selectionType) ? new PackageControllerSelectionInfo<PackageType, ChildType>(this.packageController) : this.getSelectionInfo(linkIds, pkgIds);
        if (selection.isEmpty()) {
            return false;
        }
        ArrayList<DownloadLink> nodesToDelete = new ArrayList<DownloadLink>();
        switch (selectionType) {
            case ALL: 
            case SELECTED: {
                for (AbstractPackageChildrenNode ct : selection.getChildren()) {
                    if (!this.shouldDeleteLink(action, ct)) continue;
                    nodesToDelete.add((DownloadLink)ct);
                }
                break;
            }
            case UNSELECTED: {
                throw new BadParameterException("SelectionType UNSELECTED not yet supported");
            }
            case NONE: {
                return false;
            }
        }
        if (nodesToDelete.size() > 0) {
            this.packageController.removeChildren(nodesToDelete);
            if (nodesToDelete.get(0) instanceof DownloadLink) {
                ArrayList<DownloadLink> links = nodesToDelete;
                switch (mode) {
                    case REMOVE_LINKS_ONLY: {
                        break;
                    }
                    case REMOVE_LINKS_AND_DELETE_FILES: {
                        DownloadWatchDog.getInstance().delete(links, FileCreationManager.DeleteOption.NULL);
                        break;
                    }
                    case REMOVE_LINKS_AND_RECYCLE_FILES: {
                        DownloadWatchDog.getInstance().delete(links, JDFileUtils.isTrashSupported() ? FileCreationManager.DeleteOption.RECYCLE : FileCreationManager.DeleteOption.NULL);
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected boolean shouldDeleteLink(CleanupActionOptions.Action action, ChildType ct) {
        switch (action) {
            case DELETE_ALL: {
                return true;
            }
            case DELETE_DISABLED: {
                return !ct.isEnabled();
            }
            case DELETE_FAILED: {
                if (ct instanceof DownloadLink) {
                    return FinalLinkState.CheckFailed(((DownloadLink)ct).getFinalLinkState());
                }
                return false;
            }
            case DELETE_FINISHED: {
                if (ct instanceof DownloadLink) {
                    return FinalLinkState.CheckFinished(((DownloadLink)ct).getFinalLinkState());
                }
                return false;
            }
            case DELETE_OFFLINE: {
                if (ct instanceof DownloadLink) {
                    return ((DownloadLink)ct).getFinalLinkState() == FinalLinkState.OFFLINE;
                }
                if (ct instanceof CrawledLink) {
                    return ((CrawledLink)ct).getDownloadLink().getAvailableStatus() == DownloadLink.AvailableStatus.FALSE;
                }
                return false;
            }
            case DELETE_DUPE: {
                if (ct instanceof CrawledLink) {
                    return DownloadController.getInstance().hasDownloadLinkByID(((CrawledLink)ct).getLinkID());
                }
                return false;
            }
        }
        return false;
    }
}

