/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.api;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import jd.http.Browser;
import org.appwork.remoteapi.exceptions.FileNotFound404Exception;
import org.appwork.remoteapi.exceptions.InternalApiException;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.DomainInfo;
import org.jdownloader.captcha.api.CaptchaForwarderAPIInterface;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.CaptchaHelperCrawlerPluginRecaptchaV2;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.logging.LogController;

public class CaptchaForwarder
implements CaptchaForwarderAPIInterface {
    private static final CaptchaForwarder INSTANCE = new CaptchaForwarder();
    private static final AtomicLong ID = new AtomicLong(System.currentTimeMillis());
    private ThreadPoolExecutor runner;
    private final ConcurrentHashMap<Long, Job> done = new ConcurrentHashMap();

    public static CaptchaForwarder getInstance() {
        return INSTANCE;
    }

    private CaptchaForwarder() {
    }

    public void runEntry(Job job) {
        try {
            job.result = job.run();
        }
        catch (Exception e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
            job.exception = e;
        }
        finally {
            this.done.put(job.id, job);
        }
    }

    @Override
    public long createJobRecaptchaV2(final String lsiteKey, final String stoken, final String domain, String reason) {
        return this.enqueue(new Job(ID.incrementAndGet()){

            @Override
            public String run() throws Exception {
                return new CaptchaHelperCrawlerPluginRecaptchaV2(null, new Browser()){

                    @Override
                    public String getSiteDomain() {
                        return domain;
                    }

                    @Override
                    public String getSiteKey() {
                        return lsiteKey;
                    }

                    @Override
                    protected RecaptchaV2Challenge createChallenge() {
                        return new RecaptchaV2Challenge(lsiteKey, stoken, null, this.br, this.getSiteDomain()){

                            @Override
                            public DomainInfo getDomainInfo() {
                                return DomainInfo.getInstance(domain);
                            }

                            @Override
                            public int getTimeout() {
                                return 300000;
                            }

                            @Override
                            public String getHost() {
                                return domain;
                            }

                            @Override
                            protected LogInterface getLogger() {
                                return LogController.CL();
                            }
                        };
                    }
                }.getToken();
            }
        });
    }

    private long enqueue(Job job) {
        this.ensureRunner().execute(this.createRunnable(job));
        return job.id;
    }

    private Runnable createRunnable(final Job job) {
        return new Runnable(){

            @Override
            public void run() {
                CaptchaForwarder.this.runEntry(job);
            }
        };
    }

    private synchronized ThreadPoolExecutor ensureRunner() {
        if (this.runner == null) {
            this.runner = new ThreadPoolExecutor(8, 8, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024));
        }
        return this.runner;
    }

    @Override
    public String getResult(long jobID) throws FileNotFound404Exception, InternalApiException {
        Job job = this.done.remove(jobID);
        if (job == null) {
            throw new FileNotFound404Exception();
        }
        if (job.exception != null) {
            throw new InternalApiException((Throwable)job.exception);
        }
        return job.result;
    }

    abstract class Job {
        public Exception exception;
        private long id;
        public String result;

        public abstract String run() throws Exception;

        public Job(long id) {
            this.id = id;
        }
    }
}

