/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.blacklist;

import java.lang.ref.WeakReference;
import jd.controlling.captcha.SkipRequest;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.plugins.Plugin;
import jd.plugins.PluginForDecrypt;
import org.jdownloader.captcha.blacklist.BlacklistEntry;
import org.jdownloader.captcha.v2.Challenge;

public class BlockAllCrawlerCaptchasEntry
implements BlacklistEntry {
    private final WeakReference<LinkCrawler> crawler;

    public BlockAllCrawlerCaptchasEntry(LinkCrawler crawler) {
        this.crawler = new WeakReference<LinkCrawler>(crawler);
    }

    @Override
    public boolean canCleanUp() {
        LinkCrawler lcrawler = this.getCrawler();
        return lcrawler == null || !lcrawler.isRunning();
    }

    public LinkCrawler getCrawler() {
        return (LinkCrawler)this.crawler.get();
    }

    public String toString() {
        LinkCrawler lcrawler = this.getCrawler();
        if (lcrawler != null) {
            return "BlockAllCrawlerCaptchasEntry:" + lcrawler.getCreated();
        }
        return "BlockAllCrawlerCaptchasEntry";
    }

    public boolean matches(Challenge c) {
        Plugin plugin;
        LinkCrawler lcrawler = this.getCrawler();
        if (lcrawler != null && lcrawler.isRunning() && (plugin = c.getPlugin()) instanceof PluginForDecrypt) {
            return ((PluginForDecrypt)plugin).getCrawler() == lcrawler;
        }
        return false;
    }

    @Override
    public SkipRequest getSkipRequest() {
        return SkipRequest.BLOCK_ALL_CAPTCHAS;
    }
}

