/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.blacklist;

import java.lang.ref.WeakReference;
import jd.controlling.captcha.SkipRequest;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.jdownloader.captcha.blacklist.CaptchaBlackList;
import org.jdownloader.captcha.blacklist.SessionBlackListEntry;
import org.jdownloader.captcha.v2.Challenge;

public class BlockDownloadCaptchasByLink
implements SessionBlackListEntry<Object> {
    private final WeakReference<DownloadLink> downloadLink;
    private final SkipRequest skipRequest;

    public BlockDownloadCaptchasByLink(SkipRequest skipRequest, DownloadLink downloadLink) {
        this.downloadLink = new WeakReference<DownloadLink>(downloadLink);
        this.skipRequest = skipRequest;
    }

    @Override
    public boolean canCleanUp() {
        DownloadLink link = this.getDownloadLink();
        return link == null || FilePackage.isDefaultFilePackage(link.getFilePackage()) || CaptchaBlackList.getInstance().isWhitelisted(link);
    }

    public DownloadLink getDownloadLink() {
        return (DownloadLink)this.downloadLink.get();
    }

    public String toString() {
        DownloadLink link = this.getDownloadLink();
        if (link != null) {
            return "BlockDownloadCaptchasByLink:" + (Object)((Object)link.getUniqueID());
        }
        return "BlockDownloadCaptchasByLink";
    }

    @Override
    public boolean matches(Challenge<Object> c) {
        DownloadLink link = this.getDownloadLink();
        if (link != null) {
            return link == c.getDownloadLink();
        }
        return false;
    }

    @Override
    public SkipRequest getSkipRequest() {
        return this.skipRequest;
    }
}

