/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.blacklist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.WeakHashMap;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.PrePluginCheckDummyChallenge;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkCollectorCrawler;
import jd.controlling.linkcollector.LinkCollectorEvent;
import jd.controlling.linkcollector.LinkCollectorListener;
import jd.controlling.linkcrawler.CrawledLink;
import jd.plugins.DownloadLink;
import org.jdownloader.captcha.blacklist.BlacklistEntry;
import org.jdownloader.captcha.blacklist.SessionBlackListEntry;
import org.jdownloader.captcha.v2.Challenge;

public class CaptchaBlackList
implements DownloadWatchdogListener,
LinkCollectorListener {
    private static final CaptchaBlackList INSTANCE = new CaptchaBlackList();
    private final ArrayList<BlacklistEntry> entries = new ArrayList();
    private final WeakHashMap<DownloadLink, Object> whitelist = new WeakHashMap();

    private CaptchaBlackList() {
        DownloadWatchDog.getInstance().getEventSender().addListener(this);
        LinkCollector.getInstance().getEventsender().addListener(this);
    }

    public static CaptchaBlackList getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BlacklistEntry entry) {
        Object object;
        if (entry != null) {
            object = this.entries;
            synchronized (object) {
                this.entries.add(entry);
            }
        }
        object = this.whitelist;
        synchronized (object) {
            ArrayList<DownloadLink> rem = new ArrayList<DownloadLink>();
            for (DownloadLink link : this.whitelist.keySet()) {
                if (!entry.matches(new PrePluginCheckDummyChallenge(link))) continue;
                rem.add(link);
            }
            this.whitelist.keySet().removeAll(rem);
        }
    }

    public BlacklistEntry matches(Challenge<?> c) {
        if (c == null || c.isAccountLogin() || c.isCreatedInsideAccountChecker()) {
            return null;
        }
        return this.matches(c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlacklistEntry matches(Challenge<?> c, boolean bypasswhitelist) {
        DownloadLink link;
        if (c == null) return null;
        if (!bypasswhitelist && (link = c.getDownloadLink()) != null) {
            WeakHashMap<DownloadLink, Object> weakHashMap = this.whitelist;
            synchronized (weakHashMap) {
                if (this.whitelist.containsKey(link)) {
                    return null;
                }
            }
        }
        ArrayList<BlacklistEntry> arrayList = this.entries;
        synchronized (arrayList) {
            ArrayList<BlacklistEntry> cleanups = new ArrayList<BlacklistEntry>();
            try {
                BlacklistEntry e;
                block13: {
                    Iterator<BlacklistEntry> iterator = this.entries.iterator();
                    while (iterator.hasNext()) {
                        e = iterator.next();
                        if (e.canCleanUp()) {
                            cleanups.add(e);
                            continue;
                        }
                        if (!e.matches(c)) {
                            continue;
                        }
                        break block13;
                    }
                    return null;
                }
                BlacklistEntry blacklistEntry = e;
                return blacklistEntry;
            }
            finally {
                this.entries.removeAll(cleanups);
            }
        }
    }

    @Override
    public void onDownloadWatchdogDataUpdate() {
    }

    @Override
    public void onDownloadWatchdogStateIsIdle() {
    }

    @Override
    public void onDownloadWatchdogStateIsPause() {
    }

    @Override
    public void onDownloadWatchdogStateIsRunning() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDownloadWatchdogStateIsStopped() {
        Object object = this.entries;
        synchronized (object) {
            for (int index = this.entries.size() - 1; index >= 0; --index) {
                BlacklistEntry entry = this.entries.get(index);
                if (!entry.canCleanUp() && !(entry instanceof SessionBlackListEntry)) continue;
                this.entries.remove(index);
            }
        }
        object = this.whitelist;
        synchronized (object) {
            this.whitelist.clear();
        }
    }

    @Override
    public void onDownloadWatchdogStateIsStopping() {
    }

    @Override
    public void onDownloadControllerStart(SingleDownloadController downloadController, DownloadLinkCandidate candidate) {
    }

    @Override
    public void onDownloadControllerStopped(SingleDownloadController downloadController, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWhitelist(DownloadLink link) {
        if (this.matches(new PrePluginCheckDummyChallenge(link), true) != null) {
            WeakHashMap<DownloadLink, Object> weakHashMap = this.whitelist;
            synchronized (weakHashMap) {
                this.whitelist.put(link, this);
            }
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        ArrayList<BlacklistEntry> arrayList = this.entries;
        synchronized (arrayList) {
            for (int index = this.entries.size() - 1; index >= 0; --index) {
                if (!this.entries.get(index).canCleanUp()) continue;
                this.entries.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWhitelisted(DownloadLink downloadLink) {
        WeakHashMap<DownloadLink, Object> weakHashMap = this.whitelist;
        synchronized (weakHashMap) {
            return this.whitelist.containsKey(downloadLink);
        }
    }

    @Override
    public void onDownloadWatchDogPropertyChange(DownloadWatchDogProperty propertyChange) {
    }

    @Override
    public void onLinkCollectorAbort(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorFilteredLinksAvailable(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorFilteredLinksEmpty(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorDataRefresh(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorStructureRefresh(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorContentRemoved(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorContentAdded(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorLinkAdded(LinkCollectorEvent event, CrawledLink link) {
    }

    @Override
    public void onLinkCollectorDupeAdded(LinkCollectorEvent event, CrawledLink link) {
    }

    @Override
    public void onLinkCrawlerAdded(LinkCollectorCrawler crawler) {
    }

    @Override
    public void onLinkCrawlerStarted(LinkCollectorCrawler crawler) {
    }

    @Override
    public void onLinkCrawlerStopped(LinkCollectorCrawler crawler) {
        this.cleanup();
    }

    @Override
    public void onLinkCrawlerFinished() {
    }

    @Override
    public void onLinkCrawlerNewJob(LinkCollectingJob job) {
    }
}

