/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import jd.controlling.linkcrawler.CrawledLink;
import jd.gui.swing.dialog.DialogType;
import jd.gui.swing.jdgui.JDGui;
import jd.plugins.DownloadLink;
import jd.plugins.Plugin;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import net.miginfocom.swing.MigLayout;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.sunwrapper.sun.swing.SwingUtilities2Wrapper;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.DefaultButtonPanel;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.dimensor.DialogDimensor;
import org.appwork.utils.swing.dialog.dimensor.RememberLastDialogDimension;
import org.appwork.utils.swing.dialog.locator.DialogLocator;
import org.appwork.utils.swing.dialog.locator.RememberAbsoluteDialogLocator;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.DomainInfo;
import org.jdownloader.actions.AppAction;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.solver.CESChallengeSolver;
import org.jdownloader.captcha.v2.solver.gui.Header;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.HeaderScrollPane;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.BadgeIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.premium.PremiumInfoDialog;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.SoundSettings;
import org.jdownloader.settings.staticreferences.CFG_CAPTCHA;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public abstract class AbstractCaptchaDialog<T>
extends AbstractDialog<T> {
    protected boolean hideCaptchasForHost = false;
    protected boolean hideCaptchasForPackage = false;
    protected final String explain;
    protected boolean hideAllCaptchas;
    protected DomainInfo hosterInfo;
    protected JPanel iconPanel;
    protected Plugin plugin;
    protected boolean stopDownloads = false;
    protected DialogType type;
    protected boolean refresh;
    protected boolean stopCrawling;
    protected boolean stopShowingCrawlerCaptchas;
    protected final Challenge<T> challenge;
    protected MouseMotionListener mouseMotionListener;
    protected MouseListener mouseListener;

    protected WindowManager.FrameState getWindowStateOnVisible() {
        return AbstractCaptchaDialog.getWindowState();
    }

    public boolean isExpired(long currentTimeout) {
        boolean is = super.isExpired(currentTimeout);
        boolean cesActive = false;
        SolverJob<T> job = this.challenge.getJob();
        if (this.challenge != null) {
            for (ChallengeSolver<T> s : this.challenge.getJob().getSolverList()) {
                if (!(s instanceof CESChallengeSolver) || this.challenge.getJob().isDone(s)) continue;
                cesActive = true;
            }
        }
        return is && !cesActive;
    }

    public String formatCountdown(long currentTimeout) {
        if (currentTimeout < 0L) {
            return "wait for C.E.S.";
        }
        return super.formatCountdown(currentTimeout);
    }

    protected T createReturnValue() {
        return null;
    }

    protected void createPopup() {
        JPopupMenu popup = new JPopupMenu();
        if (this.getType() == DialogType.HOSTER) {
            JMenuItem mi = new JMenuItem((Action)((Object)new AppAction(){
                {
                    this.setName(_GUI.T.AbstractCaptchaDialog_createPopup_skip_and_disable_all_downloads_from(AbstractCaptchaDialog.this.getHost()));
                    try {
                        this.setSmallIcon(AbstractCaptchaDialog.this.getDomainInfo().getIcon(16));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }

                public void actionPerformed(ActionEvent e) {
                    AbstractCaptchaDialog.this.hideCaptchasForHost = true;
                    AbstractCaptchaDialog.this.setReturnmask(false);
                    AbstractCaptchaDialog.this.dispose();
                }
            }));
            popup.add(mi);
            mi = new JMenuItem((Action)((Object)new AppAction(){
                {
                    this.setName(_GUI.T.AbstractCaptchaDialog_createPopup_skip_and_disable_package(AbstractCaptchaDialog.this.getPackageName()));
                    this.setSmallIcon((Icon)((Object)new BadgeIcon("package_open", "skipped", 16)));
                }

                public void actionPerformed(ActionEvent e) {
                    AbstractCaptchaDialog.this.hideCaptchasForPackage = true;
                    AbstractCaptchaDialog.this.setReturnmask(false);
                    AbstractCaptchaDialog.this.dispose();
                }
            }));
            popup.add(mi);
            mi = new JMenuItem((Action)((Object)new AppAction(){
                {
                    this.setName(_GUI.T.AbstractCaptchaDialog_createPopup_skip_and_hide_all_captchas_download());
                    this.setSmallIcon(NewTheme.I().getIcon("clear", 16));
                }

                public void actionPerformed(ActionEvent e) {
                    AbstractCaptchaDialog.this.hideAllCaptchas = true;
                    AbstractCaptchaDialog.this.setReturnmask(false);
                    AbstractCaptchaDialog.this.dispose();
                }
            }));
            popup.add(mi);
            mi = new JMenuItem((Action)((Object)new AppAction(){
                {
                    this.setName(_GUI.T.AbstractCaptchaDialog_createPopup_skip_and_stop_all_downloads());
                    this.setSmallIcon(new AbstractIcon("stop", 16));
                }

                public void actionPerformed(ActionEvent e) {
                    AbstractCaptchaDialog.this.stopDownloads = true;
                    AbstractCaptchaDialog.this.setReturnmask(false);
                    AbstractCaptchaDialog.this.dispose();
                }
            }));
            popup.add(mi);
        } else {
            JMenuItem mi = new JMenuItem((Action)((Object)new AppAction(){
                {
                    this.setName(_GUI.T.AbstractCaptchaDialog_createPopup_cancel_linkgrabbing());
                    this.setSmallIcon(new AbstractIcon("stop", 16));
                }

                public void actionPerformed(ActionEvent e) {
                    AbstractCaptchaDialog.this.stopCrawling = true;
                    AbstractCaptchaDialog.this.setReturnmask(false);
                    AbstractCaptchaDialog.this.dispose();
                }
            }));
            popup.add(mi);
            mi = new JMenuItem((Action)((Object)new AppAction(){
                {
                    this.setName(_GUI.T.AbstractCaptchaDialog_createPopup_cancel_stop_showing_crawlercaptchs());
                    this.setSmallIcon(new AbstractIcon("find", 16));
                }

                public void actionPerformed(ActionEvent e) {
                    AbstractCaptchaDialog.this.stopShowingCrawlerCaptchas = true;
                    AbstractCaptchaDialog.this.setReturnmask(false);
                    AbstractCaptchaDialog.this.dispose();
                }
            }));
            popup.add(mi);
        }
        Insets insets = LAFOptions.getInstance().getExtension().customizePopupBorderInsets();
        Dimension pref = popup.getPreferredSize();
        pref.height = popup.getComponentCount() * 24 + insets.top + insets.bottom;
        popup.setPreferredSize(pref);
        popup.show(this.cancelButton, insets.left - pref.width + this.cancelButton.getWidth() + 8 + 5, this.cancelButton.getHeight());
    }

    public void onSetVisible(boolean b) {
        super.onSetVisible(b);
        if (b) {
            AbstractCaptchaDialog.playCaptchaSound();
        }
    }

    public Dialog.ModalityType getModalityType() {
        return Dialog.ModalityType.MODELESS;
    }

    public boolean isHideAllCaptchas() {
        return this.hideAllCaptchas;
    }

    public AbstractCaptchaDialog(Challenge<T> challenge, int flags, String title, DialogType type, DomainInfo domainInfo, String explain) {
        super(flags, title, null, _GUI.T.AbstractCaptchaDialog_AbstractCaptchaDialog_continue(), type == DialogType.CRAWLER ? _GUI.T.lit_cancel() : _GUI.T.AbstractCaptchaDialog_AbstractCaptchaDialog_cancel());
        this.challenge = challenge;
        if (((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).isCaptchaDialogUniquePositionByHosterEnabled()) {
            this.setLocator((DialogLocator)new RememberAbsoluteDialogLocator("CaptchaDialog_" + domainInfo.getTld()));
        } else {
            this.setLocator((DialogLocator)new RememberAbsoluteDialogLocator("CaptchaDialog"));
        }
        this.setDimensor((DialogDimensor)new RememberLastDialogDimension("Captcha-" + domainInfo.getTld()));
        this.explain = explain != null ? explain : challenge.getExplain();
        this.hosterInfo = domainInfo;
        this.type = type;
        this.setPlugin(challenge.getPlugin());
        if (!challenge.keepAlive()) {
            this.setCountdownPausable(false);
        }
    }

    protected Challenge<T> getChallenge() {
        return this.challenge;
    }

    public static WindowManager.FrameState getWindowState() {
        for (Window w : Window.getWindows()) {
            if (!WindowManager.getInstance().hasFocus(w)) continue;
            return WindowManager.FrameState.TO_FRONT_FOCUSED;
        }
        WindowManager.FrameState ret = (WindowManager.FrameState)CFG_GUI.NEW_DIALOG_FRAME_STATE.getValue();
        if (ret == null) {
            ret = WindowManager.FrameState.TO_FRONT;
        }
        switch (ret) {
            case OS_DEFAULT: 
            case TO_BACK: {
                JDGui.getInstance().flashTaskbar();
            }
        }
        return ret;
    }

    public static void playCaptchaSound() {
        URL soundUrl = null;
        if (((SoundSettings)JsonConfig.create(SoundSettings.class)).isCaptchaSoundEnabled() && (soundUrl = NewTheme.I().getURL("sounds/", "captcha", ".wav")) != null) {
            final URL finalSoundUrl = soundUrl;
            new Thread("Captcha Sound"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void run() {
                    block26: {
                        Clip clip;
                        AudioInputStream stream;
                        block25: {
                            stream = null;
                            clip = null;
                            stream = AudioSystem.getAudioInputStream(finalSoundUrl);
                            AudioFormat format = stream.getFormat();
                            DataLine.Info info = new DataLine.Info(Clip.class, format);
                            if (!AudioSystem.isLineSupported(info)) break block25;
                            clip = (Clip)AudioSystem.getLine(info);
                            clip.open(stream);
                            try {
                                FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
                                float db = 20.0f * (float)Math.log((float)((SoundSettings)JsonConfig.create(SoundSettings.class)).getCaptchaSoundVolume() / 100.0f);
                                gainControl.setValue(Math.max(-80.0f, db));
                                BooleanControl muteControl = (BooleanControl)clip.getControl(BooleanControl.Type.MUTE);
                                muteControl.setValue(true);
                                muteControl.setValue(false);
                            }
                            catch (Exception e) {
                                LoggerFactory.getDefaultLogger().log((Throwable)e);
                            }
                            final AtomicBoolean runningFlag = new AtomicBoolean(true);
                            clip.addLineListener(new LineListener(){

                                @Override
                                public void update(LineEvent event) {
                                    if (event.getType() == LineEvent.Type.STOP) {
                                        runningFlag.set(false);
                                    }
                                }
                            });
                            clip.start();
                            Thread.sleep(1000L);
                            while (clip.isRunning() && runningFlag.get()) {
                                Thread.sleep(100L);
                            }
                        }
                        try {
                            if (clip != null) {
                                Clip finalClip = clip;
                                Thread thread = new Thread(finalClip){
                                    final /* synthetic */ Clip val$finalClip;
                                    {
                                        this.val$finalClip = clip;
                                    }

                                    @Override
                                    public void run() {
                                        this.val$finalClip.close();
                                    }
                                };
                                thread.setName("AudioStop");
                                thread.setDaemon(true);
                                thread.start();
                                thread.join(2000L);
                            }
                        }
                        catch (Throwable finalClip) {
                            // empty catch block
                        }
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block26;
                        }
                        catch (Throwable finalClip) {}
                        break block26;
                        catch (Throwable e) {
                            try {
                                LoggerFactory.getDefaultLogger().log(e);
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (clip != null) {
                                        Clip finalClip = clip;
                                        Thread thread = new /* invalid duplicate definition of identical inner class */;
                                        thread.setName("AudioStop");
                                        thread.setDaemon(true);
                                        thread.start();
                                        thread.join(2000L);
                                    }
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                                try {
                                    if (stream != null) {
                                        stream.close();
                                    }
                                }
                                catch (Throwable throwable3) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            try {
                                if (clip != null) {
                                    Clip finalClip = clip;
                                    Thread thread = new /* invalid duplicate definition of identical inner class */;
                                    thread.setName("AudioStop");
                                    thread.setDaemon(true);
                                    thread.start();
                                    thread.join(2000L);
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                if (stream != null) {
                                    stream.close();
                                }
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            }.start();
        }
    }

    public boolean isStopCrawling() {
        return this.stopCrawling;
    }

    public boolean isStopShowingCrawlerCaptchas() {
        return this.stopShowingCrawlerCaptchas;
    }

    public void dispose() {
        if (!this.isInitialized()) {
            return;
        }
        super.dispose();
    }

    public String getCrawlerStatus() {
        switch (this.type) {
            case CRAWLER: {
                return ((PluginForDecrypt)this.plugin).getCrawlerStatusString();
            }
        }
        return null;
    }

    protected DefaultButtonPanel getDefaultButtonPanel() {
        DefaultButtonPanel ret = new DefaultButtonPanel("ins 0", "[]", "0[grow,fill]0"){

            public void addOKButton(JButton okButton) {
                ExtButton refreshBtn = new ExtButton((AbstractAction)((Object)new AppAction(){
                    {
                        this.setSmallIcon(new AbstractIcon("refresh", 18));
                        this.setTooltipText(_GUI.T.CaptchaDialog_layoutDialogContent_refresh());
                        KeyStroke ks = KeyStroke.getKeyStroke(CFG_GUI.CFG.getShortcutForCaptchaDialogRefresh());
                        if (ks == null) {
                            ks = KeyStroke.getKeyStroke("pressed F5");
                        }
                        this.setAccelerator(ks);
                    }

                    public void actionPerformed(ActionEvent e) {
                        AbstractCaptchaDialog.this.refresh = true;
                        AbstractCaptchaDialog.this.setReturnmask(false);
                        AbstractCaptchaDialog.this.dispose();
                    }
                })){

                    public int getTooltipDelay(Point mousePositionOnScreen) {
                        return 500;
                    }
                };
                refreshBtn.setRolloverEffectEnabled(true);
                super.add((Component)refreshBtn, (Object)"alignx right,width 28!");
                super.addOKButton(okButton);
            }

            public void addCancelButton(JButton cancelButton) {
                super.addCancelButton(cancelButton);
                JButton bt = new JButton((Icon)new AbstractIcon("popDownSmall", -1)){

                    @Override
                    public void setBounds(int x, int y, int width, int height) {
                        int delta = 5;
                        super.setBounds(x - delta, y, width + delta, height);
                    }
                };
                bt.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractCaptchaDialog.this.createPopup();
                    }
                });
                super.add((Component)bt, (Object)"gapleft 0,width 8!");
            }
        };
        ret.setOpaque(false);
        ExtButton premium = new ExtButton((AbstractAction)((Object)new AppAction(){
            private static final long serialVersionUID = -3551320196255605774L;
            {
                this.setName(_GUI.T.CaptchaDialog_getDefaultButtonPanel_premium());
            }

            public void actionPerformed(ActionEvent e) {
                if (CFG_CAPTCHA.CFG.isCancelDialogCountdownOnHateCaptchaClick()) {
                    AbstractCaptchaDialog.this.cancel();
                }
                PremiumInfoDialog d = new PremiumInfoDialog(AbstractCaptchaDialog.this.hosterInfo, _GUI.T.PremiumInfoDialog_PremiumInfoDialog_(AbstractCaptchaDialog.this.hosterInfo.getTld()), "CaptchaDialog");
                try {
                    Dialog.getInstance().showDialog((AbstractDialog)d);
                }
                catch (DialogClosedException e1) {
                    e1.printStackTrace();
                }
                catch (DialogCanceledException e1) {
                    e1.printStackTrace();
                }
            }
        }));
        premium.setCursor(Cursor.getPredefinedCursor(12));
        premium.setRolloverEffectEnabled(true);
        LazyHostPlugin plg = HostPluginController.getInstance().get(this.hosterInfo.getTld());
        if (plg != null && plg.isPremium() && CFG_GUI.CFG.isHateCaptchasTextInCaptchaDialogVisible()) {
            ret.add((Component)premium);
        }
        SwingUtils.setOpaque((JComponent)premium, (boolean)false);
        return ret;
    }

    public DomainInfo getDomainInfo() {
        return this.hosterInfo;
    }

    public long getFilesize() {
        switch (this.type) {
            case HOSTER: {
                if (this.plugin == null || ((PluginForHost)this.plugin).getDownloadLink() == null) {
                    return -1L;
                }
                return ((PluginForHost)this.plugin).getDownloadLink().getView().getBytesTotal();
            }
        }
        return -1L;
    }

    public String getHelpText() {
        return this.explain;
    }

    public String getHost() {
        switch (this.type) {
            case HOSTER: {
                return ((PluginForHost)this.plugin).getHost(((PluginForHost)this.plugin).getDownloadLink(), null, false);
            }
            case CRAWLER: 
            case ACCOUNT: {
                return this.plugin.getHost();
            }
        }
        return this.challenge.getHost();
    }

    protected String getPackageName() {
        switch (this.type) {
            case HOSTER: {
                if (this.plugin == null || ((PluginForHost)this.plugin).getDownloadLink() == null) {
                    return null;
                }
                return ((PluginForHost)this.plugin).getDownloadLink().getFilePackage().getName();
            }
        }
        return null;
    }

    public DialogType getType() {
        return this.type;
    }

    public boolean isHideCaptchasForHost() {
        return this.hideCaptchasForHost;
    }

    public boolean isHideCaptchasForPackage() {
        return this.hideCaptchasForPackage;
    }

    public boolean isStopDownloads() {
        return this.stopDownloads;
    }

    public String getFilename() {
        switch (this.type) {
            case HOSTER: {
                DownloadLink link;
                if (this.plugin == null || (link = ((PluginForHost)this.plugin).getDownloadLink()) == null) {
                    return null;
                }
                return link.getView().getDisplayName();
            }
            case CRAWLER: {
                CrawledLink link;
                if (this.plugin == null || (link = ((PluginForDecrypt)this.plugin).getCurrentLink()) == null) {
                    return null;
                }
                return link.getName();
            }
        }
        return null;
    }

    protected Header createHeader() {
        String headerText;
        Header headerPanel;
        if (this.type == DialogType.ACCOUNT) {
            throw new WTFException("FIXME");
        }
        if (this.type == DialogType.HOSTER) {
            if (!((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isShowFileNameInCaptchaDialogEnabled()) {
                return null;
            }
            String fileName = this.getFilename();
            headerPanel = new Header("ins 0 0 1 0", "[grow,fill]", "[]");
            long fileSize = this.getFilesize();
            headerText = fileSize > 0L ? _GUI.T.CaptchaDialog_layoutDialogContent_header(fileName, SizeFormatter.formatBytes((long)fileSize), this.hosterInfo.getTld()) : _GUI.T.CaptchaDialog_layoutDialogContent_header2(fileName, this.hosterInfo.getTld());
        } else if (this.type == DialogType.CRAWLER) {
            headerPanel = new Header("ins 0 0 1 0", "[grow,fill]", "[grow,fill]");
            String crawlerStatus = this.getCrawlerStatus();
            headerText = crawlerStatus == null ? _GUI.T.CaptchaDialog_layoutDialogContent_header_crawler(this.hosterInfo.getTld()) : _GUI.T.CaptchaDialog_layoutDialogContent_header_crawler2(crawlerStatus, this.hosterInfo.getTld());
        } else {
            return null;
        }
        JLabel header = new JLabel(){
            private boolean setting = false;

            @Override
            protected void paintComponent(Graphics g) {
                if (headerText != null) {
                    this.setting = true;
                    try {
                        this.setText(SwingUtilities2Wrapper.clipStringIfNecessary((JComponent)this, (FontMetrics)this.getFontMetrics(this.getFont()), (String)headerText, (int)(this.getWidth() - 30)));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        this.setText(headerText);
                    }
                    this.setting = false;
                }
                super.paintComponent(g);
            }

            @Override
            public void repaint() {
                if (this.setting) {
                    return;
                }
                super.repaint();
            }

            @Override
            public void revalidate() {
                if (this.setting) {
                    return;
                }
                super.revalidate();
            }
        };
        header.setIcon(this.hosterInfo.getFavIcon());
        headerPanel.add(header);
        return headerPanel;
    }

    public JComponent layoutDialogContent() {
        this.getDialog().setModalityType(this.getModalityType());
        LAFOptions lafOptions = LAFOptions.getInstance();
        MigPanel field = new MigPanel("ins 0,wrap 1", "[grow,fill]", "[grow,fill]");
        SwingUtils.setOpaque((JComponent)field, (boolean)false);
        this.getDialog().setMinimumSize(new Dimension(0, 0));
        JPanel panel = new JPanel((LayoutManager)this.getDialogLayout());
        SwingUtils.setOpaque((JComponent)panel, (boolean)false);
        LAFOptions.applyBackground((Color)lafOptions.getColorForPanelBackground(), (JComponent)field);
        this.getDialog().setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
        this.addBeforeImage(field);
        this.iconPanel = this.createCaptchaPanel();
        if (this.iconPanel != null) {
            SwingUtils.setOpaque((JComponent)this.iconPanel, (boolean)false);
            if (CFG_CAPTCHA.CFG.isCancelDialogCountdownOnMouseMove()) {
                this.mouseMotionListener = new MouseMotionListener(){
                    private Point lastMouse;

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        AbstractCaptchaDialog.this.cancel();
                    }

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        if (this.lastMouse != null && !this.lastMouse.equals(e.getPoint())) {
                            AbstractCaptchaDialog.this.cancel();
                        }
                        this.lastMouse = e.getPoint();
                    }
                };
                this.iconPanel.addMouseMotionListener(this.mouseMotionListener);
            }
            if (CFG_CAPTCHA.CFG.isCancelDialogCountdownOnMouseClick()) {
                this.mouseListener = new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        AbstractCaptchaDialog.this.cancel();
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        AbstractCaptchaDialog.this.cancel();
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        AbstractCaptchaDialog.this.cancel();
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        AbstractCaptchaDialog.this.cancel();
                    }
                };
                this.iconPanel.addMouseListener(this.mouseListener);
            }
            field.add((Component)this.iconPanel);
        }
        HeaderScrollPane sp = this.createHeaderScrollPane(field);
        if (!CFG_GUI.CFG.isCaptchaDialogBorderAroundImageEnabled()) {
            sp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            SwingUtils.setOpaque((JComponent)field, (boolean)false);
        }
        panel.add(sp);
        Header header = this.createHeader();
        if (header != null) {
            sp.setColumnHeaderView((Component)((Object)header));
        }
        return panel;
    }

    protected void addBeforeImage(MigPanel field) {
    }

    protected HeaderScrollPane createHeaderScrollPane(MigPanel field) {
        return new HeaderScrollPane((JComponent)field);
    }

    protected MigLayout getDialogLayout() {
        return new MigLayout("ins 0,wrap 1", "[fill,grow]", "[grow,fill]");
    }

    protected abstract JPanel createCaptchaPanel();

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public List<? extends Image> getIconList() {
        return JDGui.getInstance().getMainFrame().getIconImages();
    }

    public Window getOwner() {
        return JDGui.getInstance().getMainFrame();
    }

    protected void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }
}

