/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.adscaptcha;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jd.gui.swing.jdgui.JDGui;
import jd.nutils.Screen;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.URLStream;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;

class SliderCaptchaDialog
extends AbstractDialog<String> {
    private JSlider slider;
    private JPanel p;
    private int images = -1;
    private URL[] imageUrls;
    private int pos = 0;
    private JPanel picture;
    private BufferedImage[] image;
    private Image finalImage;
    private Thread download;
    private JLabel dLabel;
    private JLabel cLabel;
    private JProgressBar bar;
    private final JButton dynamicOkButton = new JButton(_AWU.T.ABSTRACTDIALOG_BUTTON_OK());

    public SliderCaptchaDialog(int flag, String title, URL[] imageUrls, int count) {
        super(flag | 0x100 | 4 | 8, title, null, null, null);
        this.setCountdownTime(120);
        this.images = imageUrls.length - 1;
        this.imageUrls = imageUrls;
        if (this.images == 0) {
            this.images = count--;
        }
    }

    public JComponent layoutDialogContent() {
        this.bar = new JProgressBar(0, this.images);
        this.dLabel = new JLabel("Please wait while downloading captchas: " + this.bar.getValue() + "/" + this.images);
        this.cLabel = new JLabel("Slide to fit");
        this.download = new Thread("Captcha download"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block20: {
                    try {
                        if (SliderCaptchaDialog.this.images < 0) {
                            SliderCaptchaDialog.access$102(SliderCaptchaDialog.this, new BufferedImage[SliderCaptchaDialog.this.imageUrls.length]);
                            for (int i = 0; i < SliderCaptchaDialog.this.image.length; ++i) {
                                1.sleep(50L);
                                InputStream stream = null;
                                try {
                                    stream = URLStream.openStream((URL)SliderCaptchaDialog.this.imageUrls[i]);
                                    ((SliderCaptchaDialog)SliderCaptchaDialog.this).image[i] = ImageIO.read(stream);
                                    SliderCaptchaDialog.this.bar.setValue(i + 1);
                                    continue;
                                }
                                finally {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable) {}
                                }
                            }
                            break block20;
                        }
                        SliderCaptchaDialog.access$102(SliderCaptchaDialog.this, new BufferedImage[SliderCaptchaDialog.this.images]);
                        InputStream stream = null;
                        try {
                            stream = URLStream.openStream((URL)SliderCaptchaDialog.this.imageUrls[0]);
                            BufferedImage tmpImage = ImageIO.read(stream);
                            int w = tmpImage.getWidth();
                            int h = tmpImage.getHeight() / SliderCaptchaDialog.this.images;
                            for (int i = 0; i < SliderCaptchaDialog.this.image.length; ++i) {
                                ((SliderCaptchaDialog)SliderCaptchaDialog.this).image[i] = tmpImage.getSubimage(0, i * h, w, h);
                                SliderCaptchaDialog.this.bar.setValue(i + 1);
                            }
                        }
                        finally {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (IOException e) {
                        LoggerFactory.getDefaultLogger().log((Throwable)e);
                    }
                    catch (InterruptedException e) {
                        LoggerFactory.getDefaultLogger().log((Throwable)e);
                    }
                }
            }
        };
        this.download.start();
        this.slider = new JSlider(0, this.images, 0);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SliderCaptchaDialog.this.pos = ((JSlider)e.getSource()).getValue();
                SliderCaptchaDialog.this.resizeImage();
                SliderCaptchaDialog.this.p.repaint();
            }
        });
        this.p = new JPanel((LayoutManager)new MigLayout("ins 0,wrap 1", "[grow,fill]", "[][grow,fill]"));
        this.picture = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                if (SliderCaptchaDialog.this.finalImage != null) {
                    return new Dimension(SliderCaptchaDialog.this.finalImage.getWidth((ImageObserver)SliderCaptchaDialog.this.dialog), SliderCaptchaDialog.this.finalImage.getHeight((ImageObserver)SliderCaptchaDialog.this.dialog));
                }
                return super.getPreferredSize();
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (SliderCaptchaDialog.this.finalImage != null) {
                    g.setColor(Color.WHITE);
                    g.drawImage(SliderCaptchaDialog.this.finalImage, 0, 0, this);
                }
            }
        };
        this.bar.setStringPainted(true);
        this.bar.addChangeListener(new ChangeListener(){
            private int pos = 0;

            @Override
            public void stateChanged(ChangeEvent e) {
                this.pos = ((JProgressBar)e.getSource()).getValue();
                if (this.pos < SliderCaptchaDialog.this.images) {
                    SliderCaptchaDialog.this.dLabel.setText("Please wait while downloading captchas: " + SliderCaptchaDialog.this.bar.getValue() + "/" + SliderCaptchaDialog.this.images);
                    SliderCaptchaDialog.this.dLabel.paintImmediately(SliderCaptchaDialog.this.dLabel.getVisibleRect());
                } else {
                    SliderCaptchaDialog.this.resizeImage();
                    SliderCaptchaDialog.this.dialog.setSize(315, 350);
                    if (JDGui.getInstance() == null) {
                        SliderCaptchaDialog.this.dialog.setLocation(Screen.getCenterOfComponent(null, (Component)SliderCaptchaDialog.this.dialog));
                    } else if (JDGui.getInstance().getMainFrame().getExtendedState() == 1 || !JDGui.getInstance().getMainFrame().isVisible()) {
                        SliderCaptchaDialog.this.dialog.setLocation(Screen.getDockBottomRight((Component)SliderCaptchaDialog.this.dialog));
                    } else {
                        SliderCaptchaDialog.this.dialog.setLocation(Screen.getCenterOfComponent((Component)JDGui.getInstance().getMainFrame(), (Component)SliderCaptchaDialog.this.dialog));
                    }
                    SliderCaptchaDialog.this.setupCaptchaDialog();
                }
            }
        });
        this.p.add(this.dLabel);
        this.p.add(this.bar);
        return this.p;
    }

    private void setupCaptchaDialog() {
        this.p.remove(this.dLabel);
        this.p.remove(this.bar);
        this.p.add(this.cLabel);
        this.p.add(this.picture);
        this.p.add(this.slider);
        this.p.repaint();
    }

    private void resizeImage() {
        this.finalImage = this.image == null || this.image.length == 0 ? null : this.image[this.pos].getScaledInstance(300, 250, 4);
    }

    protected void addButtons(final JPanel buttonBar) {
        this.dynamicOkButton.addActionListener((ActionListener)((Object)this));
        this.p.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (e.getChild().getClass().getName().endsWith("JProgressBar")) {
                    buttonBar.add((Component)SliderCaptchaDialog.this.dynamicOkButton, "cell 0 0,tag ok,sizegroup confirms");
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.dynamicOkButton) {
            LoggerFactory.getDefaultLogger().fine("Answer: Button<OK:" + this.dynamicOkButton.getText() + ">");
            this.setReturnmask(true);
        } else if (e.getActionCommand().equals("enterPushed")) {
            return;
        }
        super.actionPerformed(e);
    }

    protected String createReturnValue() {
        if (!this.download.isInterrupted()) {
            this.download.interrupt();
        }
        if (Dialog.isOK((Object)this.getReturnmask())) {
            return String.valueOf(this.pos);
        }
        return null;
    }

    static /* synthetic */ BufferedImage[] access$102(SliderCaptchaDialog x0, BufferedImage[] x1) {
        x0.image = x1;
        return x1;
    }
}

