/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.areyouahuman;

import jd.http.Browser;
import jd.plugins.Plugin;
import org.appwork.utils.Regex;
import org.appwork.utils.logging2.LogInterface;
import org.jdownloader.logging.LogController;

public abstract class AbstractCaptchaHelperAreYouHuman<T extends Plugin> {
    protected T plugin;
    protected LogInterface logger;
    protected Browser br;
    protected String siteKey;

    public AbstractCaptchaHelperAreYouHuman(T plugin, Browser br, String siteKey) {
        this.plugin = plugin;
        this.br = br;
        if (br.getRequest() == null) {
            throw new IllegalStateException("Browser.getRequest() == null!");
        }
        this.logger = ((Plugin)plugin).getLogger();
        if (this.logger == null) {
            this.logger = LogController.getInstance().getLogger(this.getClass().getSimpleName());
        }
        this.siteKey = siteKey;
    }

    public T getPlugin() {
        return this.plugin;
    }

    protected String getAreYouAHumanApiKey() {
        return this.getAreYouAHumanApiKey(this.br != null ? this.br.toString() : null);
    }

    protected String getAreYouAHumanApiKey(String source) {
        if (source == null) {
            return null;
        }
        String[] scripts = new Regex(source, "<script[^>]*>.*?</script>").getColumn(-1);
        if (scripts != null) {
            for (String script : scripts) {
                String apiKey = new Regex(script, "src=('|\")https?://ws\\.areyouahuman\\.com/ws/script/([a-f0-9]{40})\\1").getMatch(1);
                if (apiKey == null) continue;
                return apiKey;
            }
        }
        return null;
    }
}

