/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.cloudflareturnstile;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import jd.http.Browser;
import jd.parser.html.Form;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.jdownloader.captcha.v2.challenge.cloudflareturnstile.CloudflareTurnstileChallenge;
import org.jdownloader.captcha.v2.solver.browser.BrowserViewport;
import org.jdownloader.captcha.v2.solver.browser.BrowserWindow;
import org.jdownloader.logging.LogController;

public abstract class AbstractCloudflareTurnstileCaptcha<T extends Plugin> {
    protected final T plugin;
    protected final LogInterface logger;
    protected final Browser br;
    protected String siteKey;
    public static final String apiKeyRegex = "\\d+x[a-zA-Z0-9\\-_]{22}";
    protected static final HashMap<String, Set<String>> INVALID_SITE_KEYS = new HashMap();

    public static boolean containsCloudflareTurnstileClass(Browser br) {
        return br != null && AbstractCloudflareTurnstileCaptcha.containsCloudflareTurnstileClass(br.toString());
    }

    public static boolean containsCloudflareTurnstileClass(String string) {
        if (string == null) {
            return false;
        }
        if (new Regex(string, "challenges\\.cloudflare\\.com/turnstile/").patternFind()) {
            return true;
        }
        return new Regex(string, "class=\"cf-turnstile\"").patternFind();
    }

    public static boolean containsCloudflareTurnstileClass(Form form) {
        return form != null && AbstractCloudflareTurnstileCaptcha.containsCloudflareTurnstileClass(form.getHtmlCode());
    }

    public AbstractCloudflareTurnstileCaptcha(T plugin, Browser br) {
        this(plugin, br, null, null);
    }

    @Deprecated
    public AbstractCloudflareTurnstileCaptcha(T plugin, Browser br, String siteKey) {
        this(plugin, br, siteKey, null);
    }

    public AbstractCloudflareTurnstileCaptcha(T plugin, Browser br, String siteKey, String apiKey) {
        this.plugin = plugin;
        if (br.getRequest() == null) {
            throw new IllegalStateException("Browser.getRequest() == null!");
        }
        this.br = br;
        this.logger = ((Plugin)plugin).getLogger() == null ? LogController.getInstance().getLogger(this.getClass().getSimpleName()) : ((Plugin)plugin).getLogger();
        this.siteKey = siteKey;
    }

    public T getPlugin() {
        return this.plugin;
    }

    public String getSiteKey() {
        return this.getSiteKey(this.br.getRequest().getHtmlCode());
    }

    public static final boolean isValidSiteKey(String siteKey) {
        if (siteKey == null) {
            return false;
        }
        return siteKey.matches("^\\d+x[a-zA-Z0-9\\-_]{22}$");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSiteKey(String source) {
        String siteKey;
        if (this.siteKey != null) {
            return this.siteKey;
        }
        if (source == null) {
            return null;
        }
        String findNextSiteKeySource = source;
        HashSet<String> siteKeys = new HashSet<String>();
        while (StringUtils.isNotEmpty((String)findNextSiteKeySource) && (siteKey = this.findNextSiteKey(findNextSiteKeySource)) != null) {
            siteKeys.add(siteKey);
            findNextSiteKeySource = findNextSiteKeySource.replace(siteKey, "");
        }
        HashMap<String, Set<String>> hashMap = INVALID_SITE_KEYS;
        synchronized (hashMap) {
            this.logger.info("Auto siteKeys unfiltered:" + siteKeys);
            Set<String> invalidSiteKeys = INVALID_SITE_KEYS.get(((Plugin)this.getPlugin()).getHost());
            if (invalidSiteKeys != null) {
                siteKeys.removeAll(invalidSiteKeys);
            }
            this.logger.info("Auto siteKeys filtered:" + siteKeys);
        }
        this.siteKey = this.findCorrectSiteKeys(source, this.br, siteKeys);
        return this.siteKey;
    }

    protected String findCorrectSiteKeys(String source, Browser br, Set<String> siteKeys) {
        if (siteKeys.size() == 0) {
            this.logger.info("No siteKey found!");
            return null;
        }
        if (siteKeys.size() == 1) {
            String siteKey = siteKeys.iterator().next();
            this.logger.info("Auto single siteKey:" + siteKey);
            return siteKey;
        }
        String siteKey = siteKeys.iterator().next();
        this.logger.info("Auto multiple siteKeys:" + siteKeys + " -> " + siteKey);
        return siteKey;
    }

    protected String[] getDIVs(String source) {
        return new Regex(source, "<\\s*(div|button)(?:[^>]*>.*?</\\1>|[^>]*\\s*/\\s*>)").getColumn(-1);
    }

    protected String findNextSiteKey(String source) {
        String jsSource = new Regex(source, "turnstile\\.render\\s*\\(.*?,\\s*\\{(.*?)\\s*\\}\\s*\\)\\s*;").getMatch(0);
        String siteKey = new Regex(jsSource, "('|\"|)sitekey\\1\\s*:\\s*('|\"|)\\s*(\\d+x[a-zA-Z0-9\\-_]{22})\\s*\\2").getMatch(2);
        if (siteKey != null) {
            return siteKey;
        }
        jsSource = new Regex(source, "turnstile\\.render\\s*\\(\\s*\\{(.*?)\\s*\\}\\s*\\)\\s*;").getMatch(0);
        siteKey = new Regex(jsSource, "('|\"|)sitekey\\1\\s*:\\s*('|\"|)\\s*(\\d+x[a-zA-Z0-9\\-_]{22})\\s*\\2").getMatch(2);
        if (siteKey != null) {
            return siteKey;
        }
        String siteKey2 = new Regex(source, "turnstile\\.execute\\s*\\(\\s*('|\")\\s*(\\d+x[a-zA-Z0-9\\-_]{22})\\s*\\1").getMatch(1);
        if (siteKey2 != null) {
            return siteKey2;
        }
        Form[] forms = Form.getForms(source);
        if (forms != null) {
            for (Form form : forms) {
                String siteKey3 = new Regex(form.getHtmlCode(), "data-sitekey\\s*=\\s*('|\")\\s*(\\d+x[a-zA-Z0-9\\-_]{22})\\s*\\1").getMatch(1);
                if (siteKey3 == null) continue;
                return siteKey3;
            }
        }
        return null;
    }

    public static boolean looksLikeValidToken(String str) {
        return str != null && str.matches("0\\.[a-zA-Z0-9_\\-\\.]{60,}");
    }

    public String getPageURL() {
        return this.br.getURL();
    }

    protected Browser getBrowser() {
        return this.br;
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    protected CloudflareTurnstileChallenge createChallenge() throws PluginException {
        T plugin = this.getPlugin();
        String siteKey = this.getSiteKey();
        if (plugin == null) {
            throw new PluginException(0x400000);
        }
        if (siteKey == null) {
            throw new PluginException(0x400000);
        }
        return new CloudflareTurnstileChallenge((Plugin)plugin, siteKey){

            @Override
            public BrowserViewport getBrowserViewport(BrowserWindow screenResource, Rectangle elementBounds) {
                return null;
            }

            @Override
            public String getHTML(HttpRequest request, String id) {
                return null;
            }
        };
    }

    public int getSolutionTimeout() {
        return 300000;
    }
}

