/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.confidentcaptcha;

import jd.http.Browser;
import jd.plugins.Plugin;
import org.appwork.utils.Regex;
import org.appwork.utils.logging2.LogInterface;
import org.jdownloader.logging.LogController;

public abstract class AbstractCaptchaHelperConfidentCaptcha<T extends Plugin> {
    protected T plugin;
    protected LogInterface logger;
    protected Browser br;
    protected String siteKey;

    public AbstractCaptchaHelperConfidentCaptcha(T plugin, Browser br, String siteKey) {
        this.plugin = plugin;
        this.br = br;
        if (br.getRequest() == null) {
            throw new IllegalStateException("Browser.getRequest() == null!");
        }
        this.logger = ((Plugin)plugin).getLogger();
        if (this.logger == null) {
            this.logger = LogController.getInstance().getLogger(this.getClass().getSimpleName());
        }
        this.siteKey = siteKey;
    }

    public T getPlugin() {
        return this.plugin;
    }

    public String getConfidentCaptchaApiKey() {
        return AbstractCaptchaHelperConfidentCaptcha.getConfidentCaptchaApiKey(this.br != null ? this.br.toString() : null, this.br);
    }

    public static String getConfidentCaptchaApiKey(String source, Browser br) {
        String formData = new Regex(source, "<div[^>]*id=(\"|'|)captcha-dialog\\1[^>]*>.*?</form>\\s*</div>").getMatch(-1);
        return formData;
    }
}

