/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.cutcaptcha;

import java.awt.Rectangle;
import jd.http.Browser;
import jd.parser.Regex;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import org.appwork.utils.logging2.LogInterface;
import org.jdownloader.captcha.v2.challenge.cutcaptcha.CutCaptchaChallenge;
import org.jdownloader.captcha.v2.solver.browser.BrowserViewport;
import org.jdownloader.captcha.v2.solver.browser.BrowserWindow;
import org.jdownloader.logging.LogController;

public abstract class AbstractCaptchaHelperCutCaptcha<T extends Plugin> {
    protected final T plugin;
    protected final LogInterface logger;
    protected final Browser br;
    protected String siteKey;
    protected String apiKey;

    public AbstractCaptchaHelperCutCaptcha(T plugin, Browser br) {
        this(plugin, br, null, null);
    }

    @Deprecated
    public AbstractCaptchaHelperCutCaptcha(T plugin, Browser br, String siteKey) {
        this(plugin, br, siteKey, null);
    }

    public AbstractCaptchaHelperCutCaptcha(T plugin, Browser br, String siteKey, String apiKey) {
        this.plugin = plugin;
        if (br.getRequest() == null) {
            throw new IllegalStateException("Browser.getRequest() == null!");
        }
        this.br = br;
        this.logger = ((Plugin)plugin).getLogger() == null ? LogController.getInstance().getLogger(this.getClass().getSimpleName()) : ((Plugin)plugin).getLogger();
        this.siteKey = siteKey;
        this.apiKey = apiKey;
    }

    public T getPlugin() {
        return this.plugin;
    }

    public String getSiteKey() {
        return this.getSiteKey(this.br.getRequest().getHtmlCode());
    }

    public String getSiteKey(String source) {
        if (this.siteKey != null) {
            return this.siteKey;
        }
        String autoSiteKey = new Regex(source, "CUTCAPTCHA_MISERY_KEY = \"([a-f0-9]{40})").getMatch(0);
        if (autoSiteKey != null) {
            this.siteKey = autoSiteKey;
            return this.siteKey;
        }
        this.logger.info("AutoSiteKey: No siteKey found!");
        return null;
    }

    public String getAPIKey() {
        return this.getAPIKey(this.br.getRequest().getHtmlCode());
    }

    public String getAPIKey(String source) {
        if (this.apiKey != null) {
            return this.apiKey;
        }
        String autoApiKey = new Regex(source, "cutcaptcha\\.net/captcha/([A-Za-z0-9]+)\\.js").getMatch(0);
        if (autoApiKey != null) {
            this.apiKey = autoApiKey;
            return this.apiKey;
        }
        this.logger.info("AutoApiKey: No apiKey found!");
        return null;
    }

    public String getPageURL() {
        return this.br.getURL();
    }

    protected Browser getBrowser() {
        return this.br;
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    protected CutCaptchaChallenge createChallenge() throws PluginException {
        T plugin = this.getPlugin();
        String siteKey = this.getSiteKey();
        String apiKey = this.getAPIKey();
        if (plugin == null) {
            throw new PluginException(0x400000);
        }
        if (siteKey == null) {
            throw new PluginException(0x400000);
        }
        if (apiKey == null) {
            throw new PluginException(0x400000);
        }
        return new CutCaptchaChallenge((Plugin)plugin, siteKey, apiKey){

            @Override
            public BrowserViewport getBrowserViewport(BrowserWindow screenResource, Rectangle elementBounds) {
                return null;
            }
        };
    }
}

