/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.geetest;

import jd.http.Browser;
import jd.parser.html.Form;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import org.appwork.utils.Regex;
import org.appwork.utils.logging2.LogInterface;
import org.jdownloader.logging.LogController;

public abstract class AbstractCaptchaHelperGeeTest<T extends Plugin> {
    protected T plugin;
    protected LogInterface logger;
    protected Browser br;
    protected String siteKey;

    public AbstractCaptchaHelperGeeTest(T plugin, Browser br, String siteKey) {
        this.plugin = plugin;
        this.br = br;
        if (br.getRequest() == null) {
            throw new IllegalStateException("Browser.getRequest() == null!");
        }
        this.logger = ((Plugin)plugin).getLogger();
        if (this.logger == null) {
            this.logger = LogController.getInstance().getLogger(this.getClass().getSimpleName());
        }
        this.siteKey = siteKey;
    }

    public T getPlugin() {
        return this.plugin;
    }

    protected String getGeeTestApiKey() {
        return AbstractCaptchaHelperGeeTest.getGeeTestApiKey(this.br != null ? this.br.toString() : null);
    }

    protected static String getGeeTestApiKey(String source) {
        if (source == null) {
            return null;
        }
        String[] scripts = new Regex(source, "<script[^>]*>.*?</script>").getColumn(-1);
        if (scripts != null) {
            for (String script : scripts) {
                String apiKey = new Regex(script, "src=('|\")https?://api\\.geetest\\.com/[^\\s]*(?:\\?|&)gt=([a-f0-9]{32})[^\\s]*\\1").getMatch(1);
                if (apiKey == null) continue;
                return apiKey;
            }
        }
        return null;
    }

    public static boolean containsGeeTest(Browser br) throws PluginException {
        if (br == null) {
            throw new PluginException(0x400000);
        }
        String geeTestApiKey = AbstractCaptchaHelperGeeTest.getGeeTestApiKey(br.toString());
        return geeTestApiKey != null;
    }

    public static boolean containsGeeTest(Form form) throws PluginException {
        if (form == null) {
            throw new PluginException(0x400000);
        }
        String geeTestApiKey = AbstractCaptchaHelperGeeTest.getGeeTestApiKey(form.getHtmlCode());
        return geeTestApiKey != null;
    }

    public static boolean containsGeeTest(String string) throws PluginException {
        if (string == null) {
            throw new PluginException(0x400000);
        }
        String geeTestApiKey = AbstractCaptchaHelperGeeTest.getGeeTestApiKey(string);
        return geeTestApiKey != null;
    }
}

