/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.hcaptcha;

import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import jd.http.Browser;
import jd.plugins.Plugin;
import org.appwork.exceptions.WTFException;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.net.protocol.http.ResponseCodeInterface;
import org.appwork.remoteapi.exceptions.RemoteAPIException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.challenge.hcaptcha.AbstractHCaptcha;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.BasicCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.CaptchaResponse;
import org.jdownloader.captcha.v2.solver.browser.AbstractBrowserChallenge;
import org.jdownloader.captcha.v2.solver.browser.BrowserReference;
import org.jdownloader.captcha.v2.solver.browser.BrowserViewport;
import org.jdownloader.captcha.v2.solver.browser.BrowserWindow;
import org.jdownloader.gui.translate._GUI;

public class HCaptchaChallenge
extends AbstractBrowserChallenge {
    public static final String RAWTOKEN = "rawtoken";
    private final String siteKey;
    private volatile BasicCaptchaChallenge basicChallenge;
    private final String siteDomain;

    public String getSiteKey() {
        return this.siteKey;
    }

    public String getType() {
        return AbstractHCaptcha.TYPE.NORMAL.name();
    }

    @Override
    public AbstractResponse<String> parseAPIAnswer(String result, String resultFormat, ChallengeSolver<?> solver) {
        BasicCaptchaChallenge basic;
        if (RAWTOKEN.equals(resultFormat) || "extension".equals(resultFormat)) {
            return new CaptchaResponse(this, solver, result, 100);
        }
        if (this.hasBasicCaptchaChallenge() && (basic = this.createBasicCaptchaChallenge(false)) != null) {
            return basic.parseAPIAnswer(result, resultFormat, solver);
        }
        return super.parseAPIAnswer(result, resultFormat, solver);
    }

    @Override
    public Object getAPIStorable(String format) throws Exception {
        if (RAWTOKEN.equals(format)) {
            HCaptchaAPIStorable ret = new HCaptchaAPIStorable();
            ret.setSiteKey(this.getSiteKey());
            String siteUrl = this.getSiteUrl();
            String protocol = StringUtils.startsWithCaseInsensitive((String)"https://", (String)siteUrl) ? "https://" : "http://";
            ret.setContextUrl(protocol + this.getSiteDomain());
            ret.setSiteUrl(siteUrl);
            ret.setType(this.getType());
            return ret;
        }
        BasicCaptchaChallenge basic = this.createBasicCaptchaChallenge(true);
        if (basic != null) {
            return basic.getAPIStorable(format);
        }
        return super.getAPIStorable(format);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        BasicCaptchaChallenge basicChallenge = this.basicChallenge;
        if (basicChallenge != null) {
            basicChallenge.cleanup();
        }
    }

    public HCaptchaChallenge(String siteKey, Plugin pluginForHost, Browser br, String siteDomain) {
        super(HCaptchaChallenge.getChallengeType(), pluginForHost, br);
        this.siteKey = siteKey;
        this.siteDomain = siteDomain;
        if (!AbstractHCaptcha.isValidSiteKey(siteKey)) {
            throw new WTFException("Bad SiteKey:" + siteKey);
        }
    }

    public AbstractHCaptcha<?> getAbstractCaptchaHelperHCaptcha() {
        return null;
    }

    public String getSiteUrl() {
        return null;
    }

    public String getSiteDomain() {
        return this.siteDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onGetRequest(BrowserReference brRef, GetRequest request, HttpResponse response) throws IOException, RemoteAPIException {
        HCaptchaChallenge hCaptchaChallenge = this;
        synchronized (hCaptchaChallenge) {
            String pDo = request.getParameterbyKey("do");
            if ("solve".equals(pDo)) {
                String responsetoken = request.getParameterbyKey("response");
                brRef.onResponse(responsetoken);
                response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
                response.getResponseHeaders().add(new HTTPHeader("Content-Type", "text/html; charset=utf-8"));
                response.getOutputStream(true).write("Please Close the Browser now".getBytes("UTF-8"));
                return true;
            }
            return false;
        }
    }

    public static String getChallengeType() {
        String ret = null;
        for (Class cls = HCaptchaChallenge.class; cls != null && StringUtils.isEmpty(ret); cls = cls.getSuperclass()) {
            ret = cls.getSimpleName();
        }
        return ret;
    }

    @Override
    public String getHTML(HttpRequest request, String id) {
        try {
            String userAgent = request.getRequestHeaders().getValue("User-Agent");
            boolean isSafari = userAgent != null && userAgent.toLowerCase(Locale.ENGLISH).matches("(?s).*^((?!chrome|android|crios|fxios).)*safari.*");
            boolean isEdge = userAgent != null && userAgent.toLowerCase(Locale.ENGLISH).matches(".*edge\\/.*");
            URL url = HCaptchaChallenge.class.getResource("hcaptcha.html");
            String html = IO.readURLToString((URL)url);
            html = html.replace("%%%challengeType%%%", HCaptchaChallenge.getChallengeType());
            html = html.replace("%%%headTitle%%%", _GUI.T.recaptchav2_head_title());
            html = html.replace("%%%headDescription%%%", _GUI.T.recaptchav2_head_description());
            html = html.replace("%%%captchaHeader%%%", _GUI.T.recaptchav2_header());
            html = html.replace("%%%unsupportedBrowserHeader%%%", _GUI.T.extension_unsupported_browser_header());
            html = html.replace("%%%unsupportedBrowserDescription%%%", _GUI.T.extension_unsupported_browser_description());
            html = html.replace("%%%helpHeader%%%", _GUI.T.extension_help_header());
            html = html.replace("%%%helpDescription%%%", _GUI.T.extension_help_description());
            html = html.replace("%%%helpDescriptionLinkTitle%%%", _GUI.T.extension_help_description_link_title());
            html = html.replace("%%%extensionSupportHeader%%%", _GUI.T.extension_support_header());
            html = html.replace("%%%extensionSupportDescription%%%", _GUI.T.extension_support_description());
            html = html.replace("%%%extensionSupportLinkTitle%%%", _GUI.T.extension_support_link_title());
            html = html.replace("%%%siteUrl%%%", StringUtils.valueOrEmpty((String)this.getSiteUrl()));
            html = html.replace("%%%siteDomain%%%", this.getSiteDomain());
            html = html.replace("%%%sitekey%%%", this.getSiteKey());
            html = html.replace("%%%sitekeyType%%%", this.getType());
            html = html.replace("%%%enterprise%%%", String.valueOf(false));
            Object v3Action = null;
            html = v3Action == null ? html.replace("%%%v3action%%%", "") : html.replace("%%%v3action%%%", JSonStorage.toString(v3Action));
            html = html.replace("%%%unsupportedBrowser%%%", isSafari || isEdge ? "block" : "none");
            html = html.replace("%%%display%%%", "none");
            html = html.replace("%%%noExtensionHeader%%%", _GUI.T.extension_required_header());
            html = html.replace("%%%noExtensionDescription%%%", _GUI.T.extension_required_description());
            html = html.replace("%%%noExtensionLinkTitle%%%", _GUI.T.extension_required_link_title());
            html = html.replace("%%%installExtensionHeader%%%", _GUI.T.install_extension_header());
            html = html.replace("%%%installExtensionDone%%%", _GUI.T.install_extension_done());
            html = html.replace("%%%installExtensionUsingOtherBrowser%%%", _GUI.T.install_extension_using_other_browser());
            html = html.replace("%%%installExtensionShowAllBrowsers%%%", _GUI.T.install_extension_show_all_browsers_link());
            html = html.replace("%%%chromeExtensionHeader%%%", _GUI.T.install_chrome_extension_header());
            html = html.replace("%%%chromeExtensionDescription%%%", _GUI.T.install_chrome_extension_description());
            html = html.replace("%%%chromeExtensionLinkTitle%%%", _GUI.T.install_chrome_extension_link_title());
            html = html.replace("%%%firefoxExtensionHeader%%%", _GUI.T.install_firefox_extension_header());
            html = html.replace("%%%firefoxExtensionDescription%%%", _GUI.T.install_firefox_extension_description());
            html = html.replace("%%%firefoxExtensionLinkTitle%%%", _GUI.T.install_firefox_extension_link_title());
            html = html.replace("%%%operaExtensionHeader%%%", _GUI.T.install_opera_extension_header());
            html = html.replace("%%%operaExtensionDescription%%%", _GUI.T.install_opera_extension_description());
            html = html.replace("%%%operaExtensionLinkTitle%%%", _GUI.T.install_opera_extension_link_title());
            html = html.replace("%%%findMoreAppsLinkTitle%%%", _GUI.T.find_more_apps_link_title());
            html = html.replace("%%%findMoreAppsDescription%%%", _GUI.T.find_more_apps_description());
            html = html.replace("%%%session%%%", id);
            html = html.replace("%%%challengeId%%%", Long.toString(this.getId().getID()));
            html = html.replace("%%%namespace%%%", this.getHttpPath());
            html = html.replace("%%%boundToDomain%%%", String.valueOf(true));
            html = html.replace("%%%sameOrigin%%%", String.valueOf(true));
            String stoken = null;
            if (StringUtils.isNotEmpty(stoken)) {
                html = html.replace("%%%sToken%%%", stoken);
                html = html.replace("%%%optionals%%%", "data-stoken=\"" + stoken + "\"");
            } else {
                html = html.replace("%%%sToken%%%", "");
                html = html.replace("%%%optionals%%%", "");
            }
            return html;
        }
        catch (IOException e) {
            throw new WTFException((Throwable)e);
        }
    }

    @Override
    protected String getHttpPath() {
        if (this.plugin != null) {
            return "captcha/" + this.getCaptchaNameSpace() + "/" + this.getSiteDomain();
        }
        return super.getHttpPath();
    }

    @Override
    protected String getCaptchaNameSpace() {
        return "hcaptcha";
    }

    @Override
    public boolean isCaptchaResponseValid() {
        return super.isCaptchaResponseValid() && this.isValidResponseToken((String)this.getResult().getValue());
    }

    protected boolean isValidResponseToken(String v) {
        return v != null && v.matches("^[\\w-_\\.]{150,}");
    }

    @Override
    public boolean validateResponse(AbstractResponse<String> response) {
        return super.validateResponse(response) && this.isValidResponseToken(response.getValue());
    }

    @Override
    public void onHandled() {
        super.onHandled();
        BasicCaptchaChallenge basicChallenge = this.basicChallenge;
        if (basicChallenge != null) {
            basicChallenge.onHandled();
        }
    }

    public synchronized boolean hasBasicCaptchaChallenge() {
        return this.basicChallenge != null;
    }

    public synchronized BasicCaptchaChallenge createBasicCaptchaChallenge(boolean showInstallDialog) {
        return this.basicChallenge;
    }

    @Override
    public BrowserViewport getBrowserViewport(BrowserWindow screenResource, Rectangle elementBounds) {
        return null;
    }

    public static class HCaptchaAPIStorable
    implements Storable,
    AbstractBrowserChallenge.AbstractBrowserChallengeAPIStorable {
        private String type;
        private String siteKey;
        private String contextUrl;
        private String siteUrl;

        @Override
        public String getType() {
            if (this.type == null) {
                return AbstractHCaptcha.TYPE.NORMAL.name();
            }
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Override
        public String getSiteKey() {
            return this.siteKey;
        }

        public void setSiteKey(String siteKey) {
            this.siteKey = siteKey;
        }

        @Override
        public String getContextUrl() {
            return this.contextUrl;
        }

        public void setContextUrl(String contextUrl) {
            this.contextUrl = contextUrl;
        }

        @Override
        public String getSiteUrl() {
            return this.siteUrl;
        }

        public void setSiteUrl(String siteUrl) {
            this.siteUrl = siteUrl;
        }

        public String getStoken() {
            return null;
        }

        public void setStoken(String stoken) {
        }

        public boolean isSameOrigin() {
            return true;
        }

        public void setSameOrigin(boolean sameOrigin) {
        }

        public boolean isBoundToDomain() {
            return true;
        }

        public void setBoundToDomain(boolean boundToDomain) {
        }
    }
}

