/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.keycaptcha;

import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.plugins.DownloadLink;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.components.ThrowingRunnable;
import org.appwork.utils.IO;
import org.appwork.utils.images.IconIO;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.challenge.keycaptcha.CategoryData;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaCategoryChallenge;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaImageGetter;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaImages;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaPuzzleChallenge;
import org.jdownloader.captcha.v2.challenge.keycaptcha.PuzzleData;
import org.jdownloader.captcha.v2.challenge.keycaptcha.jac.KeyCaptchaAutoSolver;
import org.jdownloader.images.NewTheme;
import org.jdownloader.scripting.JavaScriptEngineFactory;

public class KeyCaptcha {
    static Object LOCK = new Object();
    private final Browser br;
    private Form FORM;
    private HashMap<String, String> PARAMS;
    private Browser rcBr;
    private String SERVERSTRING;
    private String downloadUrl;
    private String[] stImgs;
    private String[] sscStc;
    private LinkedHashMap<String, int[]> fmsImg;
    private KeyCaptchaType type;
    private Plugin plugin;
    private DownloadLink link;
    private PuzzleData puzzleData;
    private CategoryData categoryData;
    private String capJs;
    private Object endParameter;
    static ReentrantLock LOCKDIALOG = new ReentrantLock();

    public void prepareBrowser(Browser kc, String a) {
        kc.getHeaders().put("User-Agent", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)");
        kc.getHeaders().put("Referer", this.downloadUrl);
        kc.getHeaders().put("Pragma", null);
        kc.getHeaders().put("Cache-Control", null);
        kc.getHeaders().put("Accept", a);
        kc.getHeaders().put("Accept-Charset", null);
        kc.getHeaders().put("Accept-Language", "en-EN");
        kc.getHeaders().put("Cache-Control", null);
    }

    public KeyCaptcha(Plugin plg, Browser br, DownloadLink link) {
        this.br = br;
        this.plugin = plg;
        this.link = link;
        this.downloadUrl = link.getPluginPatternMatcher();
    }

    private String getGjsParameter() {
        String[] pars = new String[]{"s_s_c_user_id", "src", "s_s_c_session_id", "s_s_c_captcha_field_id", "s_s_c_submit_button_id", "s_s_c_web_server_sign", "s_s_c_web_server_sign2", "s_s_c_web_server_sign3", "s_s_c_web_server_sign4"};
        String result = "";
        for (String key : pars) {
            String string = result = result != "" ? result + "|" : result;
            if (!this.PARAMS.containsKey(key)) continue;
            result = result + this.PARAMS.get(key);
        }
        return result;
    }

    private String getAdditionalQuery(String query) {
        query = Encoding.htmlDecode((String)query).replaceAll("[\" ]", "");
        String js = this.rcBr.toString().replaceAll("[\n\r]+", "");
        String result = "|";
        for (String s : query.split("\\|")) {
            String t;
            if (s.length() <= 1) continue;
            if (s.endsWith("()")) {
                String regex = "function\\s+" + s.replace("(", "\\(\\s*").replace(")", "\\)") + "\\s*\\{\\s*(.*?)\\s*\\}\\s*;";
                t = new Regex(js, regex).getMatch(0);
            } else {
                t = new Regex(js, s + "=\\s+(.*?)\\s+;").getMatch(0);
            }
            if (t == null) {
                result = result + "1";
                continue;
            }
            String ret = new Regex(t, "\"([0-9a-f]+)\"").getMatch(0);
            if (ret == null) {
                result = result + "error";
            }
            result = result + "|" + ret;
        }
        return result;
    }

    private String getCapsUrl(String string) throws ScriptException {
        ScriptEngine engine = this.getScriptEngine();
        engine.eval("var document = { loc : function() { return \"" + this.downloadUrl + "\";}}");
        engine.eval("document.location = document.loc();");
        engine.put("s_s_c_user_id", this.PARAMS.get("s_s_c_user_id"));
        engine.eval(string);
        return engine.get("_13").toString();
    }

    private void load() throws Exception {
        this.rcBr = this.br.cloneBrowser();
        this.rcBr.setFollowRedirects(true);
        this.prepareBrowser(this.rcBr, "application/javascript, */*;q=0.8");
        String base = null;
        String capsUrl = null;
        if (this.PARAMS.containsKey("src")) {
            String redirect;
            this.rcBr.setFollowRedirects(false);
            this.rcBr.getPage(this.PARAMS.get("src"));
            while ((redirect = this.rcBr.getRedirectLocation()) != null) {
                base = new Regex(redirect, "(http.+/)swfs/").getMatch(0);
                this.rcBr.getHeaders().put("Referer", this.downloadUrl);
                this.rcBr.addAllowedResponseCodes(new int[]{502});
                this.rcBr.getPage(redirect);
                if (this.rcBr.getHttpConnection().getResponseCode() != 502) continue;
            }
            capsUrl = this.getCapsUrl(this.rcBr.getRegex("(var _13=[^;]+;)").getMatch(0));
            this.rcBr.getHeaders().put("Referer", this.downloadUrl);
            this.rcBr.getPage(base + "swfs/session.html?r=" + Math.random());
            Form form = this.rcBr.getFormbyKey("a");
            if (form != null) {
                this.rcBr.submitForm(form);
            }
            this.PARAMS.put("src", this.downloadUrl);
        }
        this.rcBr.getHeaders().put("Referer", this.downloadUrl);
        this.rcBr.getPage(capsUrl);
        this.rcBr.getHeaders().put("Referer", this.downloadUrl);
        this.rcBr.cloneBrowser().getPage(base + "js/keycaptcha-logo?r=" + Math.random());
        this.rcBr.getHeaders().put("Referer", this.downloadUrl);
        this.rcBr.cloneBrowser().getPage(base + "swfs/ckf");
        this.capJs = this.rcBr.toString();
        this.SERVERSTRING = null;
        this.PARAMS.put("s_s_c_web_server_sign4", this.rcBr.getRegex("s_s_c_web_server_sign4\\s*=\\s*\"(.*?)\"").getMatch(0));
        String[] next = this.rcBr.getRegex("\\.setAttribute\\(\\s*\"src\"\\s*,\\s*\"(.*?)\"\\s*\\+\\s*(.*?)\\s*\\+").getRow(0);
        if (next == null) {
            throw new Exception("KeyCaptcha Module fails");
        }
        String gjsUrl = next[0];
        String reg = "var\\s+" + next[1] + "\\s*=.*?s_s_c_web_server_sign4\\s*\\+\\s*(.*?);";
        String q = this.rcBr.getRegex(reg).getMatch(0);
        String endParameterName = new Regex(q, "(document\\.[\\w\\d]+)$").getMatch(0);
        this.endParameter = this.rcBr.getRegex(endParameterName.replace(".", "\\.") + "\\s*=\\s*\"([^\"]+)").getMatch(0);
        this.rcBr.getHeaders().put("Referer", this.downloadUrl);
        gjsUrl = gjsUrl + Encoding.urlEncode((String)(this.getGjsParameter() + this.getAdditionalQuery(false) + "|" + this.endParameter)) + "&r=" + Math.random() + "&sr=1920.1080";
        this.rcBr.getPage(gjsUrl);
        this.rcBr.getHeaders().put("Referer", this.downloadUrl);
        this.rcBr.cloneBrowser().getPage(base + "swfs/ckf");
        this.PARAMS.put("s_s_c_web_server_sign3", this.rcBr.getRegex("s_s_c_setnewws\\(\"(.*?)\",").getMatch(0));
        String categoryImagesList = this.rcBr.getRegex("var imgs\\s*=\\s*new Array\\s*\\(\\s*(.+?)\\s*\\)").getMatch(0);
        if (categoryImagesList != null) {
            this.type = KeyCaptchaType.CATEGORY;
        } else {
            this.type = KeyCaptchaType.PUZZLE;
            this.stImgs = this.rcBr.getRegex("\\('([0-9a-f]+)','(http.*?\\.png)',(.*?),(true|false)\\)").getRow(0);
            this.sscStc = this.rcBr.getRegex("\\('([0-9a-f]+)','(http.*?\\.png)',(.*?),(true|false)\\)").getRow(1);
        }
        String signFour = this.PARAMS.get("s_s_c_web_server_sign4");
        if (signFour.length() < 33) {
            signFour = signFour.substring(0, 10) + "310" + signFour.substring(10);
            this.PARAMS.put("s_s_c_web_server_sign4", signFour);
        }
        if (this.type == KeyCaptchaType.CATEGORY) {
            String[] images;
            String categoriesUrl = this.rcBr.getRegex("cnv\\.innerHTML\\s*=\\s*\\'<img\\s+style=\"background\\:none\\;\"\\s+src=\"(http[^\"]+\\.png)").getMatch(0);
            Browser picLoad = this.rcBr.cloneBrowser();
            this.prepareBrowser(picLoad, "image/png,image/svg+xml,image/*;q=0.8,*/*;q=0.5");
            CategoryData data = new CategoryData();
            data.setBackground(this.readImage(categoriesUrl, picLoad));
            for (String im : images = new Regex(categoryImagesList, "'(http[^']+)").getColumn(0)) {
                this.prepareBrowser(picLoad, "image/png,image/svg+xml,image/*;q=0.8,*/*;q=0.5");
                data.addImage(this.readImage(im, picLoad));
            }
            String resultUrl = this.rcBr.getRegex("resscript\\.setAttribute\\('src'\\s*\\,\\s*'([^']+)").getMatch(0);
            data.setResultUrl(resultUrl);
            String pS = this.sscFsmCheckTwo(this.PARAMS.get("s_s_c_web_server_sign"), this.PARAMS.get("s_s_c_web_server_sign") + "Khd21M47");
            String mmUrlReq = base + "swfs/mm?pS=" + pS + "&cP=" + this.getGjsParameter() + this.getAdditionalQuery(false);
            mmUrlReq = mmUrlReq + "&mms=" + Math.random() + "&r=" + Math.random();
            Thread.sleep(1000L);
            this.rcBr.cloneBrowser().getPage(mmUrlReq);
            Thread.sleep(3000L);
            String dh38 = base + "swfs/dh38?pS=" + this.sscFsmCheckTwo(this.PARAMS.get("s_s_c_web_server_sign"), this.PARAMS.get("s_s_c_web_server_sign") + "KdEfOMM");
            dh38 = dh38 + "&cP=" + this.getGjsParameter() + this.getAdditionalQuery(false);
            dh38 = dh38 + "&mms=" + Math.random() + "&r=" + Math.random();
            this.rcBr.cloneBrowser().getPage(dh38);
            this.categoryData = data;
        } else {
            this.SERVERSTRING = this.rcBr.getRegex("\\.s_s_c_resurl='([^']+)'\\+").getMatch(0);
            this.SERVERSTRING = this.SERVERSTRING + Encoding.urlEncode((String)(this.getGjsParameter() + this.getAdditionalQuery(false)));
            if (this.stImgs == null || this.sscStc == null || this.SERVERSTRING == null) {
                throw new Exception("KeyCaptcha Module fails");
            }
            this.sscGetImagest(this.stImgs[0], this.stImgs[1], this.stImgs[2], Boolean.parseBoolean(this.stImgs[3]));
            this.sscGetImagest(this.sscStc[0], this.sscStc[1], this.sscStc[2], Boolean.parseBoolean(this.sscStc[3]));
            if (this.sscStc == null || this.sscStc.length == 0 || this.stImgs == null || this.stImgs.length == 0 || this.fmsImg == null || this.fmsImg.size() == 0) {
                throw new PluginException(131072);
            }
            Thread.sleep(1000L);
            String pS = this.sscFsmCheckTwo(this.PARAMS.get("s_s_c_web_server_sign"), this.PARAMS.get("s_s_c_web_server_sign") + Encoding.Base64Decode((String)"S2hkMjFNNDc="));
            String mmUrlReq = this.SERVERSTRING.replaceAll("cjs\\?pS=\\d+&cOut", "mm\\?pS=" + pS + "&cP");
            mmUrlReq = mmUrlReq + "&mms=" + Math.random() + "&r=" + Math.random();
            this.rcBr.cloneBrowser().getPage(mmUrlReq);
            KeyCaptchaImageGetter imgGetter = new KeyCaptchaImageGetter(this, new String[]{this.stImgs[1], this.sscStc[1]}, this.fmsImg, this.rcBr, mmUrlReq);
            KeyCaptchaImages imgs = imgGetter.getKeyCaptchaImage();
            this.puzzleData = new PuzzleData(this.fmsImg, imgs, mmUrlReq);
        }
    }

    private ScriptEngine getScriptEngine() {
        ScriptEngineManager manager = JavaScriptEngineFactory.getScriptEngineManager(this);
        ScriptEngine engine = manager.getEngineByName("javascript");
        return engine;
    }

    private String evalGHS(String arg0, String arg1) throws Exception {
        try {
            final ScriptEngine engine = this.getScriptEngine();
            JavaScriptEngineFactory.runTrusted(new ThrowingRunnable<ScriptException>(){

                @Override
                public void run() throws ScriptException {
                    ScriptEnv env = new ScriptEnv(engine);
                    engine.put("env", env);
                    engine.eval("var string=" + String.class.getName() + ";");
                    engine.eval("log=function(str){return env.log(str);};");
                    engine.eval("alert=function(str){return env.log(str);};");
                    engine.eval("eval=function(str){return env.eval(str);};");
                    engine.eval("atob=function(str){return env.atob(str);};");
                    engine.eval("delete java;");
                    engine.eval("delete jd;");
                    engine.eval("log('Java Env Loaded');");
                }
            });
            String env = IO.readURLToString((URL)this.getClass().getResource("env.js"));
            engine.eval(env);
            engine.eval(this.capJs);
            engine.eval(this.rcBr.toString());
            String onLoadMethod = new Regex(this.capJs, "f\\.onload\\s*=\\s*function\\(\\)\\s*\\{\\s*([\\w\\d]+)\\(\\)").getMatch(0);
            engine.eval(onLoadMethod + "();");
            engine.put("arg1", arg0);
            engine.put("arg2", arg1);
            String signMethod = this.rcBr.getRegex("(\\w+\\.\\w+)\\(s_s_c_web_server_sign\\,\\s*s_s_c_web_server_sign").getMatch(0);
            String ret = engine.eval(signMethod + "(arg1,arg2);").toString();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            e.printStackTrace();
            throw e;
        }
    }

    private BufferedImage readImage(String categoriesUrl, Browser picLoad) throws IOException {
        BufferedImage ret = ImageIO.read(picLoad.openGetConnection(categoriesUrl).getInputStream());
        if (ret == null) {
            ret = IconIO.toBufferedImage((Image)NewTheme.I().getImage("help", 32));
        }
        return ret;
    }

    private String getAdditionalQuery(boolean inProcess) throws Exception {
        String[] next = new Regex(this.capJs, "\\.setAttribute\\(\\s*\"src\"\\s*,\\s*\"(.*?)\"\\s*\\+\\s*(.*?)\\s*\\+").getRow(0);
        if (next == null) {
            throw new Exception("KeyCaptcha Module fails");
        }
        String reg = "var\\s+" + next[1] + "\\s*=.*?s_s_c_web_server_sign4\\s*\\+\\s*(.*?);";
        String q = new Regex(this.capJs, reg).getMatch(0);
        String[] methods = new Regex(q, "([\\w\\d]+)\\(\\).*?([\\w\\d]+)\\(\\)").getRow(0);
        ScriptEngine engine = this.getScriptEngine();
        String env = "s_s_c_get_form=function(){return null;};s_s_c_captcha_field_id=\"\";document={};document.getElementById=function(){var obj={};obj.s_s_c_check_process=" + inProcess + ";return obj;};document.s_s_c_popupmode=false;document.s_s_c_do_not_auto_show=true;";
        engine.eval(env);
        engine.eval(this.capJs);
        Object a = engine.eval(methods[0] + "();");
        if (a instanceof Number) {
            a = ((Number)a).intValue() + "";
        }
        String b = engine.eval(methods[1] + "();").toString();
        return "|" + a + "|" + b;
    }

    public Browser getBrowser() {
        return this.rcBr;
    }

    public PuzzleData getPuzzleData() {
        return this.puzzleData;
    }

    public CategoryData getCategoryData() {
        return this.categoryData;
    }

    private void parse() throws Exception {
        String src;
        this.FORM = null;
        if (this.br.containsHTML("(KeyCAPTCHA|www\\.keycaptcha\\.com)")) {
            String st;
            for (Form f : this.br.getForms()) {
                if (!f.containsHTML("var s_s_c_user_id = ('\\d+'|\"\\d+\")")) continue;
                this.FORM = f;
                break;
            }
            if (this.FORM == null && (st = this.br.getRegex("(<script type='text/javascript'>var s_s_c_.*?'></script>)").getMatch(0)) != null) {
                Browser f = this.br.cloneBrowser();
                this.FORM = new Form();
                f.getRequest().setHtmlCode("<form>" + st + "</form>");
                this.FORM = f.getForm(0);
            }
            if (this.FORM == null) {
                throw new Exception("KeyCaptcha form couldn't be found");
            }
            this.PARAMS = new HashMap();
            String[][] parameter = this.FORM.getRegex("(s_s_c_\\w+) = '(.*?)'").getMatches();
            if (parameter == null || parameter.length == 0) {
                parameter = this.FORM.getRegex("(s_s_c_\\w+) = \"(.*?)\"").getMatches();
            }
            for (String[] para : parameter) {
                if (para.length != 2) continue;
                this.PARAMS.put(para[0], para[1]);
            }
            if (this.PARAMS == null || this.PARAMS.size() == 0) {
                throw new Exception("KeyCaptcha values couldn't be found");
            }
            src = this.FORM.getRegex("src='([^']+keycaptcha\\.com[^']+)'").getMatch(0);
            if (src == null && (src = this.FORM.getRegex("src=\"([^\"]+keycaptcha\\.com[^\"]+)\"").getMatch(0)) == null) {
                throw new Exception("KeyCaptcha Module fails");
            }
        } else {
            throw new Exception("KeyCaptcha handling couldn't be found");
        }
        this.PARAMS.put("src", src);
    }

    private String sscFsmCheckFour(String arg0, String arg1) {
        try {
            if (arg0 == null || arg0.length() < 8 || arg1 == null) {
                return null;
            }
            String prand = "";
            for (int i = 0; i < arg1.length(); ++i) {
                prand = prand + arg1.codePointAt(i);
            }
            int sPos = (int)Math.floor(prand.length() / 5);
            int mult = Integer.parseInt(String.valueOf(prand.charAt(sPos) + "" + prand.charAt(sPos * 2) + "" + prand.charAt(sPos * 3) + "" + prand.charAt(sPos * 4) + "" + prand.charAt(sPos * 5 - 1)));
            int incr = Math.round(arg1.length() / 3);
            long modu = (int)Math.pow(2.0, 31.0);
            int salt = Integer.parseInt(arg0.substring(arg0.length() - 8, arg0.length()), 16);
            arg0 = arg0.substring(0, arg0.length() - 8);
            prand = prand + salt;
            while (prand.length() > 9) {
                prand = String.valueOf(Integer.parseInt(prand.substring(0, 9), 10) + Integer.parseInt(prand.substring(9, Math.min(prand.length(), 14)), 10)) + prand.substring(Math.min(prand.length(), 14), prand.length());
            }
            String[] sburl = "https://back2.keycaptcha.com".split("\\.");
            prand = sburl != null && sburl.length == 3 && "keycaptcha".equalsIgnoreCase(sburl[1]) && "com".equalsIgnoreCase(sburl[2]) ? String.valueOf(((long)mult * Long.parseLong(prand) + (long)incr) % modu) : String.valueOf(((long)mult * Long.parseLong(prand) + (long)incr) % modu + 294710L);
            int enc_chr = 0;
            String enc_str = "";
            for (int i = 0; i < arg0.length(); i += 2) {
                enc_chr = Integer.parseInt(arg0.substring(i, i + 2), 16) ^ (int)Math.floor(Double.parseDouble(prand) / (double)modu * 255.0);
                enc_str = enc_str + String.valueOf((char)enc_chr);
                prand = String.valueOf(((long)mult * Long.parseLong(prand) + (long)incr) % modu);
            }
            return enc_str;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private String sscFsmCheckTwo(String arg0, String arg1) {
        try {
            if (arg1 == null) {
                return null;
            }
            String prand = "";
            for (int i = 0; i < arg1.length(); ++i) {
                prand = prand + arg1.codePointAt(i);
            }
            int sPos = (int)Math.floor(prand.length() / 5);
            int mult = Integer.parseInt(String.valueOf(prand.charAt(sPos) + "" + prand.charAt(sPos * 2) + "" + prand.charAt(sPos * 3) + "" + prand.charAt(sPos * 4) + "" + prand.charAt(sPos * 5 - 1)));
            int incr = (int)Math.ceil((double)arg1.length() / 3.0);
            long modu = (int)Math.pow(2.0, 31.0);
            if (mult < 2) {
                return null;
            }
            int salt = (int)Math.round(Math.random() * 1.0E9) % 100000000;
            prand = prand + salt;
            while (prand.length() > 9) {
                prand = String.valueOf(Integer.parseInt(prand.substring(0, 9), 10) + Integer.parseInt(prand.substring(9, Math.min(prand.length(), 14)), 10)) + prand.substring(Math.min(prand.length(), 14), prand.length());
            }
            String[] sburl = "https://back2.keycaptcha.com".split("\\.");
            prand = sburl != null && sburl.length == 3 && "keycaptcha".equalsIgnoreCase(sburl[1]) && "com".equalsIgnoreCase(sburl[2]) ? String.valueOf(((long)mult * Long.parseLong(prand) + (long)incr) % modu) : String.valueOf(((long)mult * Long.parseLong(prand) + (long)incr) % modu + 540L);
            int enc_chr = 0;
            String enc_str = "";
            for (int i = 0; i < arg0.length(); ++i) {
                enc_chr = arg0.codePointAt(i) ^ (int)Math.floor(Double.parseDouble(prand) / (double)modu * 255.0);
                enc_str = enc_chr < 16 ? enc_str + "0" + String.valueOf(Integer.toHexString(enc_chr)) : enc_str + String.valueOf(Integer.toHexString(enc_chr));
                prand = String.valueOf(((long)mult * Long.parseLong(prand) + (long)incr) % modu);
            }
            String saltStr = String.valueOf(Integer.toHexString(salt));
            while (saltStr.length() < 8) {
                saltStr = "0" + saltStr;
            }
            return enc_str + saltStr;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private void sscGetImagest(String arg0, String arg1, String arg2, boolean arg4) {
        String[] parseOutst;
        String outst = this.sscFsmCheckFour(arg0, arg1.substring(arg1.length() - 33, arg1.length() - 6));
        int[] pOut = null;
        if (arg4) {
            parseOutst = outst.split(";");
        } else {
            parseOutst = outst.split(",");
            pOut = new int[parseOutst.length];
            for (int i = 0; i < pOut.length; ++i) {
                pOut[i] = Integer.parseInt(parseOutst[i]);
            }
        }
        if (parseOutst != null && parseOutst.length > 0) {
            if (this.fmsImg == null || this.fmsImg.size() == 0) {
                this.fmsImg = new LinkedHashMap();
            }
            if (arg4) {
                for (String pO : parseOutst) {
                    String[] tmp = pO.split(":");
                    if (tmp == null || tmp.length == 0) continue;
                    String[] tmpOut = tmp[1].split(",");
                    pOut = new int[tmpOut.length];
                    for (int i = 0; i < pOut.length; ++i) {
                        pOut[i] = Integer.parseInt(tmpOut[i]);
                    }
                    this.fmsImg.put(tmp[0], pOut);
                }
            } else {
                this.fmsImg.put("backGroundImage", pOut);
            }
        }
    }

    public String autoSolve(String parameter) throws Exception {
        this.downloadUrl = parameter;
        try {
            this.parse();
            this.load();
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
        finally {
            try {
                this.rcBr.getHttpConnection().disconnect();
            }
            catch (Throwable throwable) {}
        }
        this.sscGetImagest(this.stImgs[0], this.stImgs[1], this.stImgs[2], Boolean.parseBoolean(this.stImgs[3]));
        this.sscGetImagest(this.sscStc[0], this.sscStc[1], this.sscStc[2], Boolean.parseBoolean(this.sscStc[3]));
        if (this.sscStc == null || this.sscStc.length == 0 || this.stImgs == null || this.stImgs.length == 0 || this.fmsImg == null || this.fmsImg.size() == 0) {
            return "CANCEL";
        }
        String out = null;
        ArrayList<Integer> marray = new ArrayList<Integer>();
        String pS = this.sscFsmCheckTwo(this.PARAMS.get("s_s_c_web_server_sign"), this.PARAMS.get("s_s_c_web_server_sign") + Encoding.Base64Decode((String)"S2hkMjFNNDc="));
        String mmUrlReq = this.SERVERSTRING.replaceAll("cjs\\?pS=\\d+&cOut", "mm\\?pS=" + pS + "&cP");
        mmUrlReq = mmUrlReq + "&mms=" + Math.random() + "&r=" + Math.random();
        KeyCaptchaImageGetter imgGetter = new KeyCaptchaImageGetter(this, new String[]{this.stImgs[1], this.sscStc[1]}, this.fmsImg, this.rcBr, mmUrlReq);
        KeyCaptchaAutoSolver kcSolver = new KeyCaptchaAutoSolver();
        this.rcBr.cloneBrowser().getPage(mmUrlReq);
        out = kcSolver.solve(imgGetter.getKeyCaptchaImage());
        marray.addAll(kcSolver.getMouseArray());
        if (out == null) {
            return null;
        }
        if ("CANCEL".equals(out)) {
            System.out.println("KeyCaptcha: User aborted captcha dialog.");
            return out;
        }
        String key = this.rcBr.getRegex("\\|([0-9a-zA-Z]+)'\\.split").getMatch(0);
        if (key == null) {
            key = Encoding.Base64Decode((String)"OTNodk9FZmhNZGU=");
        }
        String cOut = "";
        for (Integer i : marray) {
            if (cOut.length() > 1) {
                cOut = cOut + ".";
            }
            cOut = cOut + String.valueOf(i);
        }
        this.SERVERSTRING = this.SERVERSTRING.replace("cOut=", "cOut=" + this.sscFsmCheckTwo(out, key) + "..." + cOut + "&cP=");
        this.rcBr.clearCookies(this.rcBr.getHost());
        out = this.rcBr.getPage(this.SERVERSTRING.substring(0, this.SERVERSTRING.lastIndexOf("%7C")));
        out = new Regex(out, "s_s_c_setcapvalue\\( \"(.*?)\" \\)").getMatch(0);
        if (!out.matches("[0-9a-f]+\\|[0-9a-f]+\\|http://back\\d+\\.keycaptcha\\.com/swfs/ckc/[0-9a-f-]+\\|[0-9a-f-\\.]+\\|(0|1)")) {
            return null;
        }
        return out;
    }

    public Challenge<String> createChallenge(boolean noAutoSolver, Plugin plg) throws Exception {
        try {
            this.parse();
            this.load();
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
        finally {
            try {
                this.rcBr.getHttpConnection().disconnect();
            }
            catch (Throwable throwable) {}
        }
        if (this.type == null) {
            throw new PluginException(131072);
        }
        switch (this.type) {
            case CATEGORY: {
                return new KeyCaptchaCategoryChallenge(this, plg, noAutoSolver);
            }
            case PUZZLE: {
                return new KeyCaptchaPuzzleChallenge(this, plg, noAutoSolver);
            }
        }
        return null;
    }

    public Challenge<String> createChallenge(Plugin plugin) throws Exception {
        return this.createChallenge(false, plugin);
    }

    public String sendPuzzleResult(ArrayList<Integer> marray, String out) throws IOException {
        String key = this.rcBr.getRegex("\\|([0-9a-zA-Z]+)'\\.split").getMatch(0);
        if (key == null) {
            key = Encoding.Base64Decode((String)"OTNodk9FZmhNZGU=");
        }
        if (marray == null || marray.size() == 0) {
            marray = new ArrayList();
            String[] points = out.split("\\.");
            if (points.length % 2 == 0) {
                for (int i = 0; i < points.length; i += 2) {
                    int x = Integer.valueOf(points[i]);
                    int y = Integer.valueOf(points[i + 1]);
                    Point position = new Point(x, y);
                    Point randomPoint = new Point();
                    randomPoint.setLocation((double)position.x * Math.random(), (double)position.y * Math.random());
                    this.marray(marray, randomPoint);
                    this.marray(marray, position);
                }
            }
        }
        String cOut = "";
        for (Integer i : marray) {
            if (cOut.length() > 1) {
                cOut = cOut + ".";
            }
            cOut = cOut + String.valueOf(i);
        }
        this.SERVERSTRING = this.SERVERSTRING.replace("cOut=", "cOut=" + this.sscFsmCheckTwo(out, key) + "..." + cOut + "&cP=");
        this.rcBr.clearCookies(this.rcBr.getHost());
        out = this.rcBr.getPage(this.SERVERSTRING.substring(0, this.SERVERSTRING.lastIndexOf("%7C")));
        out = new Regex(out, "s_s_c_setcapvalue\\( \"(.*?)\" \\)").getMatch(0);
        if (!out.matches("[0-9a-f]+\\|[0-9a-f]+\\|http://back\\d+\\.keycaptcha\\.com/swfs/ckc/[0-9a-f-]+\\|[0-9a-f-\\.]+\\|(0|1)")) {
            return null;
        }
        return out;
    }

    private void marray(ArrayList<Integer> mouseArray, Point loc) {
        if (loc != null) {
            if (mouseArray.size() == 0) {
                mouseArray.add(loc.x + 465);
                mouseArray.add(loc.y + 264);
            }
            if (mouseArray.get(mouseArray.size() - 2) != loc.x + 465 || mouseArray.get(mouseArray.size() - 1) != loc.y + 264) {
                mouseArray.add(loc.x + 465);
                mouseArray.add(loc.y + 264);
            }
            if (mouseArray.size() > 40) {
                ArrayList<Integer> tmpMouseArray = new ArrayList<Integer>();
                tmpMouseArray.addAll(mouseArray.subList(2, 40));
                mouseArray.clear();
                mouseArray.addAll(tmpMouseArray);
            }
        }
    }

    public void sendOnMousePressFeedback() {
    }

    public String sendCategoryResult(String cOut) throws Exception {
        String resultUrl = this.categoryData.getResultUrl();
        resultUrl = resultUrl + cOut + "&cP=" + Encoding.urlEncode((String)(this.getGjsParameter() + this.getAdditionalQuery(true)));
        this.prepareBrowser(this.rcBr, null);
        String out = this.rcBr.getPage(resultUrl);
        out = new Regex(out, "s_s_c_setcapvalue\\( \"(.*?)\" \\)").getMatch(0);
        if (!out.matches("[0-9a-f]+\\|[0-9a-f]+\\|http://back\\d+\\.keycaptcha\\.com/swfs/ckc/[0-9a-f-]+\\|[0-9a-f-\\.]+\\|(0|1)")) {
            return null;
        }
        return out;
    }

    public static class ScriptEnv {
        private ScriptEngine engine;

        public ScriptEnv(ScriptEngine engine) {
            this.engine = engine;
        }

        public void log(String log) {
            System.out.println(log);
        }

        public void eval(String eval) throws ScriptException {
            this.engine.eval(eval);
        }

        public String atob(String string) {
            String ret = Encoding.Base64Decode((String)string);
            return ret;
        }
    }

    public static enum KeyCaptchaType {
        PUZZLE,
        CATEGORY;

    }
}

