/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.keycaptcha;

import java.awt.Image;
import java.awt.image.BufferedImage;
import jd.plugins.Plugin;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.utils.images.IconIO;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.challenge.keycaptcha.CategoryData;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptcha;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaResponse;

public class KeyCaptchaCategoryChallenge
extends Challenge<String> {
    private final KeyCaptcha helper;
    private final boolean noAutoSolver;
    private final Plugin plugin;

    public KeyCaptchaCategoryChallenge(KeyCaptcha keyCaptcha, Plugin plg, boolean noAutoSolver) {
        super("KeyCaptchaCategoryChallenge", null);
        this.helper = keyCaptcha;
        this.plugin = plg;
        this.noAutoSolver = noAutoSolver;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    public KeyCaptcha getHelper() {
        return this.helper;
    }

    public boolean isNoAutoSolver() {
        return this.noAutoSolver;
    }

    @Override
    public boolean validateResponse(AbstractResponse<String> response) {
        return response.getPriority() > 0;
    }

    @Override
    public AbstractResponse<String> parseAPIAnswer(String result, String resultFormat, ChallengeSolver<?> solver) {
        String token;
        try {
            token = this.helper.sendCategoryResult((String)JSonStorage.restoreFromString((String)result, (TypeRef)TypeRef.STRING));
        }
        catch (Exception e) {
            throw new WTFException((Throwable)e);
        }
        if (token != null) {
            return new KeyCaptchaResponse((Challenge<String>)this, solver, token, 100);
        }
        return null;
    }

    public Storable getAPIStorable(String format) throws Exception {
        CategoryData data = this.getHelper().getCategoryData();
        APIData ret = new APIData();
        String[] pieces = new String[data.getImages().size()];
        for (int i = 0; i < pieces.length; ++i) {
            pieces[i] = IconIO.toDataUrl((BufferedImage)IconIO.toBufferedImage((Image)data.getImages().get(i)), (IconIO.DataURLFormat)IconIO.DataURLFormat.PNG);
        }
        ret.setPieces(pieces);
        ret.setCategories(IconIO.toDataUrl((BufferedImage)data.getBackground(), (IconIO.DataURLFormat)IconIO.DataURLFormat.JPG));
        return ret;
    }

    public static class APIData
    implements Storable {
        private String[] pieces;
        private String categories;

        public String[] getPieces() {
            return this.pieces;
        }

        public void setPieces(String[] pieces) {
            this.pieces = pieces;
        }

        public String getCategories() {
            return this.categories;
        }

        public void setCategories(String categories) {
            this.categories = categories;
        }
    }
}

