/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.keycaptcha.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import jd.http.Browser;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptcha;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaPuzzleChallenge;
import org.jdownloader.updatev2.gui.LAFOptions;

class KeyCaptchaDragPieces
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final BufferedImage image;
    private final MouseAdapter mouseAdapter;
    private int k;
    private KeyCaptchaPuzzleChallenge challenge;
    private KeyCaptcha helper;
    private Browser br;

    public KeyCaptchaDragPieces(BufferedImage image, int offset, boolean sampleImg, final ArrayList<Integer> mouseArray, KeyCaptchaPuzzleChallenge challenge) {
        this.image = image;
        LAFOptions.applyBackground((Color)LAFOptions.getInstance().getColorForPanelBackground(), (JComponent)this);
        this.challenge = challenge;
        this.helper = challenge.getHelper();
        this.br = this.helper.getBrowser();
        this.mouseAdapter = new MouseInputAdapter(){
            private Point p1;
            private Point loc;
            private Timer mArrayTimer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.marray(loc);
                }
            });

            @Override
            public void mouseDragged(MouseEvent e) {
                Point p2 = e.getPoint();
                this.loc = KeyCaptchaDragPieces.this.getLocation();
                this.loc.translate(p2.x - this.p1.x, p2.y - this.p1.y);
                this.mArrayTimer.setRepeats(false);
                this.mArrayTimer.start();
                KeyCaptchaDragPieces.this.setLocation(this.loc);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.p1 = e.getPoint();
                KeyCaptchaDragPieces.this.setBorder(BorderFactory.createLineBorder(Color.black));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.p1 = e.getPoint();
                KeyCaptchaDragPieces.this.setBorder(BorderFactory.createEmptyBorder());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.mArrayTimer.start();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.p1 = e.getPoint();
                this.loc = KeyCaptchaDragPieces.this.getLocation();
                this.loc.translate(this.p1.x, this.p1.y);
                this.mArrayTimer.setRepeats(false);
                this.mArrayTimer.start();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.mArrayTimer.stop();
            }

            private void marray(Point loc) {
                if (loc != null) {
                    if (mouseArray.size() == 0) {
                        mouseArray.add(loc.x + 465);
                        mouseArray.add(loc.y + 264);
                    }
                    if ((Integer)mouseArray.get(mouseArray.size() - 2) != loc.x + 465 || (Integer)mouseArray.get(mouseArray.size() - 1) != loc.y + 264) {
                        mouseArray.add(loc.x + 465);
                        mouseArray.add(loc.y + 264);
                    }
                    if (mouseArray.size() > 40) {
                        ArrayList tmpMouseArray = new ArrayList();
                        tmpMouseArray.addAll(mouseArray.subList(2, 40));
                        mouseArray.clear();
                        mouseArray.addAll(tmpMouseArray);
                    }
                }
            }
        };
        this.k = 0;
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        if (!sampleImg) {
            this.setBounds(offset, offset, image.getWidth(), image.getHeight());
            this.setLocation(offset, offset);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.addMouseListener(this.mouseAdapter);
            this.addMouseMotionListener(this.mouseAdapter);
            this.enableEvents(48L);
        } else {
            this.setLayout(null);
            this.setBounds(449 - image.getWidth() - 10, 0, image.getWidth() + 10, image.getHeight() + 10);
            this.setBorder(BorderFactory.createLineBorder(Color.GREEN, 2));
            this.setBackground(Color.white);
            this.k = 5;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            g.drawImage(this.image, this.k, this.k, this);
        }
    }
}

