/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.keycaptcha.jac;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import jd.nutils.Colors;
import org.appwork.utils.Application;
import org.appwork.utils.Files;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaImages;
import org.jdownloader.captcha.v2.challenge.keycaptcha.jac.ImageAndPosition;
import org.jdownloader.logging.LogController;

public class KeyCaptchaAutoSolver {
    private final LogInterface logger;
    private static final int PUNISH_LINES = 6;
    private static final boolean COLLECT_PIECES = !Application.isJared(null);
    private static final int COLOR_SCAN_LENGTH = 3;
    private LinkedList<Integer> mouseArray = new LinkedList();

    public KeyCaptchaAutoSolver() {
        LogSource logger = LogController.getRebirthLogger();
        if (logger == null) {
            logger = LoggerFactory.getDefaultLogger();
        }
        this.logger = logger;
    }

    private void marray(Point loc) {
        if (loc != null) {
            if (this.mouseArray.size() == 0) {
                this.mouseArray.add(loc.x + 465);
                this.mouseArray.add(loc.y + 264);
            }
            if (this.mouseArray.get(this.mouseArray.size() - 2) != loc.x + 465 || this.mouseArray.get(this.mouseArray.size() - 1) != loc.y + 264) {
                this.mouseArray.add(loc.x + 465);
                this.mouseArray.add(loc.y + 264);
            }
            if (this.mouseArray.size() > 40) {
                ArrayList tmpMouseArray = new ArrayList();
                tmpMouseArray.addAll(this.mouseArray.subList(2, 40));
                this.mouseArray.clear();
                this.mouseArray.addAll(tmpMouseArray);
            }
        }
    }

    public LinkedList<Integer> getMouseArray() {
        return this.mouseArray;
    }

    public static Rectangle getCroppedImage(BufferedImage source, int offset) {
        try {
            int j;
            int i;
            int width = source.getWidth();
            int height = source.getHeight();
            int x0 = 0;
            int y0 = 0;
            int x1 = width;
            int y1 = height;
            block2: for (i = 0; i < width; ++i) {
                for (j = 0; j < height; ++j) {
                    if (Colors.getCMYKColorDifference1((int)source.getRGB(i, j), (int)Color.WHITE.getRGB()) > 7.0) break block2;
                }
            }
            x0 = Math.max(i - offset, 0);
            block4: for (j = 0; j < height; ++j) {
                for (i = 0; i < width; ++i) {
                    if (Colors.getCMYKColorDifference1((int)source.getRGB(i, j), (int)Color.WHITE.getRGB()) > 7.0) break block4;
                }
            }
            y0 = Math.max(j - offset, 0);
            block6: for (i = width - 1; i >= 0; --i) {
                for (j = 0; j < height; ++j) {
                    if (Colors.getCMYKColorDifference1((int)source.getRGB(i, j), (int)Color.WHITE.getRGB()) > 7.0) break block6;
                }
            }
            x1 = Math.min(i + 1 + offset, width);
            block8: for (j = height - 1; j >= 0; --j) {
                for (i = 0; i < width; ++i) {
                    if (Colors.getCMYKColorDifference1((int)source.getRGB(i, j), (int)Color.WHITE.getRGB()) > 7.0) break block8;
                }
            }
            y1 = Math.min(j + 1 + offset, height);
            return new Rectangle(x0, y0, x1 - x0, y1 - y0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        Application.setApplication((String)".jd_home");
        File masks = Application.getResource((String)"tmp/masks");
        if (masks.exists()) {
            Files.deleteRecursiv((File)masks);
        }
        masks.mkdirs();
        for (File folder : Application.getResource((String)"tmp").listFiles()) {
            if (!folder.isDirectory() || !folder.getName().contains(".png_col")) continue;
            BufferedImage merge = IconIO.createEmptyImage((int)60, (int)60);
            Graphics2D g = (Graphics2D)merge.getGraphics();
            g.setColor(Color.BLACK);
            int files = 0;
            for (File file : folder.listFiles()) {
                if (!file.getName().endsWith(".png")) continue;
                BufferedImage image = ImageIO.read(file);
                ++files;
                for (int x = 0; x < image.getWidth(); ++x) {
                    for (int y = 0; y < image.getHeight(); ++y) {
                        int rgb = image.getRGB(x, y);
                        if (rgb == 0) continue;
                        Color c = new Color(rgb, true);
                        int tol = 200;
                        if (Colors.getRGBDistance((int)rgb) != 0 || c.getRed() <= tol || c.getGreen() <= tol || c.getBlue() <= tol || c.getAlpha() <= tol) continue;
                        g.drawLine(x, y, x, y);
                    }
                }
            }
            g.dispose();
            if (files <= 5) continue;
            int m = 0;
            File mask = new File(masks, "mask_" + m + ".png");
            while (mask.exists()) {
                mask = new File(masks, "mask_" + ++m + ".png");
            }
            ImageProvider.writeImage((RenderedImage)merge, (String)"png", (File)mask);
        }
    }

    public static void main2(String[] args) throws IOException {
        Application.setApplication((String)".jd_home");
        HashSet<File> dupe = new HashSet<File>();
        for (File orgFile : Application.getResource((String)"").listFiles()) {
            BufferedImage org;
            if (!orgFile.getName().endsWith(".png") || (org = ImageIO.read(orgFile)) == null || org.getWidth() != 60 || org.getHeight() != 60 || !dupe.add(orgFile)) continue;
            File dest = new File(orgFile.getAbsolutePath() + "_col");
            dest.mkdirs();
            File copy = new File(dest, orgFile.getName());
            copy.delete();
            IO.copyFile((File)orgFile, (File)copy);
            for (File f : Application.getResource((String)"tmp").listFiles()) {
                if (dupe.contains(f) || !f.getName().endsWith(".png")) continue;
                BufferedImage image = ImageIO.read(f);
                int count = 0;
                if (image == null || image.getWidth() != org.getWidth() || image.getHeight() != org.getHeight()) continue;
                for (int x = 0; x < image.getWidth(); ++x) {
                    for (int y = 0; y < image.getHeight(); ++y) {
                        if (org.getRGB(x, y) != 0 || image.getRGB(x, y) == 0) continue;
                        ++count;
                    }
                }
                System.out.println(f + " - " + count);
                if (count != 0) continue;
                dupe.add(f);
                copy = new File(dest, f.getName());
                copy.delete();
                IO.copyFile((File)f, (File)copy);
            }
        }
    }

    public String solve(KeyCaptchaImages images) {
        try {
            this.mouseArray = new LinkedList();
            HashMap<BufferedImage, Point> imgPosition = new HashMap<BufferedImage, Point>();
            this.collectPIiecesDevOnly(images);
            int stepSize = 2;
            int stepSizeMask = 2;
            Rectangle cropping = KeyCaptchaAutoSolver.getCroppedImage(images.backgroundImage, 45);
            BufferedImage back = images.backgroundImage.getSubimage(cropping.x, cropping.y, cropping.width, cropping.height);
            BufferedImage cropped = IconIO.createEmptyImage((int)back.getWidth(), (int)back.getHeight());
            Graphics2D g = (Graphics2D)cropped.getGraphics();
            g.drawImage((Image)back, 0, 0, null);
            back = cropped;
            int pieceID = 0;
            for (BufferedImage piece : images.pieces) {
                BufferedImage mask = this.getMask(piece);
                ++pieceID;
                if (mask == null) continue;
                BufferedImage cleanedPiece = this.applyMask(piece, mask);
                int best = Integer.MAX_VALUE;
                Point bestPoint = null;
                for (int x = -cleanedPiece.getWidth() / 2; x < cropped.getWidth() - cleanedPiece.getWidth() / 2; x += stepSize) {
                    for (int y = -cleanedPiece.getHeight() / 2; y < cropped.getHeight() - cleanedPiece.getHeight() / 2; y += stepSize) {
                        int count = 0;
                        int max = 50;
                        block7: for (int x2 = 0; x2 < mask.getWidth(); x2 += stepSizeMask) {
                            for (int y2 = 0; y2 < mask.getHeight(); y2 += stepSizeMask) {
                                if (mask.getRGB(x2, y2) == 0 || x + x2 < 0 || x + x2 >= cropped.getWidth() || y + y2 < 0 || y + y2 >= cropped.getHeight()) continue;
                                try {
                                    int rgb = cropped.getRGB(x + x2, y + y2);
                                    if (this.isWhite(rgb) || ++count <= max) continue;
                                    continue block7;
                                }
                                catch (Throwable e) {
                                    count += 10000;
                                    break block7;
                                }
                            }
                        }
                        int pxCount = count;
                        if (count >= best) continue;
                        int punLeft = this.getLeftPunish(x, y, cropped, mask, cleanedPiece);
                        int punRight = this.getRightPunish(x, y, cropped, mask, cleanedPiece);
                        int punTop = this.getTopPunish(x, y, cropped, mask, cleanedPiece);
                        int punBottom = this.getBottomPunish(x, y, cropped, mask, cleanedPiece);
                        count += punLeft / 8;
                        count += punRight / 12;
                        count += punTop / 8;
                        if ((count += punBottom / 12) >= best) continue;
                        bestPoint = new Point(x, y);
                        best = count;
                    }
                }
                ImageAndPosition imagePos = new ImageAndPosition(piece, new Point(cropping.x + bestPoint.x, cropping.y + bestPoint.y));
                imgPosition.put(imagePos.image, imagePos.position);
                g.drawImage((Image)cleanedPiece, bestPoint.x, bestPoint.y, null);
                this.marray(new Point((int)(Math.random() * (double)imagePos.position.x), (int)(Math.random() * (double)imagePos.position.y)));
                this.marray(imagePos.position);
            }
            String positions = "";
            int i = 0;
            for (int c = 0; c < images.pieces.size(); ++c) {
                BufferedImage image = images.pieces.get(c);
                Point p = (Point)imgPosition.get(image);
                if (p == null) {
                    this.logger.info("Could Not Map all PIeces");
                    return null;
                }
                positions = positions + (i != 0 ? "." : "") + String.valueOf(p.x) + "." + String.valueOf(p.y);
                ++i;
            }
            return positions;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private void collectPIiecesDevOnly(KeyCaptchaImages images) throws IOException {
        if (COLLECT_PIECES) {
            int j = 0;
            File backf = Application.getResource((String)("tmp/background_" + Hash.getMD5((byte[])IconIO.toJpgBytes((Image)images.backgroundImage)) + "_" + j + ".png"));
            while (backf.exists()) {
                backf = Application.getResource((String)("tmp/background_" + Hash.getMD5((byte[])IconIO.toJpgBytes((Image)images.backgroundImage)) + "_" + ++j + ".png"));
            }
            backf.delete();
            ImageProvider.writeImage((RenderedImage)images.backgroundImage, (String)"png", (File)backf);
            for (int i = 0; i < images.pieces.size(); ++i) {
                j = 0;
                File file = Application.getResource((String)("tmp/piece_" + j + ".png"));
                while (file.exists()) {
                    file = Application.getResource((String)("tmp/piece_" + ++j + ".png"));
                }
                file.delete();
                ImageProvider.writeImage((RenderedImage)images.pieces.get(i), (String)"png", (File)file);
            }
        }
    }

    private int getRightPunish(int x, int y, BufferedImage cropped, BufferedImage mask, BufferedImage cleanedPiece) {
        int sum = 0;
        int num = 6;
        int step = cleanedPiece.getHeight() / (num + 1);
        int stepCount = 0;
        for (int i = 0; i < num; ++i) {
            int of = this.getRightPunishByOffset(x, y, cropped, mask, cleanedPiece, (i + 1) * step);
            if (of < 0) continue;
            sum += of;
            ++stepCount;
        }
        return sum / stepCount;
    }

    private int getTopPunish(int x, int y, BufferedImage cropped, BufferedImage mask, BufferedImage cleanedPiece) {
        int sum = 0;
        int num = 6;
        int step = cleanedPiece.getWidth() / (num + 1);
        int stepCount = 0;
        for (int i = 0; i < num; ++i) {
            int of = this.getTopPunishByOffset(x, y, cropped, mask, cleanedPiece, (i + 1) * step);
            if (of < 0) continue;
            sum += of;
            ++stepCount;
        }
        return sum / stepCount;
    }

    private int getBottomPunish(int x, int y, BufferedImage cropped, BufferedImage mask, BufferedImage cleanedPiece) {
        int sum = 0;
        int num = 6;
        int step = cleanedPiece.getWidth() / (num + 1);
        int stepCount = 0;
        for (int i = 0; i < num; ++i) {
            int of = this.getBottomPunishByOffset(x, y, cropped, mask, cleanedPiece, (i + 1) * step);
            if (of < 0) continue;
            sum += of;
            ++stepCount;
        }
        return sum / stepCount;
    }

    private int getLeftPunish(int x, int y, BufferedImage cropped, BufferedImage mask, BufferedImage cleanedPiece) {
        int sum = 0;
        int num = 6;
        int step = cleanedPiece.getHeight() / (num + 1);
        int stepCount = 0;
        for (int i = 0; i < num; ++i) {
            int of = this.getLeftPunishbyOffset(x, y, cropped, mask, cleanedPiece, (i + 1) * step);
            if (of < 0) continue;
            sum += of;
            ++stepCount;
        }
        return sum / stepCount;
    }

    private int getLeftPunishbyOffset(int x, int y, BufferedImage cropped, BufferedImage mask, BufferedImage cleanedPiece, int offset) {
        int punish = 255;
        try {
            int y2 = offset;
            boolean notFoundColor = true;
            for (int x2 = 0; x2 < mask.getWidth(); ++x2) {
                if (mask.getRGB(x2, y2) == 0) continue;
                notFoundColor = false;
                int rgb = cleanedPiece.getRGB(x2, y2);
                int xx = x + x2 - 1;
                int yy = y + y2;
                int m = 3;
                double bestDiff = punish;
                int bestColor = 0;
                while (m-- > 0 && xx >= 0) {
                    int c = cropped.getRGB(xx, yy);
                    --xx;
                    double dif = Colors.getColorDifference((int)c, (int)rgb);
                    Color col = new Color(c);
                    if (col.getRed() == 255 && col.getGreen() == 255 && col.getBlue() == 255) {
                        dif *= 3.0;
                    }
                    if (!(dif < bestDiff)) continue;
                    bestDiff = dif;
                    bestColor = c;
                }
                Color pCol = new Color(rgb);
                Color bCol = new Color(bestColor);
                return (int)bestDiff;
            }
            if (notFoundColor) {
                return -1;
            }
        }
        finally {
            return punish;
        }
        {
        }
    }

    private int getRightPunishByOffset(int x, int y, BufferedImage cropped, BufferedImage mask, BufferedImage cleanedPiece, int offset) {
        int punish = 255;
        try {
            int y2 = offset;
            boolean notFoundColor = true;
            for (int x2 = mask.getWidth() - 1; x2 >= 0; --x2) {
                if (mask.getRGB(x2, y2) == 0) continue;
                notFoundColor = false;
                int rgb = cleanedPiece.getRGB(x2, y2);
                int xx = x + x2 - 1;
                int yy = y + y2;
                int m = 3;
                double bestDiff = punish;
                int bestColor = 0;
                while (m-- > 0 && xx < cropped.getWidth()) {
                    int c = cropped.getRGB(xx, yy);
                    ++xx;
                    double dif = Colors.getColorDifference((int)c, (int)rgb);
                    Color col = new Color(c);
                    if (col.getRed() == 255 && col.getGreen() == 255 && col.getBlue() == 255) {
                        dif *= 3.0;
                    }
                    if (!(dif < bestDiff)) continue;
                    bestDiff = dif;
                    bestColor = c;
                }
                Color pCol = new Color(rgb);
                Color bCol = new Color(bestColor);
                return (int)bestDiff;
            }
            if (notFoundColor) {
                return -1;
            }
        }
        finally {
            return punish;
        }
        {
        }
    }

    private int getBottomPunishByOffset(int x, int y, BufferedImage cropped, BufferedImage mask, BufferedImage cleanedPiece, int offset) {
        int punish = 255;
        try {
            boolean notFoundColor = true;
            int x2 = offset;
            for (int y2 = mask.getHeight() - 1; y2 >= 0; --y2) {
                if (mask.getRGB(x2, y2) == 0) continue;
                notFoundColor = false;
                int rgb = cleanedPiece.getRGB(x2, y2);
                int xx = x + x2;
                int yy = y + y2 - 1;
                int m = 3;
                double bestDiff = punish;
                int bestColor = 0;
                while (m-- > 0 && yy < cropped.getHeight()) {
                    int c = cropped.getRGB(xx, yy);
                    ++yy;
                    double dif = Colors.getColorDifference((int)c, (int)rgb);
                    Color col = new Color(c);
                    if (col.getRed() == 255 && col.getGreen() == 255 && col.getBlue() == 255) {
                        dif *= 3.0;
                    }
                    if (!(dif < bestDiff)) continue;
                    bestDiff = dif;
                    bestColor = c;
                }
                Color pCol = new Color(rgb);
                Color bCol = new Color(bestColor);
                return (int)bestDiff;
            }
            if (notFoundColor) {
                return -1;
            }
        }
        finally {
            return punish;
        }
        {
        }
    }

    private int getTopPunishByOffset(int x, int y, BufferedImage cropped, BufferedImage mask, BufferedImage cleanedPiece, int offset) {
        int punish = 255;
        try {
            int x2 = offset;
            boolean notFoundColor = true;
            for (int y2 = 0; y2 < mask.getHeight(); ++y2) {
                if (mask.getRGB(x2, y2) == 0) continue;
                notFoundColor = false;
                int rgb = cleanedPiece.getRGB(x2, y2);
                int xx = x + x2;
                int yy = y + y2 - 1;
                int m = 3;
                double bestDiff = punish;
                int bestColor = 0;
                while (m-- > 0 && yy >= 0) {
                    int c = cropped.getRGB(xx, yy);
                    --yy;
                    double dif = Colors.getColorDifference((int)c, (int)rgb);
                    Color col = new Color(c);
                    if (col.getRed() == 255 && col.getGreen() == 255 && col.getBlue() == 255) {
                        dif *= 3.0;
                    }
                    if (!(dif < bestDiff)) continue;
                    bestDiff = dif;
                    bestColor = c;
                }
                Color pCol = new Color(rgb);
                Color bCol = new Color(bestColor);
                return (int)bestDiff;
            }
            if (notFoundColor) {
                return -1;
            }
        }
        finally {
            return punish;
        }
        {
        }
    }

    private boolean isWhite(int rgb) {
        int tol = 250;
        Color c = new Color(rgb);
        return Colors.getRGBDistance((int)rgb) == 0 && c.getRed() > tol && c.getGreen() > tol && c.getBlue() > tol;
    }

    private BufferedImage applyMask(BufferedImage piece, BufferedImage maskImage) {
        BufferedImage merge = IconIO.createEmptyImage((int)60, (int)60);
        Graphics2D g = (Graphics2D)merge.getGraphics();
        g.setColor(Color.BLACK);
        for (int x = 0; x < maskImage.getWidth(); ++x) {
            for (int y = 0; y < maskImage.getHeight(); ++y) {
                if (maskImage.getRGB(x, y) == 0) continue;
                g.setColor(new Color(piece.getRGB(x, y), true));
                g.drawLine(x, y, x, y);
            }
        }
        g.dispose();
        return merge;
    }

    private BufferedImage getMask(BufferedImage piece) throws IOException {
        int i = 0;
        BufferedImage mask = null;
        int bestCount = Integer.MAX_VALUE;
        while (true) {
            URL url = this.getClass().getResource("masks/mask_" + i + ".png");
            ++i;
            if (url == null) {
                return mask;
            }
            BufferedImage maskImage = ImageIO.read(url);
            int count = 0;
            for (int x = 0; x < maskImage.getWidth(); ++x) {
                for (int y = 0; y < maskImage.getHeight(); ++y) {
                    int rgb;
                    if (maskImage.getRGB(x, y) == 0 || (rgb = piece.getRGB(x, y)) != 0) continue;
                    ++count;
                }
            }
            if (count >= bestCount) continue;
            mask = maskImage;
            bestCount = count;
        }
    }
}

