/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.oauth;

import java.util.EventListener;
import jd.controlling.captcha.SkipException;
import jd.controlling.captcha.SkipRequest;
import jd.gui.swing.jdgui.JDGui;
import org.appwork.exceptions.WTFException;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeResponseController;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.challenge.oauth.OAuthChallenge;
import org.jdownloader.captcha.v2.challenge.oauth.OAuthDialogHandler;
import org.jdownloader.captcha.v2.solver.gui.DialogBasicCaptchaSolver;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.captcha.v2.solver.service.BrowserSolverService;
import org.jdownloader.captcha.v2.solverjob.ChallengeSolverJobListener;
import org.jdownloader.captcha.v2.solverjob.ResponseList;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.settings.staticreferences.CFG_SILENTMODE;

public class OAuthDialogSolver
extends ChallengeSolver<Boolean> {
    private static final OAuthDialogSolver INSTANCE = new OAuthDialogSolver();
    private OAuthDialogHandler handler;

    public static OAuthDialogSolver getInstance() {
        return INSTANCE;
    }

    @Override
    protected boolean isChallengeSupported(Challenge<?> c) {
        return c instanceof OAuthChallenge;
    }

    private OAuthDialogSolver() {
        super(BrowserSolverService.getInstance(), 1);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public Class<Boolean> getResultType() {
        return Boolean.class;
    }

    public void checkSilentMode(final SolverJob<Boolean> job) throws SkipException, InterruptedException {
        if (JDGui.getInstance().isSilentModeActive()) {
            switch (CFG_SILENTMODE.CFG.getOnCaptchaDuringSilentModeAction()) {
                case WAIT_IN_BACKGROUND_UNTIL_WINDOW_GETS_FOCUS_OR_TIMEOUT: {
                    break;
                }
                case DISABLE_DIALOG_SOLVER: {
                    job.getEventSender().addListener(new ChallengeSolverJobListener(){

                        @Override
                        public void onSolverTimedOut(ChallengeSolver<?> parameter) {
                        }

                        @Override
                        public void onSolverStarts(ChallengeSolver<?> parameter) {
                        }

                        @Override
                        public void onSolverJobReceivedNewResponse(AbstractResponse<?> response) {
                        }

                        @Override
                        public void onSolverDone(ChallengeSolver<?> solver) {
                            if (job.isDone()) {
                                if (!job.isSolved()) {
                                    ChallengeResponseController.getInstance().setSkipRequest(SkipRequest.SINGLE, OAuthDialogSolver.this, job.getChallenge());
                                }
                                job.getEventSender().removeListener(this);
                            }
                        }
                    });
                    return;
                }
                case SKIP_LINK: {
                    throw new SkipException(job.getChallenge(), SkipRequest.SINGLE);
                }
            }
        }
        OAuthDialogSolver.checkInterruption();
    }

    public void requestFocus(Challenge<?> challenge) {
        OAuthDialogHandler hndlr = this.handler;
        if (hndlr != null) {
            hndlr.requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void solve(SolverJob<Boolean> job) throws InterruptedException, SolverException, SkipException {
        DialogBasicCaptchaSolver dialogBasicCaptchaSolver = DialogBasicCaptchaSolver.getInstance();
        synchronized (dialogBasicCaptchaSolver) {
            EventListener jacListener = null;
            this.checkSilentMode(job);
            this.handler = new OAuthDialogHandler((OAuthChallenge)job.getChallenge());
            try {
                ResponseList<Boolean> resp = job.getResponse();
                OAuthDialogSolver.checkInterruption();
                job.getChallenge().sendStatsSolving(this);
                this.handler.run();
            }
            catch (SkipException e) {
                throw e;
            }
            catch (Exception e) {
                job.getChallenge().sendStatsError(this, e);
                throw new WTFException((Throwable)e);
            }
            finally {
                job.getLogger().info("Dialog closed. Response far: " + job.getResponse());
                if (jacListener != null) {
                    job.getEventSender().removeListener(jacListener);
                }
                this.handler = null;
            }
        }
    }
}

