/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.recaptcha.v2;

import java.awt.Point;
import java.awt.Rectangle;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.WindowsMouseSpeedWorkaround;
import org.jdownloader.captcha.v2.solver.browser.BrowserViewport;
import org.jdownloader.captcha.v2.solver.browser.BrowserWindow;

public abstract class Recaptcha2BrowserViewport
extends BrowserViewport {
    protected final Rectangle recaptchaIframe;

    @Override
    public void onLoaded() {
        super.onLoaded();
        try {
            Thread.sleep((long)(Math.random() * 1000.0));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Point oldloc = ToolTipController.getMouseLocation();
        int clickX = this.recaptchaIframe.x + this.scale(22) + this.scale(Math.random() * 20.0);
        int clickY = this.recaptchaIframe.y + this.scale(32) + this.scale(Math.random() * 20.0);
        WindowsMouseSpeedWorkaround workaround = null;
        Integer mouseSpeed = null;
        if (CrossSystem.isWindows()) {
            try {
                workaround = new WindowsMouseSpeedWorkaround();
                mouseSpeed = workaround.getMouseSpeed();
                this.getLogger().info("GetMouseSpeed(Before):" + mouseSpeed);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
        this.getRobot().mouseMove(clickX, clickY);
        this.getRobot().mousePress(16);
        this.getRobot().mouseRelease(16);
        this.getRobot().mousePress(16);
        this.getRobot().mouseRelease(16);
        if (oldloc != null) {
            this.getRobot().mouseMove(oldloc.x, oldloc.y);
        }
        if (CrossSystem.isWindows() && workaround != null && mouseSpeed != null) {
            try {
                this.getLogger().info("GetMouseSpeed(After):" + workaround.getMouseSpeed());
                this.getLogger().info("Set(Before)MouseSpeed:(" + mouseSpeed + ")|" + workaround.setMouseSpeed(mouseSpeed));
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public Recaptcha2BrowserViewport(BrowserWindow screenResource, Rectangle rect, Rectangle elementBounds) {
        super(screenResource);
        this.recaptchaIframe = rect;
        this.scale = (double)this.recaptchaIframe.width / 306.0;
        this.width = this.scale(screenResource.getViewportWidth());
        this.height = this.scale(screenResource.getViewportHeight());
        if (elementBounds == null) {
            this.x = Math.max(screenResource.getX(), rect.x - this.scale(48));
            this.y = Math.max(screenResource.getY(), rect.y - this.scale(164));
        } else {
            this.x = rect.x - elementBounds.x;
            this.y = rect.y - elementBounds.y;
        }
    }
}

