/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.stringcaptcha;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import jd.nutils.encoding.Base64;
import jd.plugins.Plugin;
import org.appwork.utils.StringUtils;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.net.Base64OutputStream;
import org.jdownloader.captcha.v2.Challenge;
import org.seamless.util.io.IO;

public abstract class ImageCaptchaChallenge<T>
extends Challenge<T> {
    protected volatile File imageFile;
    private final Plugin plugin;

    public ImageCaptchaChallenge(File file, String method, String explain, Plugin plugin) {
        super(method, explain);
        this.imageFile = file;
        this.plugin = plugin;
    }

    public Image getImage() throws IOException {
        File imageFile = this.getImageFile();
        if (imageFile == null || !imageFile.isFile()) {
            return null;
        }
        return ImageIO.read(imageFile);
    }

    public byte[] getAnnotatedImageBytes() throws IOException {
        return IconIO.toJpgBytes((Image)this.getAnnotatedImage());
    }

    public Image getAnnotatedImage() throws IOException {
        return this.getImage();
    }

    public String toString() {
        return "CaptchaChallenge by " + this.getHost() + "-" + this.getTypeID() + " File: " + this.getImageFile();
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    public synchronized File getImageFile() {
        if (this.imageFile == null && this.plugin != null) {
            this.imageFile = this.plugin.getLocalCaptchaFile();
        }
        return this.imageFile;
    }

    public String getBase64ImageFile() throws IOException {
        File imageFile = this.getImageFile();
        if (imageFile == null || !imageFile.isFile()) {
            return null;
        }
        byte[] data = IO.readBytes((File)imageFile);
        return Base64.encodeToString((byte[])data, (boolean)false);
    }

    public void setImageFile(File imageFile) {
        this.imageFile = imageFile;
    }

    @Override
    public Object getAPIStorable(String format) throws Exception {
        File imageFile = this.getImageFile();
        if (StringUtils.endsWithCaseInsensitive((String)imageFile.getName(), (String)"gif")) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Base64OutputStream b64os = new Base64OutputStream((OutputStream)bos);
            b64os.write(IO.readBytes((File)imageFile));
            b64os.close();
            return "image/gif;base64," + bos.toString("UTF-8");
        }
        if (StringUtils.endsWithCaseInsensitive((String)imageFile.getName(), (String)"png")) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Base64OutputStream b64os = new Base64OutputStream((OutputStream)bos);
            b64os.write(IO.readBytes((File)imageFile));
            b64os.close();
            return "image/png;base64," + bos.toString("UTF-8");
        }
        if (StringUtils.endsWithCaseInsensitive((String)imageFile.getName(), (String)"jpg") || StringUtils.endsWithCaseInsensitive((String)imageFile.getName(), (String)"jpeg")) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Base64OutputStream b64os = new Base64OutputStream((OutputStream)bos);
            b64os.write(IO.readBytes((File)imageFile));
            b64os.close();
            return "image/jpeg;base64," + bos.toString("UTF-8");
        }
        return IconIO.toDataUrl((BufferedImage)ImageIO.read(this.getImageFile()), (IconIO.DataURLFormat)IconIO.DataURLFormat.JPG);
    }
}

