/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.sweetcaptcha;

import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import jd.parser.html.Form;
import jd.plugins.Plugin;
import org.appwork.utils.Regex;
import org.appwork.utils.logging2.LogInterface;
import org.jdownloader.logging.LogController;

public abstract class AbstractCaptchaHelperSweetCaptcha<T extends Plugin> {
    protected T plugin;
    protected LogInterface logger;
    protected Browser br;
    protected String siteKey;
    protected String appKey;

    public AbstractCaptchaHelperSweetCaptcha(T plugin, Browser br, String siteKey, String appKey) {
        this.plugin = plugin;
        this.br = br;
        if (br.getRequest() == null) {
            throw new IllegalStateException("Browser.getRequest() == null!");
        }
        this.logger = ((Plugin)plugin).getLogger();
        if (this.logger == null) {
            this.logger = LogController.getInstance().getLogger(this.getClass().getSimpleName());
        }
        this.siteKey = siteKey;
        this.appKey = appKey;
    }

    public T getPlugin() {
        return this.plugin;
    }

    public String getSweetCaptchaApiKey() {
        return AbstractCaptchaHelperSweetCaptcha.getSweetCaptchaApiKey(this.br != null ? this.br.toString() : null);
    }

    public static String getSweetCaptchaApiKey(String source) {
        if (source == null) {
            return null;
        }
        String apiKey = new Regex(source, "<div[^>]+id=(?:\"|'|)(sc_[a-f0-9]{7})").getMatch(0);
        return apiKey;
    }

    public String getSweetCaptchaAppKey() {
        return AbstractCaptchaHelperSweetCaptcha.getSweetCaptchaAppKey(this.br != null ? this.br.toString() : null);
    }

    public static String getSweetCaptchaAppKey(String source) {
        if (source == null) {
            return null;
        }
        String apiKey = new Regex(source, "sweetcaptcha\\.com/api/v2/apps/(\\d+)/captcha/sc_").getMatch(0);
        return apiKey;
    }

    public Form setFormValues(Form form, String results) {
        String[][] args;
        for (String[] arg : args = new Regex(results, "\\[\\s*\"(.*?)\"\\s*,\\s*\"(.*?)\"\\s*\\]").getMatches()) {
            form.put(arg[0], Encoding.urlEncode((String)arg[1]));
        }
        return form;
    }
}

