/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.challenge.xsolver;

import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jd.captcha.JACMethod;
import jd.captcha.JAntiCaptcha;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.utils.GifDecoder;
import jd.nutils.Colors;
import org.jdownloader.captcha.v2.challenge.xsolver.Circle;

public class CaptXSolver {
    public static Point solveCaptXCaptcha(byte[] bytes) throws Exception {
        String method = "lnkcrptwsCircles";
        if (JACMethod.hasMethod((String)"lnkcrptwsCircles")) {
            JAntiCaptcha jac = new JAntiCaptcha("lnkcrptwsCircles");
            BufferedImage image = CaptXSolver.toBufferedImage(new ByteArrayInputStream(bytes));
            Captcha captcha = Captcha.getCaptcha((Image)image, (JAntiCaptcha)jac);
            Point point = CaptXSolver.getOpenCircleCentrePoint(captcha);
            return point;
        }
        return null;
    }

    private static boolean equalElements(int c, int c2) {
        return c == c2;
    }

    private static boolean isWhite(int c) {
        return c < 0 || c == 0xFFFFFF;
    }

    public static List<PixelObject> getObjects(Captcha grid) {
        ArrayList<PixelObject> ret = new ArrayList<PixelObject>();
        for (int x = 0; x < grid.getWidth(); ++x) {
            for (int y = 0; y < grid.getHeight(); ++y) {
                int c = grid.getGrid()[x][y];
                if (CaptXSolver.isWhite(c)) continue;
                PixelObject n = new PixelObject((PixelGrid)grid);
                n.add(x, y, c);
                ArrayList<PixelObject> merge = new ArrayList<PixelObject>();
                for (PixelObject o : ret) {
                    if (!o.isTouching(x, y, true, 5, 5) || !CaptXSolver.equalElements(c, o.getMostcolor())) continue;
                    merge.add(o);
                }
                if (merge.size() == 0) {
                    ret.add(n);
                    continue;
                }
                if (merge.size() == 1) {
                    ((PixelObject)merge.get(0)).add(n);
                    continue;
                }
                for (PixelObject po : merge) {
                    ret.remove(po);
                    n.add(po);
                }
                ret.add(n);
            }
        }
        return ret;
    }

    public static Point getOpenCircleCentrePoint(Captcha captcha) throws InterruptedException {
        List<PixelObject> ob = CaptXSolver.getObjects(captcha);
        Iterator<PixelObject> iterator = ob.iterator();
        while (iterator.hasNext()) {
            PixelObject pixelObject = iterator.next();
            int ratio = pixelObject.getHeight() * 100 / pixelObject.getWidth();
            if (ratio <= 110 && ratio >= 90) continue;
            iterator.remove();
        }
        Circle circle = new Circle(captcha, ob);
        circle.inBorder = 3;
        circle.outBorder = 2;
        circle.isElementColor = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.equals(o2) ? 1 : 0;
            }
        };
        Letter openCircle = circle.getOpenCircle();
        int x = openCircle.getLocation()[0] + openCircle.getWidth() / 2;
        int y = openCircle.getLocation()[1] + openCircle.getHeight() / 2;
        return new Point(x, y);
    }

    public static BufferedImage toBufferedImage(InputStream is) throws InterruptedException {
        int bl1;
        int i;
        int y;
        JAntiCaptcha jac = new JAntiCaptcha("easycaptcha");
        jac.getJas().setColorType("RGB");
        GifDecoder d = new GifDecoder();
        d.read(is);
        int n = d.getFrameCount();
        Captcha[] frames = new Captcha[d.getFrameCount()];
        for (int i2 = 0; i2 < n; ++i2) {
            BufferedImage frame = d.getFrame(i2);
            frames[i2] = jac.createCaptcha((Image)frame);
        }
        int[][] grid = new int[frames[0].getWidth()][frames[0].getHeight()];
        for (int x = 0; x < grid.length; ++x) {
            for (y = 0; y < grid[0].length; ++y) {
                int max = 0;
                HashMap<Integer, Integer> colors = new HashMap<Integer, Integer>();
                for (i = 0; i < frames.length; ++i) {
                    float[] hsb = Colors.rgb2hsb((int)frames[i].getGrid()[x][y]);
                    int distance = Colors.getRGBDistance((int)frames[i].getGrid()[x][y]);
                    if (!colors.containsKey(frames[i].getGrid()[x][y])) {
                        colors.put(frames[i].getGrid()[x][y], 1);
                    } else {
                        colors.put(frames[i].getGrid()[x][y], (Integer)colors.get(frames[i].getGrid()[x][y]) + 1);
                    }
                    if ((double)hsb[2] < 0.2 && distance < 100) continue;
                    max = Math.max(max, frames[i].getGrid()[x][y]);
                }
                int mainColor = 0;
                int mainCount = 0;
                for (Map.Entry col : colors.entrySet()) {
                    if ((Integer)col.getValue() <= mainCount || (Integer)col.getKey() <= 10) continue;
                    mainCount = (Integer)col.getValue();
                    mainColor = (Integer)col.getKey();
                }
                grid[x][y] = mainColor;
            }
        }
        int gl1 = grid[0].length - 1;
        for (int x = 0; x < grid.length; ++x) {
            bl1 = 0;
            int bl2 = 0;
            for (i = Math.max(0, x - 6); i < Math.min(grid.length, x + 6); ++i) {
                if (grid[i][0] == 0) {
                    ++bl1;
                }
                if (grid[i][gl1] != 0) continue;
                ++bl2;
            }
            if (bl1 == 12) {
                CaptXSolver.cleanBlack(x, 0, grid);
            }
            if (bl2 != 12) continue;
            CaptXSolver.cleanBlack(x, gl1, grid);
        }
        gl1 = grid.length - 1;
        for (y = 0; y < grid.length; ++y) {
            bl1 = 0;
            int bl2 = 0;
            for (i = Math.max(0, y - 6); i < Math.min(grid[0].length, y + 6); ++i) {
                if (grid[0][i] == 0) {
                    ++bl1;
                }
                if (grid[gl1][i] != 0) continue;
                ++bl2;
            }
            if (bl1 == 12) {
                CaptXSolver.cleanBlack(0, y, grid);
            }
            if (bl2 != 12) continue;
            CaptXSolver.cleanBlack(gl1, y, grid);
        }
        frames[0].setGrid(grid);
        return frames[0].getImage(1);
    }

    public static void cleanBlack(int x, int y, int[][] grid) {
        for (int x1 = Math.max(x - 2, 0); x1 < Math.min(x + 2, grid.length); ++x1) {
            for (int y1 = Math.max(y - 2, 0); y1 < Math.min(y + 2, grid[0].length); ++y1) {
                if (grid[x1][y1] != 0) continue;
                grid[x1][y1] = 0xFFFFFF;
                CaptXSolver.cleanBlack(x1, y1, grid);
            }
        }
    }
}

