/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.antiCaptchaCom;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import jd.http.Browser;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.net.URLHelper;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.SolverStatus;
import org.jdownloader.captcha.v2.challenge.hcaptcha.HCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.BasicCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.ImageCaptchaChallenge;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.captcha.v2.solver.antiCaptchaCom.AbstractAntiCaptchaComSolver;
import org.jdownloader.captcha.v2.solver.antiCaptchaCom.AntiCaptchaComAccount;
import org.jdownloader.captcha.v2.solver.antiCaptchaCom.AntiCaptchaComResponse;
import org.jdownloader.captcha.v2.solver.antiCaptchaCom.AntiCaptchaComSolverService;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.staticreferences.CFG_ANTICAPTCHA_COM;

public class AntiCaptchaComSolver
extends AbstractAntiCaptchaComSolver<String> {
    private static final AntiCaptchaComSolver INSTANCE = new AntiCaptchaComSolver();

    public static AntiCaptchaComSolver getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<String> getResultType() {
        return String.class;
    }

    @Override
    public AntiCaptchaComSolverService getService() {
        return (AntiCaptchaComSolverService)super.getService();
    }

    private AntiCaptchaComSolver() {
        this.getService().setSolver(this);
    }

    @Override
    protected boolean isChallengeSupported(Challenge<?> c) {
        return c instanceof HCaptchaChallenge || c instanceof RecaptchaV2Challenge || c instanceof BasicCaptchaChallenge;
    }

    private void errorHandling(AntiCaptchaComAccount account, Map<String, Object> response) throws Exception {
        Number errorID = (Number)response.get("errorId");
        switch (errorID.intValue()) {
            case 0: {
                return;
            }
            case 1: {
                if (account != null) {
                    account.setError(String.valueOf(response.get("errorDescription")));
                }
                CFG_ANTICAPTCHA_COM.API_KEY.setValue(null);
                throw new SolverException("ErrorID:" + errorID + "|Error:" + response.get("errorDescription"));
            }
            case 10: {
                if (account != null) {
                    account.setError(String.valueOf(response.get("errorDescription")));
                }
                throw new SolverException("ErrorID:" + errorID + "|Error:" + response.get("errorDescription"));
            }
        }
        throw new SolverException("ErrorID:" + errorID + "|Error:" + response.get("errorDescription"));
    }

    @Override
    protected void solveCES(CESSolverJob<String> job) throws InterruptedException, SolverException {
        Challenge<String> challenge = job.getChallenge();
        if (challenge instanceof HCaptchaChallenge) {
            this.handleHCaptcha(job);
        } else if (challenge instanceof RecaptchaV2Challenge) {
            this.handleRecaptchaV2(job);
        } else if (challenge instanceof ImageCaptchaChallenge) {
            this.handleImageCaptcha(job);
        }
    }

    private void handleImageCaptcha(CESSolverJob<String> job) throws InterruptedException {
        Challenge<String> challenge = job.getChallenge();
        job.showBubble(this);
        AntiCaptchaComSolver.checkInterruption();
        try {
            job.getChallenge().sendStatsSolving(this);
            Browser br = this.createNewBrowserInstance();
            br.setReadTimeout(300000);
            job.setStatus(SolverStatus.SOLVING);
            HashMap<String, Object> task = new HashMap<String, Object>();
            task.put("type", "ImageToTextTask");
            task.put("body", Base64.encodeToString((byte[])IO.readFile((File)((ImageCaptchaChallenge)challenge).getImageFile()), (boolean)false));
            task.put("phrase", false);
            task.put("case", true);
            task.put("numeric", false);
            task.put("math", false);
            task.put("minLength", 0);
            task.put("maxLength", 0);
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("clientKey", this.config.getApiKey());
            dataMap.put("task", task);
            dataMap.put("softId", 832);
            String json = br.postPageRaw(URLHelper.parseLocation((URL)new URL(this.config.getApiBase()), (String)"/createTask"), JSonStorage.serializeToJson(dataMap));
            HashMap response = (HashMap)JSonStorage.restoreFromString((String)json, (TypeRef)TypeRef.HASHMAP);
            this.errorHandling(null, response);
            int taskID = ((Number)response.get("taskId")).intValue();
            job.setStatus(new SolverStatus(_GUI.T.DeathByCaptchaSolver_solveBasicCaptchaChallenge_solving(), NewTheme.I().getIcon("wait", 20)));
            while (true) {
                dataMap = new HashMap();
                dataMap.put("clientKey", this.config.getApiKey());
                dataMap.put("taskId", taskID);
                json = br.postPageRaw(URLHelper.parseLocation((URL)new URL(this.config.getApiBase()), (String)"/getTaskResult"), JSonStorage.serializeToJson(dataMap));
                response = (HashMap)JSonStorage.restoreFromString((String)json, (TypeRef)TypeRef.HASHMAP);
                this.errorHandling(null, response);
                this.logger.info(json);
                if ("ready".equals(response.get("status"))) break;
                Thread.sleep(1000L);
            }
            Map solution = (Map)response.get("solution");
            job.setAnswer(new AntiCaptchaComResponse(challenge, this, taskID, String.valueOf(solution.get("text"))));
            return;
        }
        catch (Exception e) {
            job.getChallenge().sendStatsError(this, e);
            job.getLogger().log((Throwable)e);
            return;
        }
    }

    private void handleHCaptcha(CESSolverJob<String> job) throws InterruptedException {
        HCaptchaChallenge challenge = (HCaptchaChallenge)job.getChallenge();
        job.showBubble(this);
        AntiCaptchaComSolver.checkInterruption();
        try {
            job.getChallenge().sendStatsSolving(this);
            Browser br = this.createNewBrowserInstance();
            br.setReadTimeout(300000);
            job.setStatus(SolverStatus.SOLVING);
            HashMap<String, String> task = new HashMap<String, String>();
            task.put("type", "HCaptchaTaskProxyless");
            task.put("websiteURL", challenge.getSiteUrl());
            task.put("websiteKey", challenge.getSiteKey());
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("clientKey", this.config.getApiKey());
            dataMap.put("task", task);
            dataMap.put("softId", 832);
            String json = br.postPageRaw(URLHelper.parseLocation((URL)new URL(this.config.getApiBase()), (String)"/createTask"), JSonStorage.serializeToJson(dataMap));
            HashMap response = (HashMap)JSonStorage.restoreFromString((String)json, (TypeRef)TypeRef.HASHMAP);
            this.errorHandling(null, response);
            int taskID = ((Number)response.get("taskId")).intValue();
            job.setStatus(new SolverStatus(_GUI.T.DeathByCaptchaSolver_solveBasicCaptchaChallenge_solving(), NewTheme.I().getIcon("wait", 20)));
            while (true) {
                dataMap = new HashMap();
                dataMap.put("clientKey", this.config.getApiKey());
                dataMap.put("taskId", taskID);
                json = br.postPageRaw(URLHelper.parseLocation((URL)new URL(this.config.getApiBase()), (String)"/getTaskResult"), JSonStorage.serializeToJson(dataMap));
                response = (HashMap)JSonStorage.restoreFromString((String)json, (TypeRef)TypeRef.HASHMAP);
                this.errorHandling(null, response);
                this.logger.info(json);
                if ("ready".equals(response.get("status"))) break;
                Thread.sleep(1000L);
            }
            Map solution = (Map)response.get("solution");
            job.setAnswer(new AntiCaptchaComResponse((Challenge<String>)challenge, this, taskID, String.valueOf(solution.get("gRecaptchaResponse"))));
            return;
        }
        catch (Exception e) {
            job.getChallenge().sendStatsError(this, e);
            job.getLogger().log((Throwable)e);
            return;
        }
    }

    private void handleRecaptchaV2(CESSolverJob<String> job) throws InterruptedException {
        RecaptchaV2Challenge challenge = (RecaptchaV2Challenge)job.getChallenge();
        job.showBubble(this);
        AntiCaptchaComSolver.checkInterruption();
        try {
            job.getChallenge().sendStatsSolving(this);
            Browser br = this.createNewBrowserInstance();
            br.setReadTimeout(300000);
            job.setStatus(SolverStatus.SOLVING);
            HashMap<String, Object> task = new HashMap<String, Object>();
            task.put("websiteURL", challenge.getSiteUrl());
            task.put("websiteKey", challenge.getSiteKey());
            if (challenge.getV3Action() != null) {
                String action;
                task.put("type", "RecaptchaV3TaskProxyless");
                if (challenge.isEnterprise()) {
                    task.put("isEnterprise", Boolean.TRUE);
                }
                if ((action = (String)challenge.getV3Action().get("action")) != null) {
                    task.put("pageAction", action);
                }
                task.put("minScore", 0.3);
            } else {
                if (challenge.isEnterprise()) {
                    task.put("type", "RecaptchaV2EnterpriseTaskProxyless");
                } else {
                    task.put("type", "RecaptchaV2TaskProxyless");
                }
                if (challenge.isInvisible()) {
                    task.put("isInvisible", Boolean.TRUE);
                }
            }
            if (StringUtils.isNotEmpty((String)challenge.getSecureToken())) {
                task.put("websiteSToken", challenge.getSecureToken());
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("clientKey", this.config.getApiKey());
            dataMap.put("task", task);
            dataMap.put("softId", 832);
            String json = br.postPageRaw(URLHelper.parseLocation((URL)new URL(this.config.getApiBase()), (String)"/createTask"), JSonStorage.serializeToJson(dataMap));
            HashMap response = (HashMap)JSonStorage.restoreFromString((String)json, (TypeRef)TypeRef.HASHMAP);
            this.errorHandling(null, response);
            int taskID = ((Number)response.get("taskId")).intValue();
            job.setStatus(new SolverStatus(_GUI.T.DeathByCaptchaSolver_solveBasicCaptchaChallenge_solving(), NewTheme.I().getIcon("wait", 20)));
            while (true) {
                dataMap = new HashMap();
                dataMap.put("clientKey", this.config.getApiKey());
                dataMap.put("taskId", taskID);
                json = br.postPageRaw(URLHelper.parseLocation((URL)new URL(this.config.getApiBase()), (String)"/getTaskResult"), JSonStorage.serializeToJson(dataMap));
                response = (HashMap)JSonStorage.restoreFromString((String)json, (TypeRef)TypeRef.HASHMAP);
                this.errorHandling(null, response);
                this.logger.info(json);
                if ("ready".equals(response.get("status"))) break;
                Thread.sleep(1000L);
            }
            Map solution = (Map)response.get("solution");
            job.setAnswer(new AntiCaptchaComResponse((Challenge<String>)challenge, this, taskID, String.valueOf(solution.get("gRecaptchaResponse"))));
            return;
        }
        catch (Exception e) {
            job.getChallenge().sendStatsError(this, e);
            job.getLogger().log((Throwable)e);
            return;
        }
    }

    @Override
    protected boolean validateLogins() {
        if (!CFG_ANTICAPTCHA_COM.ENABLED.isEnabled()) {
            return false;
        }
        return !StringUtils.isEmpty((String)CFG_ANTICAPTCHA_COM.API_KEY.getValue());
    }

    @Override
    public boolean setInvalid(AbstractResponse<?> response) {
        return false;
    }

    public AntiCaptchaComAccount loadAccount() {
        AntiCaptchaComAccount ret = new AntiCaptchaComAccount();
        try {
            Browser br = this.createNewBrowserInstance();
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("clientKey", this.config.getApiKey());
            String json = br.postPageRaw(URLHelper.parseLocation((URL)new URL(this.config.getApiBase()), (String)"/getBalance"), JSonStorage.serializeToJson(dataMap));
            Map response = (Map)JSonStorage.restoreFromString((String)json, (TypeRef)TypeRef.MAP);
            this.errorHandling(null, response);
            ret.setBalance(((Number)response.get("balance")).doubleValue());
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            ret.setError(e.getMessage());
        }
        return ret;
    }

    public static class BalanceResponse
    implements Storable {
        private int status;
        private String request;

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public String getRequest() {
            return this.request;
        }

        public void setRequest(String request) {
            this.request = request;
        }
    }
}

