/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.browser;

import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import jd.controlling.captcha.SkipRequest;
import jd.parser.Regex;
import jd.plugins.Plugin;
import org.appwork.controlling.SingleReachableState;
import org.appwork.exceptions.WTFException;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.net.protocol.http.ResponseCodeInterface;
import org.appwork.remoteapi.exceptions.BasicRemoteAPIException;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.URLHelper;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.HttpHandlerInfo;
import org.appwork.utils.net.httpserver.handler.ExtendedHttpRequestHandler;
import org.appwork.utils.net.httpserver.handler.HttpRequestHandler;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.processes.ProcessBuilderFactory;
import org.jdownloader.api.DeprecatedAPIHttpServerController;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeResponseController;
import org.jdownloader.captcha.v2.solver.browser.AbstractBrowserChallenge;
import org.jdownloader.captcha.v2.solver.browser.BrowserCaptchaSolverConfig;
import org.jdownloader.captcha.v2.solver.browser.BrowserSolver;
import org.jdownloader.captcha.v2.solver.browser.BrowserViewport;
import org.jdownloader.captcha.v2.solver.browser.BrowserWindow;
import org.jdownloader.captcha.v2.solver.service.BrowserSolverService;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public abstract class BrowserReference
implements ExtendedHttpRequestHandler,
HttpRequestHandler,
HttpConnection.ConnectionHook {
    private final AbstractBrowserChallenge challenge;
    private final UniqueAlltimeID id = new UniqueAlltimeID();
    private final HashMap<String, URL> resourceIds = new HashMap();
    private final HashMap<String, String> types;
    protected String base;
    protected final AtomicReference<HttpHandlerInfo> handlerInfo;
    protected final SingleReachableState canClose;
    protected static final Queue QUEUE = new Queue("BrowserReference"){

        public void killQueue() {
            LogController.CL().log(new Throwable("YOU CANNOT KILL ME!"));
        }
    };
    protected String lastRequestString;
    private static final AtomicInteger HIGHEST_BROWSER_EXTENSION_VERSION = new AtomicInteger(-1);

    public UniqueAlltimeID getId() {
        return this.id;
    }

    public BrowserReference(AbstractBrowserChallenge challenge) {
        this.resourceIds.put("style.css", BrowserReference.class.getResource("html/style.css"));
        this.resourceIds.put("plax-1.png", BrowserReference.class.getResource("html/plax-1.png"));
        this.resourceIds.put("plax-2.png", BrowserReference.class.getResource("html/plax-2.png"));
        this.resourceIds.put("plax-3.png", BrowserReference.class.getResource("html/plax-3.png"));
        this.resourceIds.put("plax-4.png", BrowserReference.class.getResource("html/plax-4.png"));
        this.resourceIds.put("plax-5.png", BrowserReference.class.getResource("html/plax-5.png"));
        this.resourceIds.put("plax-6.png", BrowserReference.class.getResource("html/plax-6.png"));
        this.resourceIds.put("script.min.js", BrowserReference.class.getResource("html/script.min.js"));
        this.resourceIds.put("teaser.png", BrowserReference.class.getResource("html/teaser.png"));
        this.resourceIds.put("body-bg.jpg", BrowserReference.class.getResource("html/body-bg.jpg"));
        this.resourceIds.put("header-bg.jpg", BrowserReference.class.getResource("html/header-bg.jpg"));
        this.resourceIds.put("logo.png", BrowserReference.class.getResource("html/logo.png"));
        this.resourceIds.put("mediumblue-bg.jpg", BrowserReference.class.getResource("html/mediumblue-bg.jpg"));
        this.resourceIds.put("social.png", BrowserReference.class.getResource("html/social.png"));
        this.resourceIds.put("twitterbird.png", BrowserReference.class.getResource("html/twitterbird.png"));
        this.resourceIds.put("fuuuu.png", BrowserReference.class.getResource("html/fuuuu.png"));
        this.resourceIds.put("favicon.ico", BrowserReference.class.getResource("html/favicon.ico"));
        this.resourceIds.put("browserCaptcha.js", BrowserReference.class.getResource("html/browserCaptcha.js"));
        this.resourceIds.put("jquery-1.9.1-min.js", BrowserReference.class.getResource("html/jquery-1.9.1-min.js"));
        this.types = new HashMap();
        this.types.put("html", "text/html; charset=utf-8");
        this.types.put("css", "text/css; charset=utf-8");
        this.types.put("png", "image/png");
        this.types.put("js", "text/javascript; charset=utf-8");
        this.types.put("jpg", "image/jpeg");
        this.types.put("ico", "image/x-icon");
        this.handlerInfo = new AtomicReference<Object>(null);
        this.canClose = new SingleReachableState("canClose");
        this.lastRequestString = null;
        this.challenge = challenge;
        this.canClose.executeWhenReached((Runnable)new DelayedRunnable(10000L){

            public void delayedrun() {
                BrowserReference.this.unregisterRequestHandler();
            }
        });
    }

    public void open() throws IOException {
        if (!this.canClose.isReached()) {
            QUEUE.addWait((QueueAction)new QueueAction<Void, IOException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void run() throws IOException {
                    AtomicReference<HttpHandlerInfo> atomicReference = BrowserReference.this.handlerInfo;
                    synchronized (atomicReference) {
                        if (BrowserReference.this.handlerInfo.get() == null) {
                            try {
                                int port = BrowserSolverService.getInstance().getConfig().getLocalHttpPort();
                                if (port < 1024) {
                                    port = 0;
                                } else if (port > 65000) {
                                    port = 65000;
                                }
                                BrowserReference.this.handlerInfo.set(DeprecatedAPIHttpServerController.getInstance().registerRequestHandler(port, true, BrowserReference.this));
                            }
                            catch (IOException e) {
                                BrowserReference.this.getLogger().log((Throwable)e);
                                BrowserReference.this.handlerInfo.set(DeprecatedAPIHttpServerController.getInstance().registerRequestHandler(0, true, BrowserReference.this));
                            }
                            BrowserSolverService.getInstance().getConfig().setLocalHttpPort(BrowserReference.this.getBasePort());
                        }
                    }
                    BrowserReference.this.openURL(URLHelper.parseLocation((URL)new URL(BrowserReference.this.getBase()), (String)("?id=" + BrowserReference.this.id.getID())));
                    return null;
                }
            });
        }
    }

    protected LogInterface getLogger() {
        LogSource logger = this.challenge.getJob().getLogger();
        if (logger == null) {
            Plugin plugin = this.challenge.getPlugin();
            if (plugin != null) {
                logger = plugin.getLogger();
            }
            if (logger != null) {
                logger = LogController.CL();
            }
        }
        return logger;
    }

    public String getServerAddress() {
        String ret;
        HttpHandlerInfo handler = this.handlerInfo.get();
        if (handler != null && (ret = handler.getHttpServer().getServerAddress()) != null) {
            return ret;
        }
        return "127.0.0.1" + this.getBasePort();
    }

    public int getBasePort() {
        HttpHandlerInfo handler = this.handlerInfo.get();
        if (handler != null) {
            return handler.getPort();
        }
        return -1;
    }

    public String getBase() {
        return "http://" + this.getServerAddress() + "/" + this.challenge.getHttpPath() + "/";
    }

    protected void openURL(final String url) {
        new Thread("openURL:" + url){
            {
                super(x0);
                this.setDaemon(true);
            }

            @Override
            public void run() {
                String[] browserCmd = BrowserSolverService.getInstance().getConfig().getBrowserCommandline();
                if (browserCmd == null || browserCmd.length == 0) {
                    browserCmd = (String[])CFG_GENERAL.BROWSER_COMMAND_LINE.getValue();
                }
                if ((browserCmd = CrossSystem.buildBrowserCommandline((String[])browserCmd, (String)url)) != null && browserCmd.length > 0) {
                    ProcessBuilder pb = ProcessBuilderFactory.create((String[])browserCmd);
                    pb.redirectErrorStream(true);
                    try {
                        pb.start();
                        return;
                    }
                    catch (IOException e) {
                        BrowserReference.this.getLogger().log((Throwable)e);
                    }
                }
                CrossSystem.openURL((String)url);
            }
        }.start();
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public void dispose() {
        this.canClose.setReached();
    }

    protected void unregisterRequestHandler() {
        QUEUE.add((QueueAction)new QueueAction<Void, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void run() throws RuntimeException {
                HttpHandlerInfo lHandlerInfo;
                AtomicReference<HttpHandlerInfo> atomicReference = BrowserReference.this.handlerInfo;
                synchronized (atomicReference) {
                    lHandlerInfo = BrowserReference.this.handlerInfo.getAndSet(null);
                }
                if (lHandlerInfo != null) {
                    DeprecatedAPIHttpServerController.getInstance().unregisterRequestHandler(lHandlerInfo);
                }
                return null;
            }
        });
    }

    public void onBeforeRequest(HttpRequest request, HttpResponse response) {
        response.setHook((HttpConnection.ConnectionHook)this);
    }

    public void onBeforeSendHeaders(HttpResponse response) {
        HttpRequest request = response.getConnection().getRequest();
        response.getResponseHeaders().add(new HTTPHeader("Access-Control-Allow-Origin", "http://" + this.getServerAddress()));
        response.getResponseHeaders().add(new HTTPHeader("X-Frame-Options", "SAMEORIGIN"));
        response.getResponseHeaders().add(new HTTPHeader("X-Xss-Protection", "1; mode=block"));
        response.getResponseHeaders().add(new HTTPHeader("X-Content-Type-Options", "nosniff"));
    }

    public void onAfterRequest(HttpRequest request, HttpResponse response, boolean handled) {
        if (!handled) {
            response.setHook(null);
        }
    }

    public void onAfterRequestException(HttpRequest request, HttpResponse response, Throwable e) {
    }

    public static int getHighestBrowserExtensionVersion() {
        return HIGHEST_BROWSER_EXTENSION_VERSION.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onGetRequest(GetRequest request, HttpResponse response) throws BasicRemoteAPIException {
        try {
            String resourceID;
            URL resource;
            String XMyjdAppkey = request.getRequestHeaders().getValue("X-Myjd-Appkey");
            String[] version = new Regex(XMyjdAppkey, "(\\d+)(\\.|$)").getColumn(0);
            if (version != null && version.length == 3) {
                int highest;
                int ver = Integer.parseInt(version[0]) * 10000;
                ver += Integer.parseInt(version[1]) * 100;
                if ((ver += Integer.parseInt(version[2])) > (highest = HIGHEST_BROWSER_EXTENSION_VERSION.get())) {
                    HIGHEST_BROWSER_EXTENSION_VERSION.compareAndSet(highest, ver);
                }
            }
            BrowserReference ver = this;
            synchronized (ver) {
                String requestString = request.getRemoteAddress() + "\r\n" + request.getRequestedURL() + "\r\n" + request.getRequestHeaders();
                if (!StringUtils.equals((String)this.lastRequestString, (String)requestString)) {
                    this.lastRequestString = requestString;
                    this.getLogger().info(requestString);
                }
            }
            HTTPHeader originHeader = request.getRequestHeaders().get("Origin");
            if ("/resource".equals(request.getRequestedPath()) && (resource = this.resourceIds.get(resourceID = new Regex(((KeyValuePair)request.getRequestedURLParameters().get((int)0)).value, "([^\\?]+)").getMatch(0))) != null) {
                response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
                response.getResponseHeaders().add(new HTTPHeader("Content-Type", this.types.get(Files.getExtension((String)resourceID))));
                System.out.println(resource);
                response.getOutputStream(true).write(IO.readURL((URL)resource));
                return true;
            }
            if (request.getRequestedPath() != null && !request.getRequestedPath().matches("^/" + Pattern.quote(this.challenge.getHttpPath()) + "/.*$")) {
                return false;
            }
            boolean custom = this.challenge.onRawGetRequest(this, request, response);
            if (custom) {
                return true;
            }
            String pDo = request.getParameterbyKey("do");
            String id = request.getParameterbyKey("id");
            String skipType = request.getParameterbyKey("skiptype");
            String useractive = request.getParameterbyKey("useractive");
            if (!StringUtils.equals((String)id, (String)Long.toString(this.id.getID()))) {
                return false;
            }
            response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SUCCESS_OK);
            response.getResponseHeaders().add(new HTTPHeader("Content-Type", "text/html; charset=utf-8"));
            if ("loaded".equals(pDo)) {
                HTTPHeader ua = request.getRequestHeaders().get("User-Agent");
                BrowserCaptchaSolverConfig config = BrowserSolverService.getInstance().getConfig();
                if (config.isAutoClickEnabled()) {
                    try {
                        int x = (int)Double.parseDouble(request.getParameterbyKey("x"));
                        int y = (int)Double.parseDouble(request.getParameterbyKey("y"));
                        int w = (int)Double.parseDouble(request.getParameterbyKey("w"));
                        int h = (int)Double.parseDouble(request.getParameterbyKey("h"));
                        int vw = (int)Double.parseDouble(request.getParameterbyKey("vw"));
                        int vh = (int)Double.parseDouble(request.getParameterbyKey("vh"));
                        Double dpi = request.getParameterbyKey("dpi") != null && !StringUtils.equalsIgnoreCase((String)request.getParameterbyKey("dpi"), (String)"undefined") ? Double.valueOf(request.getParameterbyKey("dpi")) : null;
                        BrowserWindow browserWindow = new BrowserWindow(ua == null ? null : ua.getValue(), x, y, w, h, vw, vh, dpi){

                            @Override
                            protected LogInterface getLogger() {
                                return BrowserReference.this.getLogger();
                            }
                        };
                        try {
                            int delay = Math.max(0, config.getAutoClickDelay());
                            if (delay > 0) {
                                this.getLogger().info("Delay AutoClick:" + delay);
                                Thread.sleep(delay);
                            }
                        }
                        catch (InterruptedException e) {
                            this.getLogger().log((Throwable)e);
                        }
                        if (CrossSystem.isUnix()) {
                            config.setAutoClickEnabled(false);
                            config._getStorageHandler().write();
                        }
                        try {
                            int eleft = (int)Double.parseDouble(request.getParameterbyKey("eleft"));
                            int etop = (int)Double.parseDouble(request.getParameterbyKey("etop"));
                            int ew = (int)Double.parseDouble(request.getParameterbyKey("ew"));
                            int eh = (int)Double.parseDouble(request.getParameterbyKey("eh"));
                            Rectangle elementBounds = new Rectangle(eleft, etop, ew, eh);
                            this.getLogger().info("Rectangle:" + elementBounds);
                            BrowserViewport viewport = this.challenge.getBrowserViewport(browserWindow, elementBounds);
                            if (viewport != null) {
                                viewport.onLoaded();
                            }
                        }
                        finally {
                            config.setAutoClickEnabled(true);
                        }
                    }
                    catch (Throwable e) {
                        this.getLogger().log(e);
                    }
                    response.getOutputStream(true).write("Thanks".getBytes("UTF-8"));
                }
                return true;
            }
            if ("canClose".equals(pDo)) {
                if (useractive != null) {
                    ChallengeResponseController.getInstance().keepAlivePendingChallenges(this.challenge);
                }
                SolverJob<?> job = ChallengeResponseController.getInstance().getJobByChallengeId(this.challenge.getId().getID());
                if (this.challenge.isSolved() || job == null || job.isDone() || BrowserSolver.getInstance().isJobDone(job)) {
                    response.getOutputStream(true).write("true".getBytes("UTF-8"));
                    this.canClose.setReached();
                    return true;
                }
                response.getOutputStream(true).write("false".getBytes("UTF-8"));
            } else {
                if ("skip".equals(pDo)) {
                    ChallengeResponseController challengeResponseController = ChallengeResponseController.getInstance();
                    SolverJob<?> job = challengeResponseController.getJobByChallengeId(this.challenge.getId().getID());
                    if (job != null) {
                        BrowserSolver browserSolver = BrowserSolver.getInstance();
                        Challenge<?> challenge = job.getChallenge();
                        if ("all".equals(skipType)) {
                            challengeResponseController.setSkipRequest(SkipRequest.BLOCK_ALL_CAPTCHAS, browserSolver, challenge);
                        } else if ("hoster".equals(skipType)) {
                            challengeResponseController.setSkipRequest(SkipRequest.BLOCK_HOSTER, browserSolver, challenge);
                        } else if ("package".equals(skipType)) {
                            challengeResponseController.setSkipRequest(SkipRequest.BLOCK_PACKAGE, browserSolver, challenge);
                        } else if ("single".equals(skipType)) {
                            challengeResponseController.setSkipRequest(SkipRequest.SINGLE, browserSolver, challenge);
                        }
                    }
                    response.getOutputStream(true).write("true".getBytes("UTF-8"));
                    return true;
                }
                if ("unload".equals(pDo)) {
                    response.getOutputStream(true).write("true".getBytes("UTF-8"));
                    return true;
                }
                if (pDo == null) {
                    response.getOutputStream(true).write(this.challenge.getHTML((HttpRequest)request, String.valueOf(this.id.getID())).getBytes("UTF-8"));
                } else {
                    return this.challenge.onGetRequest(this, request, response);
                }
            }
            return true;
        }
        catch (Throwable e) {
            this.getLogger().log(e);
            this.error(response, e);
            return true;
        }
    }

    private void error(HttpResponse response, Throwable e) {
        try {
            response.setResponseCode((ResponseCodeInterface)HTTPConstants.ResponseCode.SERVERERROR_INTERNAL);
            response.getResponseHeaders().add(new HTTPHeader("Content-Type", "text/html; charset=utf-8"));
            response.getOutputStream(true).write(Exceptions.getStackTrace((Throwable)e).getBytes("UTF-8"));
        }
        catch (Throwable e1) {
            throw new WTFException(e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onPostRequest(PostRequest request, HttpResponse response) throws BasicRemoteAPIException {
        BrowserReference browserReference = this;
        synchronized (browserReference) {
            String requestString = request.getRemoteAddress() + "\r\n" + request.getRequestedURL() + "\r\n" + request.getRequestHeaders();
            if (!StringUtils.equals((String)this.lastRequestString, (String)requestString)) {
                this.lastRequestString = requestString;
                this.getLogger().info(requestString);
            }
        }
        if (request.getRequestedPath() != null && !request.getRequestedPath().matches("^/" + Pattern.quote(this.challenge.getHttpPath()) + "/.*$")) {
            return false;
        }
        try {
            boolean custom = this.challenge.onRawPostRequest(this, request, response);
            if (custom) {
                return true;
            }
            String pDo = request.getParameterbyKey("do");
            String id = request.getParameterbyKey("id");
            if (!StringUtils.equals((String)id, (String)(this.id.getID() + ""))) {
                return false;
            }
            return this.challenge.onPostRequest(this, request, response);
        }
        catch (Throwable e) {
            this.getLogger().log(e);
            this.error(response, e);
            return true;
        }
    }

    public abstract void onResponse(String var1);
}

