/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.browser;

import java.awt.AWTException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jd.nutils.Colors;
import org.appwork.exceptions.WTFException;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Time;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.jdownloader.captcha.v2.solver.browser.NoBlockException;

public abstract class ScreenResource {
    protected int x = 0;
    protected final int blockSize = 100;
    protected int y = 0;
    protected int width;
    protected int height;
    protected Robot robot;
    protected double scale = 1.0;
    private volatile HashMap<Integer, HashMap<Integer, Block>> blocks = new HashMap();

    public ScreenResource(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public ScreenResource() {
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected abstract LogInterface getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getRectangleByColor(int rgb, int wmin, int hmin, double tollerance, int xstart, int ystart) {
        long start = Time.systemIndependentCurrentJVMTimeMillis();
        int xstartBlock = xstart / 100;
        int ystartBlock = ystart / 100;
        int blockRadius = 0;
        try {
            Point point = null;
            block5: while (++blockRadius * 100 <= 600) {
                Block block;
                int xblockmax = xstartBlock + blockRadius - 1;
                int yblockmax = ystartBlock + blockRadius - 1;
                boolean hasBlock = false;
                for (int xblock = xstartBlock; xblock <= xblockmax && (block = this.getBlock(xblock * 100, yblockmax * 100)) != null; ++xblock) {
                    hasBlock = true;
                    point = this.scanBlock(block, rgb, tollerance, xstart, ystart);
                    if (point != null) break block5;
                }
                for (int yblock = ystartBlock; yblock < yblockmax && (block = this.getBlock(xblockmax * 100, yblock * 100)) != null; ++yblock) {
                    hasBlock = true;
                    point = this.scanBlock(block, rgb, tollerance, xstart, ystart);
                    if (point != null) break block5;
                }
                if (hasBlock) continue;
                break;
            }
            int width = 0;
            int height = 0;
            if (point != null) {
                int col;
                double dif;
                int col2;
                double dif2;
                BufferedImage xStrip = this.getRobot().createScreenCapture(new Rectangle(this.x + point.x, this.y + point.y, this.getWidth() - point.x, 1));
                for (int x = wmin; x < xStrip.getWidth() && !((dif2 = Colors.getColorDifference((int)rgb, (int)(col2 = xStrip.getRGB(x, 0)))) > tollerance); ++x) {
                    width = x + 1;
                }
                BufferedImage yStrip = this.getRobot().createScreenCapture(new Rectangle(this.x + point.x, this.y + point.y, 1, this.getHeight() - point.y));
                for (int y = hmin; y < yStrip.getHeight() && !((dif = Colors.getColorDifference((int)rgb, (int)(col = yStrip.getRGB(0, y)))) > tollerance); ++y) {
                    height = y + 1;
                }
                Rectangle ret = new Rectangle(this.x + point.x, this.y + point.y, width, height);
                this.getLogger().info("Found Rectangle in " + (Time.systemIndependentCurrentJVMTimeMillis() - start) + "ms");
                Rectangle rectangle = ret;
                return rectangle;
            }
        }
        catch (Throwable e) {
            this.getLogger().log(e);
        }
        finally {
            this.clearBlocks();
        }
        this.getLogger().info("No Rectangle in " + (Time.systemIndependentCurrentJVMTimeMillis() - start) + "ms");
        return null;
    }

    private void clearBlocks() {
        this.blocks = new HashMap();
    }

    private Point scanBlock(Block block, int rgb, double tollerance, int xstart, int ystart) {
        try {
            int pixelRadius = 0;
            while (++pixelRadius < 100) {
                double dif;
                int pixelColor;
                int xmax = pixelRadius - 1;
                int ymax = pixelRadius - 1;
                Point px = null;
                Point py = null;
                for (int x = 0; x <= xmax; ++x) {
                    pixelColor = block.getImage().getRGB(x, ymax) & 0xFFFFFF;
                    dif = Colors.getColorDifference((int)rgb, (int)pixelColor);
                    if (!(dif < tollerance)) continue;
                    try {
                        if (!this.checkColor(rgb, tollerance, block.x + x + this.scale(1), block.y + ymax) || !this.checkColor(rgb, tollerance, block.x + x + this.scale(48), block.y + ymax) || !this.checkColor(rgb, tollerance, block.x + x, block.y + ymax + this.scale(1)) || !this.checkColor(rgb, tollerance, block.x + x, block.y + ymax + this.scale(48))) continue;
                        px = new Point(block.x + x, block.y + ymax);
                        break;
                    }
                    catch (NoBlockException noBlockException) {
                        // empty catch block
                    }
                }
                for (int y = 0; y < ymax; ++y) {
                    pixelColor = block.getImage().getRGB(xmax, y);
                    dif = Colors.getColorDifference((int)rgb, (int)pixelColor);
                    if (!(dif < tollerance)) continue;
                    try {
                        if (!this.checkColor(rgb, tollerance, block.x + xmax + this.scale(1), block.y + y) || !this.checkColor(rgb, tollerance, block.x + xmax + this.scale(48), block.y + y) || !this.checkColor(rgb, tollerance, block.x + xmax, block.y + y + this.scale(1)) || !this.checkColor(rgb, tollerance, block.x + xmax, block.y + y + this.scale(48))) continue;
                        px = new Point(block.x + xmax, block.y + y);
                        break;
                    }
                    catch (NoBlockException noBlockException) {
                        // empty catch block
                    }
                }
                if (px == null) continue;
                if (py == null) {
                    return px;
                }
                if (px.x < py.x) {
                    return px;
                }
                if (px.y < py.y) {
                    return px;
                }
                return py;
            }
        }
        catch (Throwable e) {
            this.getLogger().log(e);
        }
        return null;
    }

    protected boolean checkColor(int rgb, double tollerance, int x, int y) throws NoBlockException {
        int col = this.getRGB(x, y);
        double dif = Colors.getColorDifference((int)rgb, (int)col);
        return dif < tollerance;
    }

    protected int scale(Number i) {
        return Math.max(1, (int)(this.scale * i.doubleValue()));
    }

    private int getRGB(int x, int y) throws NoBlockException {
        Block block = this.getBlock(x, y);
        return block.getRGB(x, y);
    }

    protected void showImage(BufferedImage img, String title) {
        ConfirmDialog d = new ConfirmDialog(0, title, "", (Icon)new ImageIcon(img), null, null);
        d.setTimeout(5000);
        UIOManager.I().show(null, (UserIODefinition)d);
    }

    private Block getBlock(int x, int y) throws NoBlockException {
        Block block;
        if (x >= this.getWidth()) {
            throw new NoBlockException(x, y);
        }
        if (y >= this.getHeight()) {
            throw new NoBlockException(x, y);
        }
        x /= 100;
        y /= 100;
        y *= 100;
        HashMap<Integer, Block> column = this.blocks.get(x *= 100);
        if (column == null) {
            column = new HashMap();
            this.blocks.put(x, column);
        }
        if ((block = column.get(y)) == null) {
            block = new Block(x, y);
            column.put(y, block);
        }
        return block;
    }

    protected Robot getRobot() {
        if (this.robot == null) {
            try {
                this.robot = new Robot();
            }
            catch (AWTException e) {
                throw new WTFException((Throwable)e);
            }
        }
        return this.robot;
    }

    public class Block {
        private final int x;
        private final int y;
        private SoftReference<BufferedImage> image;

        public Block(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getHeight() {
            return this.getImage().getHeight();
        }

        public int getWidth() {
            return this.getImage().getWidth();
        }

        public String toString() {
            return "Block " + this.x + "." + this.y + " " + this.getWidth() + "x" + this.getHeight();
        }

        public int getRGB(int x2, int y2) {
            return this.getImage().getRGB(x2 - this.x, y2 - this.y);
        }

        public BufferedImage getImage() {
            if (this.image == null) {
                return this.updateImage();
            }
            BufferedImage img = this.image.get();
            if (img == null) {
                return this.updateImage();
            }
            return img;
        }

        private BufferedImage updateImage() {
            Rectangle rec = new Rectangle(ScreenResource.this.x + this.x, ScreenResource.this.y + this.y, 100, 100);
            BufferedImage img = ScreenResource.this.getRobot().createScreenCapture(rec);
            ScreenResource.this.getLogger().info("New Screenshot for:" + rec);
            if (System.getProperty("rc2debug") != null) {
                ScreenResource.this.showImage(img, rec.toString());
            }
            this.image = new SoftReference<BufferedImage>(img);
            return img;
        }
    }
}

