/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.cheapcaptcha;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import jd.gui.swing.jdgui.components.premiumbar.ServiceCollection;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanel;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanelExtender;
import jd.gui.swing.jdgui.views.settings.components.Checkbox;
import jd.gui.swing.jdgui.views.settings.components.PasswordInput;
import jd.gui.swing.jdgui.views.settings.components.SettingsButton;
import jd.gui.swing.jdgui.views.settings.components.SettingsComponent;
import jd.gui.swing.jdgui.views.settings.components.TextInput;
import jd.gui.swing.jdgui.views.settings.panels.anticaptcha.AbstractCaptchaSolverConfigPanel;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.utils.Application;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.actions.AppAction;
import org.jdownloader.captcha.v2.ChallengeSolverConfig;
import org.jdownloader.captcha.v2.solver.cheapcaptcha.CheapCaptchaConfigInterface;
import org.jdownloader.captcha.v2.solver.cheapcaptcha.CheapCaptchaSolver;
import org.jdownloader.captcha.v2.solver.cheapcaptcha.CheapCaptchaTooltip;
import org.jdownloader.captcha.v2.solver.service.AbstractSolverService;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.advanced.AdvancedConfigManager;
import org.jdownloader.settings.staticreferences.CFG_CHEAP_CAPTCHA;

public class CheapCaptchaSolverService
extends AbstractSolverService
implements ServicePanelExtender {
    private CheapCaptchaConfigInterface config = (CheapCaptchaConfigInterface)JsonConfig.create(CheapCaptchaConfigInterface.class);
    private CheapCaptchaSolver solver;
    public static final String ID = "cheapcaptcha";

    public CheapCaptchaSolverService() {
        AdvancedConfigManager.getInstance().register(this.config);
        if (!Application.isHeadless()) {
            ServicePanel.getInstance().addExtender((ServicePanelExtender)this);
            this.initServicePanel(new KeyHandler[]{CFG_CHEAP_CAPTCHA.USER_NAME, CFG_CHEAP_CAPTCHA.PASSWORD, CFG_CHEAP_CAPTCHA.ENABLED});
        }
    }

    @Override
    public String getType() {
        return _GUI.T.CaptchaSolver_Type_paid_online();
    }

    @Override
    public Icon getIcon(int size) {
        return new AbstractIcon("logo/cheapCaptcha", size);
    }

    @Override
    public AbstractCaptchaSolverConfigPanel getConfigPanel() {
        AbstractCaptchaSolverConfigPanel ret = new AbstractCaptchaSolverConfigPanel(){
            private TextInput username;
            private PasswordInput password;
            {
                this.addHeader(this.getTitle(), new AbstractIcon("logo/cheapCaptcha", 32));
                this.addDescription(_GUI.T.AntiCaptchaConfigPanel_onShow_description_paid_service());
                this.add((Component)new SettingsButton(new AppAction(){
                    {
                        this.setName(_GUI.T.lit_open_website());
                    }

                    public void actionPerformed(ActionEvent e) {
                        CrossSystem.openURL((String)"http://www.cheapCaptcha.com/");
                    }
                }), "gapleft 37,spanx,pushx,growx");
                this.username = new TextInput(CFG_CHEAP_CAPTCHA.USER_NAME);
                this.password = new PasswordInput(CFG_CHEAP_CAPTCHA.PASSWORD);
                this.addHeader(_GUI.T.MyJDownloaderSettingsPanel_MyJDownloaderSettingsPanel_logins_(), new AbstractIcon("logins", 32));
                this.addDescriptionPlain(_GUI.T.captchasolver_configpanel_my_account_description(CheapCaptchaSolverService.this.getName()));
                this.addPair(_GUI.T.captchasolver_configpanel_enabled(CheapCaptchaSolverService.this.getName()), null, (SettingsComponent)new Checkbox(CFG_CHEAP_CAPTCHA.ENABLED, new JComponent[]{this.username, this.password}));
                this.addPair(_GUI.T.captchabrotherhoodService_createPanel_username(), null, (SettingsComponent)this.username);
                this.addPair(_GUI.T.captchabrotherhoodService_createPanel_password(), null, (SettingsComponent)this.password);
                this.addPair(_GUI.T.DeatchbyCaptcha_Service_createPanel_feedback(), null, (SettingsComponent)new Checkbox(CFG_CHEAP_CAPTCHA.FEED_BACK_SENDING_ENABLED, new JComponent[0]));
                this.addBlackWhiteList(CFG_CHEAP_CAPTCHA.CFG);
            }

            public String getPanelID() {
                return "CES_" + this.getTitle();
            }

            public void save() {
            }

            public void updateContents() {
            }

            public Icon getIcon() {
                return CheapCaptchaSolverService.this.getIcon(32);
            }

            public String getTitle() {
                return "CheapCaptcha.com";
            }
        };
        return ret;
    }

    @Override
    public boolean hasConfigPanel() {
        return true;
    }

    @Override
    public String getName() {
        return _GUI.T.CheapCaptchaSolver_gettypeName_();
    }

    @Override
    public ChallengeSolverConfig getConfig() {
        return this.config;
    }

    public void extendServicePabel(List<ServiceCollection<?>> services) {
        if (this.solver.validateLogins()) {
            services.add(new ServiceCollection<CheapCaptchaSolver>(){

                public Icon getIcon() {
                    return CheapCaptchaSolverService.this.getIcon(18);
                }

                public boolean isEnabled() {
                    return CheapCaptchaSolverService.this.config.isEnabled();
                }

                protected long getLastActiveTimestamp() {
                    return System.currentTimeMillis();
                }

                protected String getName() {
                    return "CheapCaptcha.com";
                }

                public ExtTooltip createTooltip(ServicePanel owner) {
                    return new CheapCaptchaTooltip(owner, CheapCaptchaSolverService.this.solver);
                }
            });
        }
    }

    @Override
    public Map<String, Integer> getWaitForOthersDefaultMap() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put("jac", 30000);
        ret.put("dbc", 60000);
        ret.put("imagetyperz", 60000);
        ret.put("2captcha", 60000);
        ret.put("9kw", 120000);
        return ret;
    }

    @Override
    public String getID() {
        return ID;
    }

    public void setSolver(CheapCaptchaSolver solver) {
        this.solver = solver;
    }
}

