/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.dbc;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import jd.http.Browser;
import jd.http.Request;
import jd.http.requests.FormData;
import jd.http.requests.PostFormDataRequest;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.encoding.URLEncode;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.parser.UrlQuery;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.SolverStatus;
import org.jdownloader.captcha.v2.challenge.cloudflareturnstile.CloudflareTurnstileChallenge;
import org.jdownloader.captcha.v2.challenge.cutcaptcha.CutCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.hcaptcha.HCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.BasicCaptchaChallenge;
import org.jdownloader.captcha.v2.solver.CESChallengeSolver;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.captcha.v2.solver.browser.AbstractBrowserChallenge;
import org.jdownloader.captcha.v2.solver.dbc.DBCAccount;
import org.jdownloader.captcha.v2.solver.dbc.DBCGetUserResponse;
import org.jdownloader.captcha.v2.solver.dbc.DBCUploadResponse;
import org.jdownloader.captcha.v2.solver.dbc.DeathByCaptchaResponse;
import org.jdownloader.captcha.v2.solver.dbc.DeathByCaptchaSettings;
import org.jdownloader.captcha.v2.solver.dbc.DeathByCaptchaSolverService;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_CAPTCHA;
import org.jdownloader.settings.staticreferences.CFG_DBC;

public class DeathByCaptchaSolver
extends CESChallengeSolver<String> {
    private DeathByCaptchaSettings config;
    private static final DeathByCaptchaSolver INSTANCE = new DeathByCaptchaSolver();
    private ThreadPoolExecutor threadPool = new ThreadPoolExecutor(0, 1, 30000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(), Executors.defaultThreadFactory());
    private LogSource logger;
    private static final String API_BASE = "http://api.dbcapi.me/api";

    public static DeathByCaptchaSolver getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<String> getResultType() {
        return String.class;
    }

    @Override
    public DeathByCaptchaSolverService getService() {
        return (DeathByCaptchaSolverService)super.getService();
    }

    private DeathByCaptchaSolver() {
        super(new DeathByCaptchaSolverService(), Math.max(1, Math.min(25, ((DeathByCaptchaSettings)JsonConfig.create(DeathByCaptchaSettings.class)).getThreadpoolSize())));
        this.getService().setSolver(this);
        this.config = (DeathByCaptchaSettings)JsonConfig.create(DeathByCaptchaSettings.class);
        this.logger = LogController.getInstance().getLogger(DeathByCaptchaSolver.class.getName());
        this.threadPool.allowCoreThreadTimeOut(true);
    }

    @Override
    protected boolean isChallengeSupported(Challenge<?> c) {
        if (c instanceof BasicCaptchaChallenge) {
            return true;
        }
        if (c instanceof RecaptchaV2Challenge) {
            return true;
        }
        if (c instanceof CutCaptchaChallenge) {
            return true;
        }
        return c instanceof CloudflareTurnstileChallenge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void solveCES(CESSolverJob<String> job) throws InterruptedException, SolverException {
        block33: {
            Challenge<String> challenge = job.getChallenge();
            job.showBubble(this, this.getBubbleTimeout(challenge));
            DeathByCaptchaSolver.checkInterruption();
            try {
                DeathByCaptchaResponse response;
                DBCUploadResponse status;
                String type;
                block34: {
                    DBCUploadResponse uploadStatus;
                    AbstractBrowserChallenge cc;
                    challenge.sendStatsSolving(this);
                    job.setStatus(SolverStatus.UPLOADING);
                    Browser br = this.createBrowser();
                    PostFormDataRequest r = new PostFormDataRequest("http://api.dbcapi.me/api/captcha");
                    String username = this.config.getUserName();
                    String password = this.config.getPassword();
                    if (StringUtils.isEmpty((String)username)) {
                        r.addFormData(new FormData("authtoken", password));
                    } else {
                        r.addFormData(new FormData("username", username));
                        r.addFormData(new FormData("password", password));
                    }
                    if (challenge instanceof HCaptchaChallenge) {
                        type = "HCaptcha";
                        HCaptchaChallenge hc = (HCaptchaChallenge)challenge;
                        r.addFormData(new FormData("type", "7"));
                        HashMap<String, String> hcaptcha_params = new HashMap<String, String>();
                        hcaptcha_params.put("pageurl", hc.getSiteUrl());
                        hcaptcha_params.put("sitekey", hc.getSiteKey());
                        r.addFormData(new FormData("hcaptcha_params", JSonStorage.serializeToJson(hcaptcha_params)));
                    } else if (challenge instanceof RecaptchaV2Challenge) {
                        RecaptchaV2Challenge rc = (RecaptchaV2Challenge)challenge;
                        HashMap<String, Object> token_param = new HashMap<String, Object>();
                        token_param.put("googlekey", rc.getSiteKey());
                        Map<String, Object> v3action = rc.getV3Action();
                        if (v3action != null) {
                            type = "RecaptchaV3";
                            r.addFormData(new FormData("type", "5"));
                            token_param.put("action", v3action.get("action"));
                            token_param.put("pageurl", rc.getSiteUrl());
                            token_param.put("min_score", "0.3");
                        } else {
                            if (rc.isInvisible()) {
                                type = "RecaptchaV2 invisible";
                                r.addFormData(new FormData("type", "4"));
                            } else {
                                type = "RecaptchaV2";
                                r.addFormData(new FormData("type", "4"));
                            }
                            token_param.put("pageurl", rc.getSiteUrl());
                        }
                        r.addFormData(new FormData("token_params", JSonStorage.serializeToJson(token_param)));
                    } else if (challenge instanceof CutCaptchaChallenge) {
                        type = "CutCaptcha";
                        cc = (CutCaptchaChallenge)challenge;
                        r.addFormData(new FormData("type", "19"));
                        HashMap<String, String> cutcaptcha_params = new HashMap<String, String>();
                        cutcaptcha_params.put("apikey", ((CutCaptchaChallenge)cc).getApiKey());
                        cutcaptcha_params.put("miserykey", ((CutCaptchaChallenge)cc).getSiteKey());
                        cutcaptcha_params.put("pageurl", ((CutCaptchaChallenge)cc).getSiteUrl());
                        r.addFormData(new FormData("cutcaptcha_params", JSonStorage.serializeToJson(cutcaptcha_params)));
                    } else if (challenge instanceof CloudflareTurnstileChallenge) {
                        type = "CloudflareTurnstileCaptcha";
                        cc = (CloudflareTurnstileChallenge)challenge;
                        r.addFormData(new FormData("type", "12"));
                        HashMap<String, String> turnstile_params = new HashMap<String, String>();
                        turnstile_params.put("sitekey", ((CloudflareTurnstileChallenge)cc).getSiteKey());
                        turnstile_params.put("pageurl", ((CloudflareTurnstileChallenge)cc).getSiteUrl());
                        r.addFormData(new FormData("turnstile_params", JSonStorage.serializeToJson(turnstile_params)));
                    } else if (challenge instanceof BasicCaptchaChallenge) {
                        type = "Image";
                        BasicCaptchaChallenge bcc = (BasicCaptchaChallenge)challenge;
                        BufferedImage image = ImageProvider.read((File)bcc.getImageFile());
                        byte[] bytes = IconIO.toJpgBytes((Image)image);
                        r.addFormData(new FormData("swid", "0"));
                        r.addFormData(new FormData("challenge", ""));
                        r.addFormData(new FormData("captchafile", "captcha", "application/octet-stream", bytes));
                    } else {
                        type = "None";
                    }
                    br.setAllowedResponseCodes(new int[]{200, 400});
                    br.getPage((Request)r);
                    status = uploadStatus = (DBCUploadResponse)JSonStorage.restoreFromString((String)br.getRequest().getHtmlCode(), DBCUploadResponse.TYPE);
                    if (status == null || status.getCaptcha() <= 0) break block33;
                    job.setStatus(new SolverStatus(_GUI.T.DeathByCaptchaSolver_solveBasicCaptchaChallenge_solving(), NewTheme.I().getIcon("wait", 20)));
                    job.getLogger().info("CAPTCHA(" + type + ")uploaded: " + status.getCaptcha());
                    long startTime = Time.systemIndependentCurrentJVMTimeMillis();
                    do {
                        DeathByCaptchaSolver.checkInterruption();
                        Thread.sleep(1000L);
                        job.getLogger().info("deathbycaptcha.com NO answer after " + (Time.systemIndependentCurrentJVMTimeMillis() - startTime) / 1000L + "s ");
                        br.getPage("http://api.dbcapi.me/api/captcha/" + uploadStatus.getCaptcha());
                        status = (DBCUploadResponse)JSonStorage.restoreFromString((String)br.getRequest().getHtmlCode(), DBCUploadResponse.TYPE);
                        if (status.isSolved()) {
                            job.getLogger().info("Stopping because: isSolved = true");
                        } else {
                            if (status.isIs_correct()) continue;
                            job.getLogger().info("Stopping because: isCorrect = false");
                        }
                        break block34;
                    } while (Time.systemIndependentCurrentJVMTimeMillis() - startTime <= 18000000L);
                    throw new SolverException("Failed: Timeout");
                }
                if (status == null || !status.isSolved()) {
                    job.getLogger().info("Failed solving CAPTCHA(" + type + ")");
                    throw new SolverException("Failed:" + JSonStorage.serializeToJson((Object)status));
                }
                job.getLogger().info("CAPTCHA(" + type + ")uploaded: " + status.getCaptcha() + "|solved: " + status.getText());
                if (challenge instanceof HCaptchaChallenge) {
                    HCaptchaChallenge hc = (HCaptchaChallenge)challenge;
                    response = new DeathByCaptchaResponse(hc, this, status, status.getText(), 100);
                } else if (challenge instanceof RecaptchaV2Challenge) {
                    RecaptchaV2Challenge rv2c = (RecaptchaV2Challenge)challenge;
                    response = new DeathByCaptchaResponse(rv2c, this, status, status.getText(), 100);
                } else if (challenge instanceof CutCaptchaChallenge) {
                    CutCaptchaChallenge cc = (CutCaptchaChallenge)challenge;
                    response = new DeathByCaptchaResponse(cc, this, status, status.getText(), 100);
                } else if (challenge instanceof CloudflareTurnstileChallenge) {
                    CloudflareTurnstileChallenge cc = (CloudflareTurnstileChallenge)challenge;
                    response = new DeathByCaptchaResponse(cc, this, status, status.getText(), 100);
                } else {
                    BasicCaptchaChallenge bcc = (BasicCaptchaChallenge)challenge;
                    AbstractResponse<String> answer = bcc.parseAPIAnswer(status.getText().replace("[", "").replace("]", ""), null, this);
                    response = new DeathByCaptchaResponse(bcc, this, status, answer.getValue(), answer.getPriority());
                }
                job.setAnswer(response);
            }
            catch (Exception e) {
                job.setStatus(this.getErrorByException(e), new AbstractIcon("error", 20));
                job.getLogger().log((Throwable)e);
                challenge.sendStatsError(this, e);
            }
            finally {
                System.out.println("DBC DONe");
            }
        }
    }

    @Override
    protected void solveBasicCaptchaChallenge(CESSolverJob<String> job, BasicCaptchaChallenge challenge) throws InterruptedException, SolverException {
        throw new WTFException();
    }

    private int getBubbleTimeout(Challenge<?> challenge) {
        HashMap<String, Integer> map = this.config.getBubbleTimeoutByHostMap();
        Integer ret = map.get(challenge.getHost().toLowerCase(Locale.ENGLISH));
        if (ret == null || ret < 0) {
            ret = CFG_CAPTCHA.CFG.getCaptchaExchangeChanceToSkipBubbleTimeout();
        }
        return ret;
    }

    @Override
    protected boolean validateLogins() {
        if (!CFG_DBC.ENABLED.isEnabled()) {
            return false;
        }
        if (StringUtils.isAllNotEmpty((String[])new String[]{CFG_DBC.USER_NAME.getValue(), CFG_DBC.PASSWORD.getValue()})) {
            return true;
        }
        return StringUtils.isNotEmpty((String)CFG_DBC.PASSWORD.getValue());
    }

    @Override
    public boolean setUnused(AbstractResponse<?> response) {
        return false;
    }

    @Override
    public boolean setInvalid(final AbstractResponse<?> response) {
        if (!this.config.isFeedBackSendingEnabled()) {
            return false;
        }
        if (!(response instanceof DeathByCaptchaResponse)) {
            return false;
        }
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DBCUploadResponse captcha = ((DeathByCaptchaResponse)response).getCaptcha();
                    Challenge challenge = response.getChallenge();
                    if (challenge instanceof BasicCaptchaChallenge) {
                        String username = DeathByCaptchaSolver.this.config.getUserName();
                        String password = DeathByCaptchaSolver.this.config.getPassword();
                        UrlQuery query = new UrlQuery();
                        query = StringUtils.isEmpty((String)username) ? query.addAndReplace("authtoken", URLEncode.encodeRFC2396((String)password)) : query.addAndReplace("password", URLEncode.encodeRFC2396((String)password)).addAndReplace("username", URLEncode.encodeRFC2396((String)username));
                        DeathByCaptchaSolver.this.createBrowser().postPage("http://api.dbcapi.me/api/captcha/" + captcha.getCaptcha() + "/report", query);
                    }
                }
                catch (Throwable e) {
                    DeathByCaptchaSolver.this.logger.log(e);
                }
            }
        });
        return true;
    }

    public DBCAccount loadAccount() {
        DBCAccount ret = new DBCAccount();
        try {
            DBCGetUserResponse user = this.getUserData();
            ret.setBalance(user.getBalance());
            ret.setBanned(user.isIs_banned());
            ret.setId(user.getUser());
            ret.setRate(user.getRate());
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            ret.setError(this.getErrorByException(e));
        }
        return ret;
    }

    private String getErrorByException(Exception e) {
        Throwable ee;
        String ret = null;
        for (ee = e; ee != null && StringUtils.isEmpty((String)ee.getMessage()); ee = ee.getCause()) {
        }
        ret = ee != null ? ee.getMessage() : e.getMessage();
        if (StringUtils.isEmpty((String)ret)) {
            ret = _GUI.T.DBC_UNKNOWN_ERROR(e.getClass().getSimpleName());
        }
        return ret;
    }

    private DBCGetUserResponse getUserData() throws UnsupportedEncodingException, IOException {
        String username = this.config.getUserName();
        String password = this.config.getPassword();
        UrlQuery query = new UrlQuery();
        query = StringUtils.isEmpty((String)username) ? query.addAndReplace("authtoken", URLEncode.encodeRFC2396((String)password)) : query.addAndReplace("password", URLEncode.encodeRFC2396((String)password)).addAndReplace("username", URLEncode.encodeRFC2396((String)username));
        String json = this.createBrowser().postPage("http://api.dbcapi.me/api/user", query);
        if (StringUtils.containsIgnoreCase((String)json, (String)"<htm")) {
            throw new IOException("Invalid server response");
        }
        Map map = (Map)JSonStorage.restoreFromString((String)json, (TypeRef)TypeRef.MAP);
        if (((Number)map.get("status")).intValue() == 255) {
            throw new IOException(String.valueOf(map.get("error")));
        }
        return (DBCGetUserResponse)JSonStorage.restoreFromString((String)json, DBCGetUserResponse.TYPE);
    }

    private Browser createBrowser() {
        Browser br = new Browser();
        br.setLogger((LogInterface)this.logger);
        br.setDebug(true);
        br.getHeaders().put("Accept", "application/json");
        br.getHeaders().put("User-Agent", "JDownloader");
        return br;
    }
}

