/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.gui;

import jd.controlling.captcha.SkipException;
import jd.controlling.captcha.SkipRequest;
import jd.gui.swing.jdgui.JDGui;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.ChallengeResponseController;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.solver.service.DialogSolverService;
import org.jdownloader.captcha.v2.solverjob.ChallengeSolverJobListener;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.settings.staticreferences.CFG_SILENTMODE;

public abstract class AbstractDialogSolver<T>
extends ChallengeSolver<T> {
    public AbstractDialogSolver(int i) {
        super(DialogSolverService.getInstance(), i);
    }

    public void checkSilentMode(final SolverJob<T> job) throws SkipException, InterruptedException {
        if (JDGui.getInstance().isSilentModeActive()) {
            switch (CFG_SILENTMODE.CFG.getOnCaptchaDuringSilentModeAction()) {
                case WAIT_IN_BACKGROUND_UNTIL_WINDOW_GETS_FOCUS_OR_TIMEOUT: {
                    break;
                }
                case DISABLE_DIALOG_SOLVER: {
                    job.getEventSender().addListener(new ChallengeSolverJobListener(){

                        @Override
                        public void onSolverTimedOut(ChallengeSolver<?> parameter) {
                        }

                        @Override
                        public void onSolverStarts(ChallengeSolver<?> parameter) {
                        }

                        @Override
                        public void onSolverJobReceivedNewResponse(AbstractResponse<?> response) {
                        }

                        @Override
                        public void onSolverDone(ChallengeSolver<?> solver) {
                            if (job.isDone()) {
                                if (!job.isSolved()) {
                                    ChallengeResponseController.getInstance().setSkipRequest(SkipRequest.SINGLE, AbstractDialogSolver.this, job.getChallenge());
                                }
                                job.getEventSender().removeListener(this);
                            }
                        }
                    });
                    return;
                }
                case SKIP_LINK: {
                    throw new SkipException(job.getChallenge(), SkipRequest.SINGLE);
                }
            }
        }
        AbstractDialogSolver.checkInterruption();
    }
}

