/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.gui;

import jd.controlling.captcha.CaptchaSettings;
import jd.controlling.captcha.ClickCaptchaDialogHandler;
import jd.controlling.captcha.SkipException;
import org.appwork.storage.config.JsonConfig;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.challenge.clickcaptcha.ClickCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.clickcaptcha.ClickedPoint;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.ClickCaptchaResponse;
import org.jdownloader.captcha.v2.solver.gui.AbstractDialogSolver;
import org.jdownloader.captcha.v2.solver.gui.DialogBasicCaptchaSolver;
import org.jdownloader.captcha.v2.solver.gui.DialogCaptchaSolverConfig;
import org.jdownloader.captcha.v2.solver.jac.JACSolver;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.settings.advanced.AdvancedConfigManager;

public class DialogClickCaptchaSolver
extends AbstractDialogSolver<ClickedPoint> {
    private CaptchaSettings config = (CaptchaSettings)JsonConfig.create(CaptchaSettings.class);
    private ClickCaptchaDialogHandler handler;
    private static final DialogClickCaptchaSolver INSTANCE = new DialogClickCaptchaSolver();

    private DialogClickCaptchaSolver() {
        super(1);
        AdvancedConfigManager.getInstance().register(JsonConfig.create(DialogCaptchaSolverConfig.class));
    }

    public static DialogClickCaptchaSolver getInstance() {
        return INSTANCE;
    }

    @Override
    protected boolean isChallengeSupported(Challenge<?> c) {
        return c instanceof ClickCaptchaChallenge;
    }

    public void requestFocus(Challenge<?> challenge) {
        ClickCaptchaDialogHandler hndlr = this.handler;
        if (hndlr != null) {
            hndlr.requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void solve(SolverJob<ClickedPoint> solverJob) throws InterruptedException, SkipException {
        DialogBasicCaptchaSolver dialogBasicCaptchaSolver = DialogBasicCaptchaSolver.getInstance();
        synchronized (dialogBasicCaptchaSolver) {
            if (solverJob.isDone()) {
                return;
            }
            if (solverJob.getChallenge() instanceof ClickCaptchaChallenge) {
                solverJob.getLogger().info("Waiting for JAC (Click/Mouse)");
                solverJob.waitFor(9, JACSolver.getInstance());
                solverJob.getLogger().info("JAC (Click/Mouse) is done. Response so far: " + solverJob.getResponse());
                this.checkSilentMode(solverJob);
                ClickCaptchaChallenge captchaChallenge = (ClickCaptchaChallenge)solverJob.getChallenge();
                DialogClickCaptchaSolver.checkInterruption();
                this.handler = new ClickCaptchaDialogHandler(captchaChallenge);
                this.handler.run();
                ClickedPoint result = (ClickedPoint)this.handler.getResult();
                if (result != null) {
                    solverJob.addAnswer(new ClickCaptchaResponse(captchaChallenge, (Object)this, result, 100));
                }
            }
        }
    }
}

