/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.imagetyperz;

import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.requests.FormData;
import jd.http.requests.PostFormDataRequest;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.SolverStatus;
import org.jdownloader.captcha.v2.challenge.hcaptcha.HCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.BasicCaptchaChallenge;
import org.jdownloader.captcha.v2.solver.CESChallengeSolver;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.captcha.v2.solver.imagetyperz.ImageTyperzAccount;
import org.jdownloader.captcha.v2.solver.imagetyperz.ImageTyperzConfigInterface;
import org.jdownloader.captcha.v2.solver.imagetyperz.ImageTyperzResponse;
import org.jdownloader.captcha.v2.solver.imagetyperz.ImageTyperzSolverService;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_IMAGE_TYPERZ;
import org.seamless.util.io.IO;

public class ImageTyperzCaptchaSolver
extends CESChallengeSolver<String> {
    private final ImageTyperzConfigInterface config;
    private static final ImageTyperzCaptchaSolver INSTANCE = new ImageTyperzCaptchaSolver();
    private final ThreadPoolExecutor threadPool = new ThreadPoolExecutor(0, 1, 30000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(), Executors.defaultThreadFactory());
    private final LogSource logger;

    public static ImageTyperzCaptchaSolver getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<String> getResultType() {
        return String.class;
    }

    @Override
    public ImageTyperzSolverService getService() {
        return (ImageTyperzSolverService)super.getService();
    }

    private ImageTyperzCaptchaSolver() {
        super(new ImageTyperzSolverService(), Math.max(1, Math.min(25, ((ImageTyperzConfigInterface)JsonConfig.create(ImageTyperzConfigInterface.class)).getThreadpoolSize())));
        this.getService().setSolver(this);
        this.config = (ImageTyperzConfigInterface)JsonConfig.create(ImageTyperzConfigInterface.class);
        this.logger = LogController.getInstance().getLogger(ImageTyperzCaptchaSolver.class.getName());
        this.threadPool.allowCoreThreadTimeOut(true);
    }

    @Override
    protected boolean isChallengeSupported(Challenge<?> c) {
        return c instanceof RecaptchaV2Challenge || c instanceof BasicCaptchaChallenge || c instanceof HCaptchaChallenge;
    }

    @Override
    protected void solveCES(CESSolverJob<String> job) throws InterruptedException, SolverException {
        Challenge<String> challenge = job.getChallenge();
        if (challenge instanceof RecaptchaV2Challenge) {
            this.handleRecaptchaV2(job);
        } else if (challenge instanceof HCaptchaChallenge) {
            this.handleHCaptcha(job);
        } else {
            super.solveCES(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleHCaptcha(CESSolverJob<String> job) throws InterruptedException, SolverException {
        block16: {
            job.showBubble(this);
            ImageTyperzCaptchaSolver.checkInterruption();
            job.getChallenge().sendStatsSolving(this);
            URLConnectionAdapter conn = null;
            try {
                RecaptchaV2Challenge challenge = (RecaptchaV2Challenge)job.getChallenge();
                Browser br = new Browser();
                br.setReadTimeout(300000);
                job.setStatus(SolverStatus.SOLVING);
                PostFormDataRequest upload = new PostFormDataRequest("https://captchatypers.com/captchaapi/UploadHCaptchaUser.ashx");
                upload.addFormData(new FormData("action", "UPLOADCAPTCHA"));
                upload.addFormData(new FormData("username", this.config.getUserName()));
                upload.addFormData(new FormData("password", this.config.getPassword()));
                upload.addFormData(new FormData("pageurl", challenge.getSiteDomain()));
                upload.addFormData(new FormData("sitekey", challenge.getSiteKey()));
                upload.addFormData(new FormData("captchatype", "11"));
                conn = br.openRequestConnection((Request)upload);
                String response = br.loadConnection(conn).getHtmlCode();
                if (response.startsWith("ERROR: ")) {
                    throw new SolverException(response.substring("ERROR: ".length()));
                }
                String captchaID = br.getRegex("^(\\d+)$").getMatch(0);
                if (captchaID != null) {
                    PostFormDataRequest poll = new PostFormDataRequest("https://captchatypers.com/captchaapi/GetRecaptchaText.ashx");
                    poll.addFormData(new FormData("action", "GETTEXT"));
                    poll.addFormData(new FormData("username", this.config.getUserName()));
                    poll.addFormData(new FormData("password", this.config.getPassword()));
                    poll.addFormData(new FormData("captchaid", captchaID));
                    while (job.getJob().isAlive()) {
                        ImageTyperzCaptchaSolver.checkInterruption();
                        Thread.sleep(2000L);
                        response = br.getPage(poll.cloneRequest());
                        if (response.startsWith("ERROR: ")) {
                            if (StringUtils.contains((String)response, (String)"NOT_DECODED")) continue;
                            throw new SolverException(response.substring("ERROR: ".length()));
                        }
                        AbstractResponse<String> answer = challenge.parseAPIAnswer(response, "rawtoken", this);
                        job.setAnswer(new ImageTyperzResponse(challenge, this, captchaID, answer.getValue(), answer.getPriority()));
                    }
                    break block16;
                }
                job.getLogger().info("Failed solving CAPTCHA");
                throw new SolverException("Failed:" + response);
            }
            catch (Exception e) {
                job.getLogger().log((Throwable)e);
                job.getChallenge().sendStatsError(this, e);
            }
            finally {
                try {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRecaptchaV2(CESSolverJob<String> job) throws InterruptedException, SolverException {
        block18: {
            job.showBubble(this);
            ImageTyperzCaptchaSolver.checkInterruption();
            job.getChallenge().sendStatsSolving(this);
            URLConnectionAdapter conn = null;
            try {
                String action;
                RecaptchaV2Challenge challenge = (RecaptchaV2Challenge)job.getChallenge();
                Browser br = new Browser();
                br.setReadTimeout(300000);
                job.setStatus(SolverStatus.SOLVING);
                PostFormDataRequest upload = challenge.isEnterprise() ? new PostFormDataRequest("https://captchatypers.com/captchaapi/UploadRecaptchaEnt.ashx") : new PostFormDataRequest("https://captchatypers.com/captchaapi/UploadRecaptchaV1.ashx");
                upload.addFormData(new FormData("action", "UPLOADCAPTCHA"));
                upload.addFormData(new FormData("username", this.config.getUserName()));
                upload.addFormData(new FormData("password", this.config.getPassword()));
                upload.addFormData(new FormData("pageurl", challenge.getSiteDomain()));
                upload.addFormData(new FormData("googlekey", challenge.getSiteKey()));
                String enterprise_type = "v2";
                if (challenge.isInvisible()) {
                    enterprise_type = "v2";
                }
                if (challenge.getV3Action() != null && (action = (String)challenge.getV3Action().get("action")) != null) {
                    enterprise_type = "v3";
                    upload.addFormData(new FormData("captchaaction", action));
                }
                upload.addFormData(new FormData("enterprise_type", enterprise_type));
                conn = br.openRequestConnection((Request)upload);
                String response = br.loadConnection(conn).getHtmlCode();
                if (response.startsWith("ERROR: ")) {
                    throw new SolverException(response.substring("ERROR: ".length()));
                }
                String captchaID = br.getRegex("^(\\d+)$").getMatch(0);
                if (captchaID != null) {
                    PostFormDataRequest poll = new PostFormDataRequest("https://captchatypers.com/captchaapi/GetRecaptchaText.ashx");
                    poll.addFormData(new FormData("action", "GETTEXT"));
                    poll.addFormData(new FormData("username", this.config.getUserName()));
                    poll.addFormData(new FormData("password", this.config.getPassword()));
                    poll.addFormData(new FormData("captchaid", captchaID));
                    while (job.getJob().isAlive()) {
                        ImageTyperzCaptchaSolver.checkInterruption();
                        Thread.sleep(2000L);
                        response = br.getPage(poll.cloneRequest());
                        if (response.startsWith("ERROR: ")) {
                            if (StringUtils.contains((String)response, (String)"NOT_DECODED")) continue;
                            throw new SolverException(response.substring("ERROR: ".length()));
                        }
                        AbstractResponse<String> answer = challenge.parseAPIAnswer(response, "rawtoken", this);
                        job.setAnswer(new ImageTyperzResponse(challenge, this, captchaID, answer.getValue(), answer.getPriority()));
                    }
                    break block18;
                }
                job.getLogger().info("Failed solving CAPTCHA");
                throw new SolverException("Failed:" + response);
            }
            catch (Exception e) {
                job.getLogger().log((Throwable)e);
                job.getChallenge().sendStatsError(this, e);
            }
            finally {
                try {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void solveBasicCaptchaChallenge(CESSolverJob<String> job, BasicCaptchaChallenge challenge) throws InterruptedException, SolverException {
        block14: {
            job.showBubble(this);
            ImageTyperzCaptchaSolver.checkInterruption();
            job.getChallenge().sendStatsSolving(this);
            URLConnectionAdapter conn = null;
            try {
                Browser br = new Browser();
                br.setReadTimeout(300000);
                job.setStatus(SolverStatus.SOLVING);
                PostFormDataRequest r = new PostFormDataRequest("https://captchatypers.com/Forms/UploadFileAndGetTextNew.ashx");
                r.addFormData(new FormData("action", "UPLOADCAPTCHA"));
                r.addFormData(new FormData("username", this.config.getUserName()));
                r.addFormData(new FormData("password", this.config.getPassword()));
                r.addFormData(new FormData("chkCase", "0"));
                byte[] data = IO.readBytes((File)challenge.getImageFile());
                r.addFormData(new FormData("file", Base64.encodeToString((byte[])data, (boolean)false)));
                conn = br.openRequestConnection((Request)r);
                String response = br.loadConnection(conn).getHtmlCode();
                if (response.startsWith("ERROR: ")) {
                    throw new SolverException(response.substring("ERROR: ".length()));
                }
                String[] result = br.getRegex("(\\d+)\\|(.*)").getRow(0);
                if (result != null) {
                    AbstractResponse<String> answer = challenge.parseAPIAnswer(result[1], null, this);
                    job.getLogger().info("CAPTCHA " + challenge.getImageFile() + " solved: " + response);
                    job.setAnswer(new ImageTyperzResponse(challenge, this, result[0], answer.getValue(), answer.getPriority()));
                    break block14;
                }
                job.getLogger().info("Failed solving CAPTCHA");
                throw new SolverException("Failed:" + response);
            }
            catch (Exception e) {
                job.getLogger().log((Throwable)e);
                job.getChallenge().sendStatsError(this, e);
            }
            finally {
                try {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    protected boolean validateLogins() {
        if (!CFG_IMAGE_TYPERZ.ENABLED.isEnabled()) {
            return false;
        }
        if (StringUtils.isEmpty((String)CFG_IMAGE_TYPERZ.USER_NAME.getValue())) {
            return false;
        }
        return !StringUtils.isEmpty((String)CFG_IMAGE_TYPERZ.PASSWORD.getValue());
    }

    @Override
    public boolean setInvalid(final AbstractResponse<?> response) {
        if (this.config.isFeedBackSendingEnabled() && response instanceof ImageTyperzResponse) {
            this.threadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    URLConnectionAdapter conn = null;
                    try {
                        String captchaID = ((ImageTyperzResponse)response).getCaptchaID();
                        Challenge challenge = response.getChallenge();
                        if (challenge instanceof BasicCaptchaChallenge) {
                            Browser br = new Browser();
                            PostFormDataRequest r = new PostFormDataRequest("https://captchatypers.com/Forms/SetBadImage.ashx");
                            String userName = ImageTyperzCaptchaSolver.this.config.getUserName();
                            r.addFormData(new FormData("action", "SETBADIMAGE"));
                            r.addFormData(new FormData("username", userName));
                            r.addFormData(new FormData("password", ImageTyperzCaptchaSolver.this.config.getPassword()));
                            r.addFormData(new FormData("imageID", captchaID));
                            conn = br.openRequestConnection((Request)r);
                            br.loadConnection(conn);
                        }
                    }
                    catch (Throwable e) {
                        ImageTyperzCaptchaSolver.this.logger.log(e);
                    }
                    finally {
                        try {
                            if (conn != null) {
                                conn.disconnect();
                            }
                        }
                        catch (Throwable captchaID) {}
                    }
                }
            });
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageTyperzAccount loadAccount() {
        ImageTyperzAccount ret = new ImageTyperzAccount();
        URLConnectionAdapter conn = null;
        try {
            Browser br = new Browser();
            PostFormDataRequest r = new PostFormDataRequest("https://captchatypers.com/Forms/RequestBalance.ashx");
            String userName = this.config.getUserName();
            r.addFormData(new FormData("action", "REQUESTBALANCE"));
            r.addFormData(new FormData("username", userName));
            r.addFormData(new FormData("password", this.config.getPassword()));
            conn = br.openRequestConnection((Request)r);
            String response = br.loadConnection(conn).getHtmlCode();
            if (response.startsWith("ERROR: ")) {
                throw new SolverException(response.substring("Error: ".length()));
            }
            ret.setUserName(userName);
            ret.setBalance(100.0 * Double.parseDouble(response));
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            ret.setError(e.getMessage());
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (Throwable throwable) {}
        }
        return ret;
    }
}

