/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.jac;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import jd.captcha.JACMethod;
import jd.captcha.JAntiCaptcha;
import jd.captcha.LetterComperator;
import jd.captcha.pixelgrid.Captcha;
import jd.plugins.Plugin;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.BasicCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.CaptchaResponse;
import org.jdownloader.captcha.v2.solver.jac.AutoTrust;
import org.jdownloader.captcha.v2.solver.jac.JACCaptchaResponse;
import org.jdownloader.captcha.v2.solver.jac.JACSolverConfig;
import org.jdownloader.captcha.v2.solver.jac.JacSolverService;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.logging.LogController;

public class JACSolver
extends ChallengeSolver<String> {
    private static final double _0_85 = 0.85;
    private final JACSolverConfig config;
    private static final JACSolver INSTANCE = new JACSolver();
    private final HashMap<String, Integer> jacMethodTrustMap = new HashMap();
    private final HashMap<String, AutoTrust> threshold;
    private final LogSource logger;

    public static JACSolver getInstance() {
        return INSTANCE;
    }

    @Override
    public JacSolverService getService() {
        return (JacSolverService)super.getService();
    }

    private JACSolver() {
        super(new JacSolverService(), 5);
        this.config = (JACSolverConfig)JsonConfig.create(JACSolverConfig.class);
        this.logger = LogController.getInstance().getLogger(JACSolver.class.getName());
        HashMap<String, AutoTrust> threshold = this.config.getJACThreshold();
        this.threshold = threshold == null ? new HashMap() : new HashMap<String, AutoTrust>(threshold);
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            public void onShutdown(ShutdownRequest shutdownRequest) {
                JACSolver.this.config.setJACThreshold(JACSolver.this.threshold);
            }
        });
    }

    @Override
    public long getTimeout() {
        return 30000L;
    }

    @Override
    public boolean canHandle(Challenge<?> c) {
        return !c.isAccountLogin() && super.canHandle(c);
    }

    @Override
    public void enqueue(SolverJob<String> job) {
        if (this.isEnabled() && this.canHandle(job.getChallenge())) {
            super.enqueue(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void solve(SolverJob<String> job) throws InterruptedException, SolverException {
        block20: {
            try {
                int trust;
                if (!(job.getChallenge() instanceof BasicCaptchaChallenge) || !this.isEnabled()) break block20;
                BasicCaptchaChallenge captchaChallenge = (BasicCaptchaChallenge)job.getChallenge();
                String host = null;
                if (captchaChallenge.getPlugin() instanceof PluginForHost) {
                    host = ((PluginForHost)captchaChallenge.getPlugin()).getHost();
                } else if (captchaChallenge.getPlugin() instanceof PluginForDecrypt) {
                    host = ((PluginForDecrypt)captchaChallenge.getPlugin()).getHost();
                }
                String trustID = (host + "_" + captchaChallenge.getTypeID()).toLowerCase(Locale.ENGLISH);
                if (StringUtils.isEmpty((String)captchaChallenge.getTypeID())) {
                    return;
                }
                job.getLogger().info("JACSolver handles " + job);
                job.getLogger().info("JAC: enabled: " + this.config.isEnabled() + " Has Method: " + JACMethod.hasMethod((String)captchaChallenge.getTypeID()));
                if (!this.config.isEnabled() || !JACMethod.hasMethod((String)captchaChallenge.getTypeID())) {
                    return;
                }
                job.getChallenge().sendStatsSolving(this);
                JACSolver.checkInterruption();
                JAntiCaptcha jac = new JAntiCaptcha(captchaChallenge.getTypeID());
                JACSolver.checkInterruption();
                BufferedImage captchaImage = ImageProvider.read((File)captchaChallenge.getImageFile());
                JACSolver.checkInterruption();
                Captcha captcha = jac.createCaptcha((Image)captchaImage);
                JACSolver.checkInterruption();
                String captchaCode = jac.checkCaptcha(captchaChallenge.getImageFile(), captcha);
                if (StringUtils.isEmpty((String)captchaCode)) {
                    return;
                }
                if (jac.isExtern()) {
                    job.addAnswer(new CaptchaResponse(captchaChallenge, (Object)this, captchaCode, 100));
                    break block20;
                }
                LetterComperator[] lcs = captcha.getLetterComperators();
                double vp = 0.0;
                if (lcs != null) {
                    for (LetterComperator element : lcs) {
                        if (element == null) {
                            vp = 0.0;
                            break;
                        }
                        vp += element.getValityPercent();
                    }
                    vp /= (double)lcs.length;
                }
                int orgTrust = trust = 120 - (int)vp;
                HashMap<String, Integer> hashMap = this.jacMethodTrustMap;
                synchronized (hashMap) {
                    Integer trustMap = this.jacMethodTrustMap.get(trustID);
                    if (trustMap != null && trust > trustMap) {
                        trust = 100;
                    }
                    HashMap<String, AutoTrust> hashMap2 = this.threshold;
                    synchronized (hashMap2) {
                        AutoTrust trustValue = this.threshold.get(trustID);
                        if (trustValue != null && (double)trust > (double)trustValue.getValue() * 0.85) {
                            trust = 100;
                        }
                    }
                }
                job.addAnswer(new JACCaptchaResponse(captchaChallenge, this, captchaCode, trust, orgTrust));
            }
            catch (IOException e) {
                job.getChallenge().sendStatsError(this, e);
                throw new SolverException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMethodTrustThreshold(PluginForHost plugin, String method, int threshold) {
        String trustID = (plugin.getHost() + "_" + method).toLowerCase(Locale.ENGLISH);
        HashMap<String, Integer> hashMap = this.jacMethodTrustMap;
        synchronized (hashMap) {
            if (threshold < 0 || threshold > 100) {
                this.jacMethodTrustMap.remove(trustID);
            } else {
                this.jacMethodTrustMap.put(trustID, threshold);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setValid(AbstractResponse<?> response) {
        if (response.getSolver() != this) {
            return false;
        }
        if (response instanceof JACCaptchaResponse) {
            int priority = ((JACCaptchaResponse)response).getUnmodifiedTrustValue();
            Challenge<?> challenge = response.getChallenge();
            if (challenge instanceof BasicCaptchaChallenge) {
                Plugin plugin = ((BasicCaptchaChallenge)challenge).getPlugin();
                String trustID = (plugin.getHost() + "_" + challenge.getTypeID()).toLowerCase(Locale.ENGLISH);
                HashMap<String, AutoTrust> hashMap = this.threshold;
                synchronized (hashMap) {
                    AutoTrust trustValue = this.threshold.get(trustID);
                    if (trustValue == null) {
                        trustValue = new AutoTrust(priority);
                        this.threshold.put(trustID, trustValue);
                    }
                    trustValue.add(priority);
                    this.logger.info("New JAC Threshold for " + trustID + " : " + trustValue.getValue() + "(" + trustValue.getCounter() + ")");
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setInvalid(AbstractResponse<?> response) {
        if (response instanceof JACCaptchaResponse) {
            int priority = ((JACCaptchaResponse)response).getUnmodifiedTrustValue();
            Challenge<?> challenge = response.getChallenge();
            if (challenge instanceof BasicCaptchaChallenge) {
                Plugin plugin = ((BasicCaptchaChallenge)challenge).getPlugin();
                String trustID = (plugin.getHost() + "_" + challenge.getTypeID()).toLowerCase(Locale.ENGLISH);
                HashMap<String, AutoTrust> hashMap = this.threshold;
                synchronized (hashMap) {
                    AutoTrust trustValue = this.threshold.get(trustID);
                    if (trustValue != null) {
                        this.logger.info("JAC Failure for " + trustID + "; : TrustValue " + priority + "; Dynamic Trust: " + trustValue.getValue() + "(" + trustValue.getCounter() + ") Detected: " + response.getValue());
                        trustValue.add((int)((double)priority * 1.3));
                        this.logger.info("New JAC Threshold for " + trustID + " : " + trustValue.getValue() + "(" + trustValue.getCounter() + ")");
                    }
                }
            }
            return true;
        }
        return false;
    }
}

