/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.service;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jd.SecondLevelLaunch;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanel;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.Application;
import org.jdownloader.captcha.v2.ChallengeResponseController;
import org.jdownloader.captcha.v2.SolverService;

public abstract class AbstractSolverService
implements SolverService {
    private static final Object LOCK = new Object();

    @Override
    public synchronized int getWaitForByID(String solverID) {
        Map<String, Integer> map = this.getConfig().getWaitForMap();
        if (map == null) {
            map = this.getWaitForOthersDefaultMap();
        }
        if (map != null) {
            Integer obj = map.get(solverID);
            return obj == null ? 0 : Math.max(0, obj);
        }
        return 0;
    }

    @Override
    public synchronized void setWaitFor(String id, Integer waitFor) {
        Map<String, Integer> map = this.getConfig().getWaitForMap();
        if (map == null) {
            map = this.getWaitForOthersDefaultMap();
        }
        if (map != null) {
            if (waitFor == null || waitFor <= 0) {
                map.remove(id);
            } else {
                map.put(id, waitFor);
            }
            this.getConfig().setWaitForMap(map);
        }
    }

    @Override
    public synchronized Map<String, Integer> getWaitForMapCopy() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        Map<String, Integer> map = this.getConfig().getWaitForMap();
        if (map == null) {
            map = this.getWaitForOthersDefaultMap();
        }
        if (map != null) {
            ret.putAll(map);
        }
        return ret;
    }

    @Override
    public boolean isEnabled() {
        return this.getConfig().isEnabled();
    }

    @Override
    public void setEnabled(boolean b) {
        this.getConfig().setEnabled(b);
    }

    protected void initServicePanel(final KeyHandler ... handlers) {
        if (Application.isHeadless()) {
            return;
        }
        SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                for (KeyHandler k : handlers) {
                    k.getEventSender().addListener((EventListener)new GenericConfigEventListener<Object>(){

                        public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
                        }

                        public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
                            ServicePanel.getInstance().requestUpdate(true);
                        }
                    });
                }
            }
        });
    }

    public static ArrayList<SolverService> validateWaittimeQueue(SolverService start, SolverService check) {
        if (start == null || check == null) {
            return null;
        }
        return AbstractSolverService.validateWaittimeQueue(start, check, new ArrayList<SolverService>(), new HashSet<SolverService>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<SolverService> validateWaittimeQueue(SolverService start, SolverService check, ArrayList<SolverService> arrayList, HashSet<SolverService> dupe) {
        Object object = LOCK;
        synchronized (object) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            if (dupe == null) {
                dupe = new HashSet();
            }
            if (arrayList.size() == 0) {
                arrayList.add(start);
                dupe.add(start);
            }
            arrayList.add(check);
            if (!dupe.add(check)) {
                return arrayList;
            }
            for (Map.Entry<String, Integer> es : check.getWaitForMapCopy().entrySet()) {
                ArrayList<SolverService> ret;
                SolverService service = ChallengeResponseController.getInstance().getServiceByID(es.getKey());
                if (service == null || !service.isEnabled() || es.getValue() == null || es.getValue() <= 0 || (ret = AbstractSolverService.validateWaittimeQueue(start, service, new ArrayList<SolverService>(arrayList), new HashSet<SolverService>(dupe))) == null) continue;
                return ret;
            }
            return null;
        }
    }
}

