/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.service;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jd.controlling.AccountController;
import jd.gui.swing.jdgui.views.settings.panels.anticaptcha.AbstractCaptchaSolverConfigPanel;
import jd.http.Browser;
import jd.plugins.Account;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.MigPanel;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.StringUtils;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.jdownloader.captcha.v2.solver.browser.BrowserCaptchaSolverConfig;
import org.jdownloader.captcha.v2.solver.browser.CFG_BROWSER_CAPTCHA_SOLVER;
import org.jdownloader.captcha.v2.solver.service.AbstractSolverService;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.plugins.components.google.GoogleAccountConfig;
import org.jdownloader.plugins.components.google.GoogleHelper;
import org.jdownloader.plugins.config.AccountJsonConfig;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class BrowserSolverService
extends AbstractSolverService {
    public static final String ID = "browser";
    private static final BrowserSolverService INSTANCE = new BrowserSolverService();
    private static BrowserCaptchaSolverConfig config;

    public static BrowserSolverService getInstance() {
        if (config == null) {
            config = (BrowserCaptchaSolverConfig)JsonConfig.create(BrowserCaptchaSolverConfig.class);
        }
        return INSTANCE;
    }

    public boolean isOpenBrowserSupported() {
        String[] browserCommandLine = BrowserSolverService.getInstance().getConfig().getBrowserCommandline();
        if (browserCommandLine == null || browserCommandLine.length == 0) {
            browserCommandLine = (String[])CFG_GENERAL.BROWSER_COMMAND_LINE.getValue();
        }
        return CrossSystem.isOpenBrowserSupported() || CrossSystem.buildBrowserCommandline((String[])browserCommandLine, (String)"https://jdownloader.org") != null;
    }

    @Override
    public String getType() {
        return _GUI.T.BrowserSolverService_getName();
    }

    @Override
    public Icon getIcon(int size) {
        return NewTheme.I().getIcon("ocr", size);
    }

    @Override
    public String getName() {
        return _GUI.T.BrowserSolverService_gettypeName();
    }

    @Override
    public AbstractCaptchaSolverConfigPanel getConfigPanel() {
        AbstractCaptchaSolverConfigPanel ret = new AbstractCaptchaSolverConfigPanel(){
            {
                this.addHeader(this.getTitle(), BrowserSolverService.this.getIcon(32));
                this.addDescription(BrowserSolverService.this.getType());
                this.addBlackWhiteList(config);
            }

            public Icon getIcon() {
                return BrowserSolverService.this.getIcon(32);
            }

            public String getPanelID() {
                return "JAC_" + this.getTitle();
            }

            public String getTitle() {
                return BrowserSolverService.this.getName();
            }

            public void save() {
            }

            public void updateContents() {
            }
        };
        return ret;
    }

    @Override
    public boolean hasConfigPanel() {
        return true;
    }

    @Override
    public BrowserCaptchaSolverConfig getConfig() {
        return (BrowserCaptchaSolverConfig)JsonConfig.create(BrowserCaptchaSolverConfig.class);
    }

    @Override
    public Map<String, Integer> getWaitForOthersDefaultMap() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put("jac", 30000);
        ret.put("9kw", 300000);
        ret.put("dbc", 60000);
        ret.put("imagetyperz", 60000);
        ret.put("cheapcaptcha", 60000);
        ret.put("endcaptcha", 60000);
        return ret;
    }

    @Override
    public String getID() {
        return ID;
    }

    public static void fillCookies(Browser rcBr) {
        if (StringUtils.isNotEmpty((String)BrowserSolverService.getInstance().getConfig().getGoogleComCookieValueSID()) && StringUtils.isNotEmpty((String)BrowserSolverService.getInstance().getConfig().getGoogleComCookieValueHSID())) {
            rcBr.setCookie("http://google.com", "SID", BrowserSolverService.getInstance().getConfig().getGoogleComCookieValueSID());
            rcBr.setCookie("http://google.com", "HSID", BrowserSolverService.getInstance().getConfig().getGoogleComCookieValueHSID());
        } else {
            try {
                for (Account acc : AccountController.getInstance().list("recaptcha.google.com")) {
                    GoogleAccountConfig cfg;
                    if (!acc.isEnabled() || !(cfg = (GoogleAccountConfig)AccountJsonConfig.get(acc.getPlugin(), acc)).isUsageRecaptchaV1Enabled()) continue;
                    GoogleHelper helper = new GoogleHelper(rcBr);
                    helper.setLogger(rcBr.getLogger());
                    helper.setCacheEnabled(true);
                    helper.login(acc, false);
                    return;
                }
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
    }

    static {
        GenericConfigEventListener<String> cookiesTester = new GenericConfigEventListener<String>(){

            public void onConfigValueModified(KeyHandler<String> keyHandler, String newValue) {
                String sid = CFG_BROWSER_CAPTCHA_SOLVER.GOOGLE_COM_COOKIE_VALUE_SID.getValue();
                String hsid = CFG_BROWSER_CAPTCHA_SOLVER.GOOGLE_COM_COOKIE_VALUE_HSID.getValue();
                final AtomicReference niceOrg = new AtomicReference();
                final AtomicReference badOrg = new AtomicReference();
                if (StringUtils.isNotEmpty((String)sid) && StringUtils.isNotEmpty((String)hsid)) {
                    ConfirmDialog d = new ConfirmDialog(12, _GUI.T.Recaptcha_cookie_help_title(), _GUI.T.Recaptcha_cookie_help_msg(), new AbstractIcon("ocr", 32), null, _GUI.T.lit_close()){

                        protected JComponent getIconComponent() {
                            try {
                                String siteKey = "6Le-wvkSAAAAAPBMRTvw0Q4Muexq9bi0DJwx_mJ-";
                                Browser br = new Browser();
                                BrowserSolverService.fillCookies(br);
                                br.getPage("http://www.google.com/recaptcha/api/challenge?k=" + siteKey);
                                String challenge = br.getRegex("challenge.*?:.*?'(.*?)',").getMatch(0);
                                String server = br.getRegex("server.*?:.*?'(.*?)',").getMatch(0);
                                niceOrg.set(ImageIO.read(br.openGetConnection(server + "image?c=" + challenge).getInputStream()));
                                BufferedImage niceImage = IconIO.toBufferedImage((Image)((Image)niceOrg.get()));
                                br = new Browser();
                                br.getPage("http://www.google.com/recaptcha/api/challenge?k=" + siteKey);
                                challenge = br.getRegex("challenge.*?:.*?'(.*?)',").getMatch(0);
                                server = br.getRegex("server.*?:.*?'(.*?)',").getMatch(0);
                                badOrg.set(ImageIO.read(br.openGetConnection(server + "image?c=" + challenge).getInputStream()));
                                BufferedImage badImage = IconIO.toBufferedImage((Image)((Image)badOrg.get()));
                                Graphics2D niceGraphics = (Graphics2D)niceImage.getGraphics();
                                Graphics2D badGraphics = (Graphics2D)badImage.getGraphics();
                                Font font = new Font(ImageProvider.getDrawFontName(), 1, 18);
                                niceGraphics.setColor(Color.GREEN);
                                niceGraphics.setFont(font);
                                niceGraphics.drawString("Easy Captcha :-) ", 4, niceImage.getHeight() - 4);
                                badGraphics.setColor(Color.RED);
                                badGraphics.setFont(font);
                                badGraphics.drawString("Hard Captcha :\u00b4( ", 4, badImage.getHeight() - 4);
                                MigPanel ret = new MigPanel("ins 0,wrap 1", "[]", "[][]");
                                ret.add((Component)new JLabel(new ImageIcon(niceImage)));
                                ret.add((Component)new JLabel(new ImageIcon(badImage)));
                                return ret;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                return super.getIconComponent();
                            }
                        }

                        protected int getPreferredWidth() {
                            return 700;
                        }
                    };
                    d.setTimeout(120000);
                    UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)d);
                    if (niceOrg.get() == null || ((BufferedImage)niceOrg.get()).getType() == 10) {
                        return;
                    }
                } else {
                    UIOManager.I().showMessageDialog(_GUI.T.Recaptcha_cookie_help_msg_both_cookies());
                }
            }

            public void onConfigValidatorError(KeyHandler<String> keyHandler, String invalidValue, ValidationException validateException) {
            }
        };
        CFG_BROWSER_CAPTCHA_SOLVER.GOOGLE_COM_COOKIE_VALUE_HSID.getEventSender().addListener((EventListener)cookiesTester);
        CFG_BROWSER_CAPTCHA_SOLVER.GOOGLE_COM_COOKIE_VALUE_SID.getEventSender().addListener((EventListener)cookiesTester);
    }
}

