/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.solver9kw;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import org.appwork.uio.MessageDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.parser.UrlQuery;
import org.appwork.utils.swing.dialog.MessageDialogImpl;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.SolverService;
import org.jdownloader.captcha.v2.SolverStatus;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.BasicCaptchaChallenge;
import org.jdownloader.captcha.v2.solver.CESChallengeSolver;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.captcha.v2.solver.jac.SolverException;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9KWResponseInterface;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwSettings;
import org.jdownloader.captcha.v2.solver.solver9kw.NineKWAccount;
import org.jdownloader.captcha.v2.solver.solver9kw.NineKwSolverService;
import org.jdownloader.captcha.v2.solver.solver9kw.RequestOptions;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_CAPTCHA;

public abstract class AbstractCaptcha9kwSolver<T>
extends CESChallengeSolver<T> {
    private String accountStatusString;
    protected final Captcha9kwSettings config;
    AtomicInteger counter = new AtomicInteger();
    AtomicInteger counterInterrupted = new AtomicInteger();
    AtomicInteger counterNotOK = new AtomicInteger();
    AtomicInteger counterOK = new AtomicInteger();
    AtomicInteger counterSend = new AtomicInteger();
    AtomicInteger counterSendError = new AtomicInteger();
    AtomicInteger counterSolved = new AtomicInteger();
    AtomicInteger counterUnused = new AtomicInteger();
    private volatile NineKWAccount lastAccount = null;
    private String long_debuglog = "";

    public AbstractCaptcha9kwSolver() {
        super(NineKwSolverService.getInstance(), Math.max(1, Math.min(25, NineKwSolverService.getInstance().getConfig().getThreadpoolSize())));
        this.config = NineKwSolverService.getInstance().getConfig();
        this.threadPool.allowCoreThreadTimeOut(true);
    }

    protected Challenge<T> getChallenge(SolverJob<?> job) throws SolverException {
        Challenge<?> challenge = job.getChallenge();
        return challenge;
    }

    protected Challenge<T> getChallenge(CESSolverJob<?> solverJob) throws SolverException {
        return this.getChallenge(solverJob.getJob());
    }

    protected void checkForEnoughCredits() throws SolverException {
        NineKWAccount lLastAccount = this.lastAccount;
        if (lLastAccount != null && StringUtils.equals((String)this.config.getApiKey(), (String)lLastAccount.getUser()) && System.currentTimeMillis() - lLastAccount.getCreateTime() < 300000L) {
            if (lLastAccount.getCreditBalance() < 10) {
                if (this.config.getlowcredits()) {
                    this.showMessageAndQuit(_GUI.T.NinekwService_createPanel_error9kwtitle(), _GUI.T.NinekwService_createPanel_errortext_nocredits());
                }
                throw new SolverException("Not Enough Credits for Task");
            }
            if (lLastAccount.getError() != null) {
                throw new SolverException("9kw.eu: " + lLastAccount.getError());
            }
        }
    }

    public synchronized void dellong_debuglog() {
        this.long_debuglog = "";
    }

    @Override
    public String getAccountStatusString() {
        return this.accountStatusString;
    }

    protected int getBubbleTimeout(Challenge<?> challenge) {
        HashMap<String, Integer> map = this.config.getBubbleTimeoutByHostMap();
        Integer ret = map.get(challenge.getHost().toLowerCase(Locale.ENGLISH));
        if (ret == null || ret < 0) {
            ret = CFG_CAPTCHA.CFG.getCaptchaExchangeChanceToSkipBubbleTimeout();
        }
        return ret;
    }

    public synchronized String getlong_debuglog() {
        return this.long_debuglog;
    }

    @Override
    public SolverService getService() {
        return super.getService();
    }

    public String getAPIROOT() {
        if (this.config.ishttps()) {
            return "https://www.9kw.eu/";
        }
        return "http://www.9kw.eu/";
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.config.isEnabledGlobally();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NineKWAccount loadAccount() {
        NineKWAccount ret = new NineKWAccount();
        ret.setRequests(this.counter.get());
        ret.setSkipped(this.counterInterrupted.get());
        ret.setSolved(this.counterSolved.get());
        ret.setUser(this.config.getApiKey());
        try {
            Browser br = new Browser();
            br.setDebug(true);
            br.setVerbose(true);
            String result = br.getPage(this.getAPIROOT() + "index.cgi?action=usercaptchaguthaben&cbh=1&apikey=" + Encoding.urlEncode((String)this.config.getApiKey()));
            if (result.startsWith("OK-")) {
                String balance = result.substring(3);
                balance = balance.replace(".-", "");
                ret.setCreditBalance(Float.valueOf(balance).intValue());
            } else {
                ret.setError(result);
            }
        }
        catch (Exception e) {
            ret.setError(e.getMessage());
        }
        finally {
            this.accountStatusString = StringUtils.isEmpty((String)ret.getError()) ? ret.getCreditBalance() + " Credits" : ret.getError();
        }
        this.lastAccount = ret;
        return ret;
    }

    public void setdebug(CESSolverJob<T> job, String logdata) {
        if (this.config.isDebug() && logdata != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            this.setlong_debuglog('[' + dateFormat.format(new Date()) + ']' + " " + logdata);
        }
        job.getLogger().info(logdata);
    }

    public void setdebug_short(String logdata) {
        if (this.config.isDebug() && logdata != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            this.setlong_debuglog('[' + dateFormat.format(new Date()) + ']' + " " + logdata);
        }
    }

    @Override
    public boolean setInvalid(AbstractResponse<?> response) {
        if (this.config.isfeedback() && response instanceof Captcha9KWResponseInterface) {
            String captchaID = ((Captcha9KWResponseInterface)((Object)response)).getCaptcha9kwID();
            this.setFeedback(ResponseFeedback.INVALID, captchaID);
            return true;
        }
        return false;
    }

    public synchronized void setlong_debuglog(String long_debuglog) {
        this.long_debuglog = this.long_debuglog + long_debuglog + "\n";
    }

    @Override
    public boolean setUnused(AbstractResponse<?> response) {
        if (this.config.isfeedback() && response instanceof Captcha9KWResponseInterface) {
            String captchaID = ((Captcha9KWResponseInterface)((Object)response)).getCaptcha9kwID();
            this.setFeedback(ResponseFeedback.UNUSED, captchaID);
            return true;
        }
        return false;
    }

    protected void setFeedback(final ResponseFeedback feedback, final String captchaID) {
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Browser br = new Browser();
                    br.setAllowedResponseCodes(new int[]{500});
                    for (int i = 0; i <= 3; ++i) {
                        String ret = br.getPage(AbstractCaptcha9kwSolver.this.getAPIROOT() + "index.cgi?action=usercaptchacorrectback&source=jd2&correct=" + feedback.code + "&id=" + captchaID + "&apikey=" + Encoding.urlEncode((String)AbstractCaptcha9kwSolver.this.config.getApiKey()));
                        LoggerFactory.getDefaultLogger().info("\r\n" + br.getRequest());
                        if (ret.startsWith("OK")) {
                            AbstractCaptcha9kwSolver.this.setdebug_short("CaptchaID " + captchaID + ":" + feedback.name());
                            AbstractCaptcha9kwSolver.this.counterUnused.incrementAndGet();
                            break;
                        }
                        Thread.sleep(2000L);
                    }
                }
                catch (Throwable e) {
                    LogController.CL(true).log(e);
                }
            }
        });
    }

    @Override
    public boolean setValid(AbstractResponse<?> response) {
        if (this.config.isfeedback() && response instanceof Captcha9KWResponseInterface) {
            String captchaID = ((Captcha9KWResponseInterface)((Object)response)).getCaptcha9kwID();
            this.setFeedback(ResponseFeedback.VALID, captchaID);
            return true;
        }
        return false;
    }

    protected void showMessageAndQuit(String title, String msg) throws SolverException {
        MessageDialogImpl d = new MessageDialogImpl(0, title, msg, (Icon)new AbstractIcon("logo/9kw", 32), null);
        UIOManager.I().show(MessageDialogInterface.class, (UserIODefinition)d);
        throw new SolverException(title);
    }

    protected UrlQuery createQueryForPolling() {
        UrlQuery queryPoll = new UrlQuery().appendEncoded("action", "usercaptchacorrectdata");
        queryPoll.appendEncoded("jd", "2");
        queryPoll.appendEncoded("source", "jd2");
        queryPoll.appendEncoded("apikey", this.config.getApiKey());
        queryPoll.appendEncoded("version", "1.1");
        return queryPoll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poll(Browser br, RequestOptions options, CESSolverJob<T> solverJob, String captchaID, UrlQuery queryPoll) throws InterruptedException, IOException, SolverException {
        long startTime = System.currentTimeMillis();
        boolean setUnused = true;
        try {
            Thread.sleep(10000L);
            Challenge<T> captchaChallenge = this.getChallenge(solverJob);
            queryPoll.appendEncoded("id", captchaID);
            while (solverJob.getJob().isAlive() && !solverJob.getJob().isSolved()) {
                String ret = br.getPage(this.getAPIROOT() + "index.cgi?" + queryPoll.toString());
                if (StringUtils.isEmpty((String)ret) || ret == "No htmlCode read") {
                    this.setdebug(solverJob, "CaptchaID " + captchaID + " - NO answer after " + (System.currentTimeMillis() - startTime) / 1000L + "s ");
                } else {
                    this.setdebug(solverJob, "CaptchaID " + captchaID + " - Answer after " + (System.currentTimeMillis() - startTime) / 1000L + "s: " + ret);
                }
                if (ret.startsWith("OK-answered-ERROR NO USER") || ret.startsWith("ERROR NO USER")) {
                    this.counterInterrupted.incrementAndGet();
                    Thread.sleep(15000L);
                    return;
                }
                if (ret.startsWith("OK-answered-")) {
                    this.counterSolved.incrementAndGet();
                    String antwort = ret.substring("OK-answered-".length());
                    this.parseResponse(solverJob, captchaChallenge, captchaID, antwort);
                    setUnused = false;
                    return;
                }
                if ((System.currentTimeMillis() - startTime) / 1000L > (long)(options.getTimeoutthing() + 10)) {
                    this.counterInterrupted.incrementAndGet();
                    return;
                }
                if (ret.matches("\\d\\d\\d\\d .*")) {
                    // empty if block
                }
                AbstractCaptcha9kwSolver.checkInterruption();
                Thread.sleep(2000L);
            }
        }
        finally {
            if (setUnused) {
                this.setFeedback(ResponseFeedback.UNUSED, captchaID);
            }
        }
    }

    protected abstract void parseResponse(CESSolverJob<T> var1, Challenge<T> var2, String var3, String var4) throws IOException;

    protected String upload(Browser br, CESSolverJob<T> solverJob, UrlQuery qi) throws InterruptedException, IOException, SolverException {
        String ret = "";
        Challenge<T> captchaChallenge = this.getChallenge(solverJob);
        this.setdebug(solverJob, "Upload Captcha - GetTypeID: " + captchaChallenge.getTypeID() + " - Plugin: " + captchaChallenge.getPlugin());
        solverJob.showBubble(this, this.getBubbleTimeout(captchaChallenge));
        this.counter.incrementAndGet();
        solverJob.setStatus(SolverStatus.UPLOADING);
        captchaChallenge.sendStatsSolving(this);
        for (int i = 0; i <= 5; ++i) {
            ret = br.postPage(this.getAPIROOT() + "index.cgi", qi);
            if (ret.startsWith("OK-")) {
                this.counterSend.incrementAndGet();
                break;
            }
            this.setdebug(solverJob, "Upload Captcha(" + i + ") - GetTypeID: " + captchaChallenge.getTypeID() + " - Plugin: " + captchaChallenge.getPlugin());
            if (ret.contains("0015 Captcha zu schnell eingereicht")) {
                Thread.sleep(15000L);
                continue;
            }
            if (ret.contains("0009 Kein Bild gefunden") || ret.contains("0008 Kein Captcha gefunden") || ret.matches("0010 .*")) break;
            Thread.sleep(5000L);
        }
        solverJob.setStatus(SolverStatus.SOLVING);
        if (!ret.startsWith("OK-")) {
            this.setdebug(solverJob, "Errormessage - " + ret);
            if (ret.contains("0011 Guthaben ist nicht ausreichend") && this.config.getlowcredits()) {
                this.showMessageAndQuit(_GUI.T.NinekwService_createPanel_error9kwtitle(), _GUI.T.NinekwService_createPanel_errortext_nocredits() + "\n" + ret);
            } else if (ret.contains("0008 Kein Captcha gefunden") || ret.contains("0009 Kein Bild gefunden") || ret.matches("0010 .*")) {
                this.showMessageAndQuit(_GUI.T.NinekwService_createPanel_error9kwtitle(), _GUI.T.NinekwService_createPanel_errortext_nocaptcha() + "\n" + ret);
            } else if (ret.contains("0015 Captcha zu schnell eingereicht")) {
                Thread.sleep(15000L);
            }
            this.counterSendError.incrementAndGet();
            throw new SolverException(ret);
        }
        this.setdebug(solverJob, "Send Captcha - Answer: " + ret);
        return ret.substring(3);
    }

    protected UrlQuery createQueryForUpload(CESSolverJob<T> job, RequestOptions options, byte[] data) throws SolverException {
        UrlQuery qi = new UrlQuery();
        qi.appendEncoded("action", "usercaptchaupload");
        qi.appendEncoded("jd", "2");
        qi.appendEncoded("source", "jd2");
        qi.appendEncoded("captchaperhour", options.getCph() + "");
        qi.appendEncoded("captchapermin", options.getCpm() + "");
        qi.appendEncoded("prio", options.getPriothing() + "");
        qi.appendEncoded("selfsolve", options.isSelfsolve() + "");
        qi.appendEncoded("confirm", options.isConfirm() + "");
        qi.appendEncoded("maxtimeout", options.getTimeoutthing() + "");
        qi.addAll(options.getMoreoptions().list());
        qi.appendEncoded("oldsource", this.getChallenge(job).getTypeID() + "");
        qi.appendEncoded("apikey", this.config.getApiKey() + "");
        qi.appendEncoded("captchaSource", "jdPlugin");
        qi.appendEncoded("version", "1.2");
        qi.appendEncoded("base64", "1");
        if (data != null) {
            qi.appendEncoded("file-upload-01", Base64.encodeToString((byte[])data, (boolean)false));
        }
        return qi;
    }

    protected RequestOptions prepare(CESSolverJob<T> solverJob) throws SolverException, InterruptedException {
        boolean check_highqueue;
        String hosterOptions;
        RequestOptions options = new RequestOptions(this.config);
        Challenge<T> captchaChallenge = this.getChallenge(solverJob);
        this.validateApiKey(solverJob);
        this.setdebug(solverJob, "Config - Prio: " + options.getPriothing() + " - Timeout: " + options.getTimeoutthing() + "s - Parallel: " + this.config.getThreadpoolSize());
        this.setdebug(solverJob, "Start Captcha - GetTypeID: " + captchaChallenge.getTypeID() + " - Plugin: " + captchaChallenge.getPlugin());
        if (this.config.getwhitelistcheck() && this.config.getwhitelist() != null && this.config.getwhitelist().length() > 5) {
            if (this.config.getwhitelist().contains(captchaChallenge.getTypeID())) {
                this.setdebug(solverJob, "Hoster on whitelist - " + captchaChallenge.getTypeID());
            } else {
                this.setdebug(solverJob, "Hoster not on whitelist - " + captchaChallenge.getTypeID());
                Thread.sleep(2000L);
                throw new SolverException("Hoster is NOT on whitelist");
            }
        }
        if (this.config.getblacklistcheck() && this.config.getblacklist() != null && this.config.getblacklist().length() > 5) {
            if (this.config.getblacklist().contains(captchaChallenge.getTypeID())) {
                this.setdebug(solverJob, "Hoster on blacklist - " + captchaChallenge.getTypeID());
                Thread.sleep(2000L);
                throw new SolverException("Hoster is on blacklist");
            }
            this.setdebug(solverJob, "Hoster not on blacklist - " + captchaChallenge.getTypeID());
        }
        if (this.config.getwhitelistprio() != null && this.config.getwhitelistprio().length() > 5) {
            if (this.config.getwhitelistprio().contains(captchaChallenge.getTypeID())) {
                this.setdebug(solverJob, "Hoster on whitelist with prio - " + captchaChallenge.getTypeID());
            } else {
                this.setdebug(solverJob, "Hoster not on whitelist with prio - " + captchaChallenge.getTypeID());
                options.setPriothing(0);
            }
        }
        if (this.config.getblacklistprio() != null && this.config.getblacklistprio().length() > 5) {
            if (this.config.getblacklistprio().contains(captchaChallenge.getTypeID())) {
                options.setPriothing(0);
                this.setdebug(solverJob, "Hoster on blacklist with prio - " + captchaChallenge.getTypeID());
            } else {
                this.setdebug(solverJob, "Hoster not on blacklist with prio - " + captchaChallenge.getTypeID());
            }
        }
        if ((hosterOptions = this.config.gethosteroptions()) != null && hosterOptions.length() > 5) {
            String[] list;
            for (String hosterline : list = hosterOptions.split(";")) {
                String[] listdetail;
                if (!hosterline.contains(captchaChallenge.getTypeID())) continue;
                for (String hosterlinedetail : listdetail = hosterline.split(":")) {
                    if (listdetail[0].equals(hosterlinedetail)) continue;
                    String[] detailvalue = hosterlinedetail.split("=");
                    if (detailvalue[0].equals("timeout") && detailvalue[1].matches("^[0-9]+$")) {
                        options.setTimeoutthing(Integer.parseInt(detailvalue[1]));
                    }
                    if (detailvalue[0].equals("prio") && detailvalue[1].matches("^[0-9]+$")) {
                        options.setPriothing(Integer.parseInt(detailvalue[1]));
                    }
                    if (detailvalue[0].equals("cph") && detailvalue[1].matches("^[0-9]+$")) {
                        options.setCph(Integer.parseInt(detailvalue[1]));
                    }
                    if (detailvalue[0].equals("cpm") && detailvalue[1].matches("^[0-9]+$")) {
                        options.setCpm(Integer.parseInt(detailvalue[1]));
                    }
                    if (detailvalue[0].equals("nomd5") && detailvalue[1].matches("^[0-9]+$")) {
                        options.getMoreoptions().appendEncoded("nomd5", detailvalue[1]);
                    }
                    if (detailvalue[0].equals("ocr") && detailvalue[1].matches("^[0-9]+$")) {
                        options.getMoreoptions().appendEncoded("ocr", detailvalue[1]);
                    }
                    if (detailvalue[0].equals("nospace") && detailvalue[1].matches("^[0-9]+$")) {
                        options.getMoreoptions().appendEncoded("nospace", detailvalue[1]);
                    }
                    if (detailvalue[0].equals("min") && detailvalue[1].matches("^[0-9]+$") || detailvalue[0].equals("min_length") && detailvalue[1].matches("^[0-9]+$")) {
                        options.getMoreoptions().appendEncoded("min_len", detailvalue[1]);
                    }
                    if (detailvalue[0].equals("max") && detailvalue[1].matches("^[0-9]+$") || detailvalue[0].equals("max_length") && detailvalue[1].matches("^[0-9]+$")) {
                        options.getMoreoptions().appendEncoded("max_len", detailvalue[1]);
                    }
                    if (detailvalue[0].equals("phrase") && detailvalue[1].matches("^[0-9]+$")) {
                        options.getMoreoptions().appendEncoded("phrase", detailvalue[1]);
                    }
                    if (detailvalue[0].equals("math") && detailvalue[1].matches("^[0-9]+$")) {
                        options.getMoreoptions().appendEncoded("math", detailvalue[1]);
                    }
                    if (detailvalue[0].equals("proxy")) {
                        options.getMoreoptions().appendEncoded("proxy", detailvalue[1]);
                    }
                    if (detailvalue[0].equals("proxytype")) {
                        options.getMoreoptions().appendEncoded("proxytype", detailvalue[1]);
                    }
                    if (detailvalue[0].equals("numeric") && detailvalue[1].matches("^[0-9]+$")) {
                        options.getMoreoptions().appendEncoded("numeric", detailvalue[1]);
                    }
                    if (detailvalue[0].equals("case-sensitive") && detailvalue[1].matches("^[0-9]+$")) {
                        options.getMoreoptions().appendEncoded("case-sensitive", detailvalue[1]);
                    }
                    if (detailvalue[0].equals("confirm") && detailvalue[1].matches("^[0-9]+$")) {
                        options.setConfirm(detailvalue[1].equals("1"));
                        options.getMoreoptions().appendEncoded("userconfirm", "1");
                    }
                    if (!detailvalue[0].equals("selfsolve") || !detailvalue[1].matches("^[0-9]+$")) continue;
                    options.setSelfsolve(detailvalue[1].equals("1"));
                }
            }
        }
        if (check_highqueue = this.config.gethighqueue()) {
            String servercheck = "";
            try {
                Browser br_short = new Browser();
                servercheck = br_short.getPage(NineKwSolverService.getInstance().getAPIROOT() + "grafik/servercheck.txt");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (Integer.parseInt(new Regex(servercheck, "queue=(\\d+)").getMatch(0)) > 100) {
                this.showMessageAndQuit(_GUI.T.NinekwService_createPanel_error9kwtitle(), _GUI.T.NinekwService_createPanel_notification_highqueue_errortext());
            }
        }
        return options;
    }

    @Override
    protected void solveBasicCaptchaChallenge(CESSolverJob<T> job, BasicCaptchaChallenge challenge) throws SolverException {
    }

    protected void validateApiKey(CESSolverJob<T> job) throws SolverException {
        if (!this.config.getApiKey().matches("^[a-zA-Z0-9]+$")) {
            this.setdebug(job, "API Key is not correct! (Text)");
            this.showMessageAndQuit(_GUI.T.NinekwService_createPanel_error9kwtitle(), _GUI.T.NinekwService_createPanel_errortext_wrongapikey1() + "\n" + _GUI.T.NinekwService_createPanel_errortext_wrongapikey2());
        }
    }

    @Override
    protected boolean validateLogins() {
        return StringUtils.isNotEmpty((String)this.config.getApiKey()) && this.isEnabled();
    }

    protected static enum ResponseFeedback {
        UNUSED(3),
        VALID(1),
        INVALID(2);

        protected final int code;

        private ResponseFeedback(int code) {
            this.code = code;
        }
    }
}

