/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.solver9kw;

import java.util.HashMap;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultJsonObject;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.captcha.v2.ChallengeSolverConfig;

public interface Captcha9kwSettings
extends ChallengeSolverConfig {
    @AboutConfig
    @DefaultStringValue(value="")
    @DescriptionForConfigEntry(value="Your (User) ApiKey from 9kw.eu")
    public String getApiKey();

    public void setApiKey(String var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Activate the debugmode for 9kw.eu service")
    public boolean isDebug();

    public void setDebug(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Activate the Mouse Captchas")
    public boolean ismouse();

    public void setmouse(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Activate the 9kw.eu plugin in JDownloader")
    public boolean isEnabledGlobally();

    public void setEnabledGlobally(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Activate the Puzzle Captchas")
    public boolean ispuzzle();

    public void setpuzzle(boolean var1);

    @AboutConfig
    @DefaultStringValue(value="")
    @DescriptionForConfigEntry(value="Hosteroptions for 9kw.eu")
    public String gethosteroptions();

    public void sethosteroptions(String var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Confirm option for captchas (Cost +6)")
    public boolean isconfirm();

    public void setconfirm(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Confirm option for mouse captchas (Cost +6)")
    public boolean ismouseconfirm();

    public void setmouseconfirm(boolean var1);

    @AboutConfig
    @DefaultIntValue(value=0)
    @SpinnerValidator(min=0L, max=20L)
    @DescriptionForConfigEntry(value="More priority for captchas (Cost +1-20)")
    public int getprio();

    public void setprio(int var1);

    @AboutConfig
    @DefaultStringValue(value="")
    @DescriptionForConfigEntry(value="Captcha whitelist for hoster with prio")
    public String getwhitelistprio();

    public void setwhitelistprio(String var1);

    @AboutConfig
    @DefaultStringValue(value="")
    @DescriptionForConfigEntry(value="Captcha blacklist for hoster with prio")
    public String getblacklistprio();

    public void setblacklistprio(String var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Activate the blacklist with prio")
    public boolean getblacklistpriocheck();

    public void setblacklistpriocheck(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Activate the whitelist with prio")
    public boolean getwhitelistpriocheck();

    public void setwhitelistpriocheck(boolean var1);

    @AboutConfig
    @DefaultIntValue(value=0)
    @SpinnerValidator(min=0L, max=9999L)
    @DescriptionForConfigEntry(value="Max. Captchas per hour")
    public int gethour();

    public void sethour(int var1);

    @AboutConfig
    @DefaultIntValue(value=0)
    @SpinnerValidator(min=0L, max=9999L)
    @DescriptionForConfigEntry(value="Max. Captchas per minute")
    public int getminute();

    public void setminute(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Only https requests to 9kw.eu")
    public boolean ishttps();

    public void sethttps(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Only site domain in interactive captcha (e.g. RCv2) requests to 9kw.eu")
    public boolean isSiteDomain();

    public void setSiteDomain(boolean var1);

    @AboutConfig
    @DefaultStringValue(value="")
    @DescriptionForConfigEntry(value="Captcha whitelist for hoster")
    public String getwhitelist();

    public void setwhitelist(String var1);

    @AboutConfig
    @DefaultStringValue(value="")
    @DescriptionForConfigEntry(value="Captcha blacklist for hoster")
    public String getblacklist();

    public void setblacklist(String var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Activate the blacklist")
    public boolean getblacklistcheck();

    public void setblacklistcheck(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Activate the whitelist")
    public boolean getwhitelistcheck();

    public void setwhitelistcheck(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Activate the Captcha Feedback")
    public boolean isfeedback();

    public void setfeedback(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Activate the option selfsolve (sandbox)")
    public boolean isSelfsolve();

    public void setSelfsolve(boolean var1);

    @AboutConfig
    @RequiresRestart(value="A JDownloader Restart is required after changes")
    @DefaultIntValue(value=1)
    @SpinnerValidator(min=0L, max=20L)
    @DescriptionForConfigEntry(value="Max. Captchas Parallel")
    public int getThreadpoolSize();

    public void setThreadpoolSize(int var1);

    @AboutConfig
    @DefaultStringValue(value="")
    @DescriptionForConfigEntry(value="Captcha whitelist for hoster with timeout")
    public String getwhitelisttimeout();

    public void setwhitelisttimeout(String var1);

    @AboutConfig
    @DefaultStringValue(value="")
    @DescriptionForConfigEntry(value="Captcha blacklist for hoster with timeout")
    public String getblacklisttimeout();

    public void setblacklisttimeout(String var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Activate the blacklist with timeout")
    public boolean getblacklisttimeoutcheck();

    public void setblacklisttimeoutcheck(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Activate the whitelist with timeout")
    public boolean getwhitelisttimeoutcheck();

    public void setwhitelisttimeoutcheck(boolean var1);

    @AboutConfig
    @DefaultStringValue(value="")
    @DescriptionForConfigEntry(value="Proxy like host:port (max. 200 chars)")
    public String getproxyhostport();

    public void setproxyhostport(String var1);

    @AboutConfig
    @DefaultStringValue(value="")
    @DescriptionForConfigEntry(value="Proxytype like http or socks5")
    public String getproxytype();

    public void setproxytype(String var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Activate the lowcredits dialog")
    public boolean getlowcredits();

    public void setlowcredits(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Activate the high queue dialog")
    public boolean gethighqueue();

    public void sethighqueue(boolean var1);

    @AboutConfig
    @DefaultIntValue(value=600000)
    @SpinnerValidator(min=75000L, max=3999000L)
    @DescriptionForConfigEntry(value="Default max. Timeout in ms")
    public int getDefaultMaxTimeout();

    public void setDefaultMaxTimeout(int var1);

    @AboutConfig
    @DefaultJsonObject(value="{\"jdownloader.org\":60000}")
    @DescriptionForConfigEntry(value="Host bound Waittime before using CES. Use CaptchaExchangeChanceToSkipBubbleTimeout for a global timeout")
    public HashMap<String, Integer> getBubbleTimeoutByHostMap();

    public void setBubbleTimeoutByHostMap(HashMap<String, Integer> var1);

    @Override
    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isEnabled();
}

