/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solver.twocaptcha;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import jd.gui.swing.jdgui.components.premiumbar.ServiceCollection;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanel;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanelExtender;
import jd.gui.swing.jdgui.views.settings.panels.anticaptcha.AbstractCaptchaSolverConfigPanel;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.utils.Application;
import org.jdownloader.captcha.v2.ChallengeSolverConfig;
import org.jdownloader.captcha.v2.solver.service.AbstractSolverService;
import org.jdownloader.captcha.v2.solver.twocaptcha.TwoCaptchaConfigInterface;
import org.jdownloader.captcha.v2.solver.twocaptcha.TwoCaptchaConfigPanel;
import org.jdownloader.captcha.v2.solver.twocaptcha.TwoCaptchaSolver;
import org.jdownloader.captcha.v2.solver.twocaptcha.TwoCaptchaTooltip;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.advanced.AdvancedConfigManager;
import org.jdownloader.settings.staticreferences.CFG_TWO_CAPTCHA;

public class TwoCaptchaSolverService
extends AbstractSolverService
implements ServicePanelExtender {
    private TwoCaptchaConfigInterface config = (TwoCaptchaConfigInterface)JsonConfig.create(TwoCaptchaConfigInterface.class);
    private TwoCaptchaSolver solver;
    public static final String ID = "2captcha";

    public TwoCaptchaSolverService() {
        AdvancedConfigManager.getInstance().register(this.config);
        if (!Application.isHeadless()) {
            ServicePanel.getInstance().addExtender((ServicePanelExtender)this);
            this.initServicePanel(new KeyHandler[]{CFG_TWO_CAPTCHA.API_KEY, CFG_TWO_CAPTCHA.ENABLED});
        }
    }

    @Override
    public String getType() {
        return _GUI.T.TwoCaptcha_getName_();
    }

    @Override
    public Icon getIcon(int size) {
        return new AbstractIcon("logo/2captcha", size);
    }

    @Override
    public AbstractCaptchaSolverConfigPanel getConfigPanel() {
        return new TwoCaptchaConfigPanel(this);
    }

    @Override
    public boolean hasConfigPanel() {
        return true;
    }

    @Override
    public String getName() {
        return "2captcha.com / rucaptcha.com";
    }

    @Override
    public ChallengeSolverConfig getConfig() {
        return this.config;
    }

    public void extendServicePabel(List<ServiceCollection<?>> services) {
        if (!this.solver.validateLogins()) {
            return;
        }
        services.add(new ServiceCollection<TwoCaptchaSolver>(){
            private static final long serialVersionUID = -2069081821971909269L;

            public Icon getIcon() {
                return TwoCaptchaSolverService.this.getIcon(18);
            }

            public boolean isEnabled() {
                return TwoCaptchaSolverService.this.config.isEnabled();
            }

            protected long getLastActiveTimestamp() {
                return System.currentTimeMillis();
            }

            protected String getName() {
                return "2Captcha.com";
            }

            public ExtTooltip createTooltip(ServicePanel owner) {
                return new TwoCaptchaTooltip(owner, TwoCaptchaSolverService.this.solver);
            }
        });
    }

    @Override
    public Map<String, Integer> getWaitForOthersDefaultMap() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put("jac", 30000);
        ret.put("9kw", 120000);
        return ret;
    }

    @Override
    public String getID() {
        return ID;
    }

    public void setSolver(TwoCaptchaSolver solver) {
        this.solver = solver;
    }
}

