/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.captcha.v2.solverjob;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import jd.controlling.captcha.CaptchaSettings;
import jd.controlling.captcha.SkipRequest;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Time;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeResponseController;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.ValidationResult;
import org.jdownloader.captcha.v2.solverjob.ChallengeSolverJobEvent;
import org.jdownloader.captcha.v2.solverjob.ChallengeSolverJobEventSender;
import org.jdownloader.captcha.v2.solverjob.ResponseList;

public class SolverJob<T> {
    private final Challenge<T> challenge;
    private final CaptchaSettings config;
    private final ChallengeResponseController controller;
    private volatile ArrayList<ResponseList<T>> cumulatedList;
    private final HashSet<ChallengeSolver<T>> doneList = new HashSet();
    private final AtomicReference<ChallengeSolverJobEventSender> eventSender = new AtomicReference();
    private final List<AbstractResponse<T>> responses = new ArrayList<AbstractResponse<T>>();
    private final CopyOnWriteArraySet<ChallengeSolver<T>> solverList;
    private LogSource logger;
    private volatile SkipRequest skipRequest;
    private final AtomicInteger LOCK = new AtomicInteger();
    private final AtomicBoolean alive = new AtomicBoolean(true);
    private long created;

    public String toString() {
        return "CaptchaJob: " + new Date(this.created) + " " + this.challenge + " Solver: " + this.solverList;
    }

    public SolverJob(ChallengeResponseController controller, Challenge<T> c, List<ChallengeSolver<T>> solver) {
        this.challenge = c;
        this.created = System.currentTimeMillis();
        this.controller = controller;
        this.solverList = new CopyOnWriteArraySet<ChallengeSolver<T>>(solver);
        this.config = (CaptchaSettings)JsonConfig.create(CaptchaSettings.class);
    }

    protected void log(String txt) {
        LogSource lLogger = this.getLogger();
        if (lLogger != null) {
            lLogger.info(txt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAnswer(AbstractResponse<T> abstractResponse) {
        boolean isAlive;
        if (!abstractResponse.getChallenge().validateResponse(abstractResponse)) {
            abstractResponse.setValidation(ValidationResult.INVALID);
            return false;
        }
        boolean kill = false;
        AtomicInteger atomicInteger = this.LOCK;
        synchronized (atomicInteger) {
            isAlive = this.alive.get();
            if (isAlive) {
                this.responses.add(abstractResponse);
                this.challenge.setResult(this.cumulate());
                if (this.isSolved()) {
                    this.alive.set(false);
                    this.log("Is Solved - kill rest");
                    kill = true;
                }
            }
        }
        if (kill) {
            this.kill();
        }
        if (isAlive) {
            this.fireNewAnswerEvent(abstractResponse);
            return true;
        }
        abstractResponse.setValidation(ValidationResult.UNUSED);
        return false;
    }

    public ArrayList<ResponseList<T>> getResponses() {
        return this.cumulatedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseList<T> getResponseAndKill() {
        AtomicInteger atomicInteger = this.LOCK;
        synchronized (atomicInteger) {
            this.alive.set(false);
            ArrayList<ResponseList<T>> lst = this.cumulatedList;
            if (lst == null || lst.size() == 0) {
                return null;
            }
            return lst.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseList<T> getResponse() {
        AtomicInteger atomicInteger = this.LOCK;
        synchronized (atomicInteger) {
            ArrayList<ResponseList<T>> lst = this.cumulatedList;
            if (lst == null || lst.size() == 0) {
                return null;
            }
            return lst.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areDone(ChallengeSolver<?> ... instances) {
        AtomicInteger atomicInteger = this.LOCK;
        synchronized (atomicInteger) {
            for (ChallengeSolver<?> cs : instances) {
                if (!this.solverList.contains(cs) || this.doneList.contains(cs)) continue;
                return false;
            }
            this.log("All: " + this.solverList);
            this.log("Done: " + this.doneList);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseList<T> cumulate() {
        HashMap<T, ResponseList<T>> map = new HashMap<T, ResponseList<T>>();
        ArrayList<ResponseList<T>> list = new ArrayList<ResponseList<T>>();
        AtomicInteger atomicInteger = this.LOCK;
        synchronized (atomicInteger) {
            for (AbstractResponse<T> a : this.responses) {
                ResponseList<T> cache = (ResponseList<T>)map.get(a.getValue());
                if (cache == null) {
                    cache = new ResponseList<T>();
                    list.add(cache);
                    map.put(a.getValue(), cache);
                }
                cache.add(a);
            }
        }
        Collections.sort(list);
        this.cumulatedList = list;
        return list.size() > 0 ? (ResponseList)list.get(0) : null;
    }

    public void fireAfterSolveEvent(ChallengeSolver<T> solver) {
        this.controller.fireAfterSolveEvent(this, solver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSolverDone(ChallengeSolver<T> solver) {
        try {
            AtomicInteger atomicInteger = this.LOCK;
            synchronized (atomicInteger) {
                if (!this.solverList.contains(solver)) {
                    throw new IllegalStateException("This Job does not contain this solver");
                }
                if (!this.doneList.add(solver)) {
                    return;
                }
            }
            ChallengeSolverJobEventSender eventSender = this.getEventSender(false);
            if (eventSender == null) return;
            eventSender.fireEvent((DefaultEvent)new ChallengeSolverJobEvent(this, ChallengeSolverJobEvent.Type.SOLVER_DONE, solver));
            return;
        }
        finally {
            this._notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _wait(int timeout) throws InterruptedException {
        int notifyCnt = this.LOCK.get();
        AtomicInteger atomicInteger = this.LOCK;
        synchronized (atomicInteger) {
            if (notifyCnt != this.LOCK.get()) {
                return false;
            }
            this.LOCK.wait(timeout);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _notifyAll() {
        AtomicInteger atomicInteger = this.LOCK;
        synchronized (atomicInteger) {
            this.LOCK.incrementAndGet();
            this.LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireBeforeSolveEvent(ChallengeSolver<T> solver) {
        AtomicInteger atomicInteger = this.LOCK;
        synchronized (atomicInteger) {
            if (!this.solverList.contains(solver)) {
                throw new IllegalStateException("This Job does not contain this solver");
            }
        }
        ChallengeSolverJobEventSender eventSender = this.getEventSender(false);
        if (eventSender != null) {
            eventSender.fireEvent((DefaultEvent)new ChallengeSolverJobEvent(this, ChallengeSolverJobEvent.Type.SOLVER_START, solver));
        }
        this.controller.fireBeforeSolveEvent(this, solver);
    }

    private void fireNewAnswerEvent(AbstractResponse<T> abstractResponse) {
        this.controller.fireNewAnswerEvent(this, abstractResponse);
        ChallengeSolverJobEventSender eventSender = this.getEventSender(false);
        if (eventSender != null) {
            eventSender.fireEvent((DefaultEvent)new ChallengeSolverJobEvent(this, ChallengeSolverJobEvent.Type.NEW_ANSWER, abstractResponse));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTimeoutEvent(ChallengeSolver<T> solver) {
        AtomicInteger atomicInteger = this.LOCK;
        synchronized (atomicInteger) {
            if (!this.solverList.contains(solver)) {
                throw new IllegalStateException("This Job does not contain this solver");
            }
        }
        ChallengeSolverJobEventSender eventSender = this.getEventSender(false);
        if (eventSender != null) {
            eventSender.fireEvent((DefaultEvent)new ChallengeSolverJobEvent(this, ChallengeSolverJobEvent.Type.SOLVER_TIMEOUT, solver));
        }
    }

    public Challenge<T> getChallenge() {
        return this.challenge;
    }

    public ChallengeSolverJobEventSender getEventSender() {
        return this.getEventSender(true);
    }

    protected ChallengeSolverJobEventSender getEventSender(boolean mustInit) {
        ChallengeSolverJobEventSender eventSender;
        while ((eventSender = this.eventSender.get()) == null && mustInit) {
            this.eventSender.compareAndSet(null, new ChallengeSolverJobEventSender());
        }
        return eventSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        AtomicInteger atomicInteger = this.LOCK;
        synchronized (atomicInteger) {
            for (ChallengeSolver<T> sj : this.solverList) {
                if (this.doneList.contains(sj) || !sj.isJobDone(this)) continue;
                this.setSolverDone(sj);
            }
            return this.solverList.size() == this.doneList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone(ChallengeSolver<T> instance) {
        AtomicInteger atomicInteger = this.LOCK;
        synchronized (atomicInteger) {
            if (instance.isJobDone(this)) {
                this.setSolverDone(instance);
            }
            return !this.solverList.contains(instance) || this.doneList.contains(instance);
        }
    }

    public boolean isSolved() {
        int autoPriority = this.config.getAutoCaptchaPriorityThreshold();
        ResponseList<T> response = this.getResponse();
        return response != null && response.getSum() >= autoPriority;
    }

    public boolean isAlive() {
        return this.alive.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        ArrayList<ChallengeSolver<T>> killList = new ArrayList<ChallengeSolver<T>>();
        AtomicInteger atomicInteger = this.LOCK;
        synchronized (atomicInteger) {
            this.alive.set(false);
            for (ChallengeSolver<T> s : this.solverList) {
                if (this.doneList.contains(s)) continue;
                this.log("Kill " + s);
                killList.add(s);
            }
        }
        for (ChallengeSolver challengeSolver : killList) {
            challengeSolver.kill(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitFor(int timeout, ChallengeSolver<?> ... instances) throws InterruptedException {
        long endTime = -1L;
        if (timeout > 0) {
            endTime = Time.systemIndependentCurrentJVMTimeMillis() + (long)timeout;
            this.log(this + " Wait max" + timeout + " ms for " + instances);
        } else {
            this.log(this + " Wait infinite for " + instances);
        }
        try {
            while (!this.areDone(instances)) {
                if (this.isSolved()) {
                    throw new InterruptedException(this + " is Solved");
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException(this + " got interrupted");
                }
                if (this.areDone(instances)) continue;
                if (endTime > 0L) {
                    long timeToWait = endTime - Time.systemIndependentCurrentJVMTimeMillis();
                    if (timeToWait <= 0L) {
                        this.log(this + " Timed Out! ");
                        return;
                    }
                    this.log(this + " Wait " + timeToWait);
                    this._wait(timeout);
                } else {
                    this.log(this + " Wait infinite");
                    this._wait(0);
                }
                this.log(this + " Wokeup");
            }
            if (this.isSolved()) {
                throw new InterruptedException(this + " is Solved");
            }
            if (Thread.interrupted()) {
                throw new InterruptedException(this + " got interrupted");
            }
            this.log("Exit " + this + " by done: " + this.areDone(instances));
            return;
        }
        catch (InterruptedException e) {
            this.log(Exceptions.getStackTrace((Throwable)e));
            this.log(this + " exit by interrupt");
            throw e;
        }
    }

    public void setLogger(LogSource logSource) {
        this.logger = logSource;
    }

    public LogSource getLogger() {
        return this.logger;
    }

    public SkipRequest getSkipRequest() {
        return this.skipRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSkipRequest(SkipRequest skipRequest) {
        boolean kill = false;
        AtomicInteger atomicInteger = this.LOCK;
        synchronized (atomicInteger) {
            if (this.alive.compareAndSet(true, false)) {
                this.skipRequest = skipRequest;
                if (skipRequest != null) {
                    this.log("Got Skip Request:" + (Object)((Object)skipRequest));
                }
                kill = true;
            }
        }
        if (kill) {
            this.kill();
        }
        return kill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ChallengeSolver<T>> getSolverList() {
        AtomicInteger atomicInteger = this.LOCK;
        synchronized (atomicInteger) {
            return Collections.unmodifiableCollection(this.solverList);
        }
    }

    public void validate() {
        ArrayList<ResponseList<T>> responsesLists = this.getResponses();
        if (responsesLists != null) {
            for (int i = 0; i < responsesLists.size(); ++i) {
                ResponseList<T> responseList = responsesLists.get(0);
                for (AbstractResponse abstractResponse : responseList) {
                    if (i == 0) {
                        abstractResponse.setValidation(ValidationResult.VALID);
                        continue;
                    }
                    abstractResponse.setValidation(ValidationResult.UNUSED);
                }
            }
        }
    }

    public void invalidate() {
        ArrayList<ResponseList<T>> responsesLists = this.getResponses();
        if (responsesLists != null) {
            for (int i = 0; i < responsesLists.size(); ++i) {
                ResponseList<T> responseList = responsesLists.get(0);
                for (AbstractResponse abstractResponse : responseList) {
                    if (i == 0) {
                        abstractResponse.setValidation(ValidationResult.INVALID);
                        continue;
                    }
                    abstractResponse.setValidation(ValidationResult.UNUSED);
                }
            }
        }
    }
}

