/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import jd.plugins.DownloadLink;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.StringUtils;
import org.jdownloader.controlling.DownloadLinkView;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.UrlDisplayEntry;
import org.jdownloader.settings.UrlDisplayType;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class DefaultDownloadLinkViewImpl
implements DownloadLinkView {
    public static UrlDisplayType[] DISPLAY_URL_TYPE = null;
    private static final ChangeListener CHANGELISTENER = new ChangeListener();
    protected DownloadLink link;

    @Override
    public long getBytesLoaded() {
        return this.link.getDownloadCurrent();
    }

    @Override
    public void setLink(DownloadLink downloadLink) {
        this.link = downloadLink;
    }

    @Override
    public long getBytesTotalEstimated() {
        return this.link.getDownloadSize();
    }

    @Override
    public long getBytesTotal() {
        return this.link.getKnownDownloadSize();
    }

    @Override
    public long getSpeedBps() {
        return this.link.getDownloadSpeed();
    }

    @Override
    public long[] getChunksProgress() {
        return this.link.getChunksProgress();
    }

    @Override
    public long getBytesTotalVerified() {
        return this.link.getVerifiedFileSize();
    }

    @Override
    public long getDownloadTime() {
        return this.link.getDownloadTime();
    }

    @Override
    public String getDisplayName() {
        return this.link.getName();
    }

    @Override
    public String getDisplayUrl() {
        for (UrlDisplayType dt : DISPLAY_URL_TYPE) {
            String ret;
            if (dt == null || !StringUtils.isNotEmpty((String)(ret = LinkTreeUtils.getUrlByType(dt, this.link)))) continue;
            return ret;
        }
        return null;
    }

    static {
        CFG_GENERAL.URL_ORDER.getEventSender().addListener((EventListener)((Object)CHANGELISTENER));
        CHANGELISTENER.update();
    }

    private static class ChangeListener
    implements GenericConfigEventListener<Object> {
        private ChangeListener() {
        }

        public void update() {
            ArrayList<UrlDisplayType> lst = new ArrayList<UrlDisplayType>();
            UrlDisplayEntry[] newOrder = CFG_GENERAL.CFG.getUrlOrder();
            HashSet<String> dupe = new HashSet<String>();
            if (newOrder != null) {
                for (UrlDisplayEntry urlDisplayEntry : newOrder) {
                    if (!urlDisplayEntry.isEnabled()) continue;
                    try {
                        if (!dupe.add(urlDisplayEntry.getType())) continue;
                        lst.add(UrlDisplayType.valueOf(urlDisplayEntry.getType()));
                    }
                    catch (Throwable e1) {
                        LogController.getInstance().getLogger(DefaultDownloadLinkViewImpl.class.getName()).log(e1);
                    }
                }
            } else {
                UrlDisplayType[] urlDisplayTypeArray = CFG_GENERAL.CFG.getUrlDisplayOrder();
                CFG_GENERAL.CFG.setUrlDisplayOrder(null);
                if (urlDisplayTypeArray != null) {
                    newOrder = new UrlDisplayEntry[UrlDisplayType.values().length];
                    int i = 0;
                    for (UrlDisplayType t : urlDisplayTypeArray) {
                        if (!dupe.add(t.name())) continue;
                        lst.add(t);
                        newOrder[i++] = new UrlDisplayEntry(t.name(), true);
                    }
                    for (UrlDisplayType t : UrlDisplayType.values()) {
                        if (!dupe.add(t.name())) continue;
                        lst.add(t);
                        newOrder[i++] = new UrlDisplayEntry(t.name(), false);
                    }
                    CFG_GENERAL.CFG.setUrlOrder(newOrder);
                }
            }
            for (UrlDisplayType urlDisplayType : UrlDisplayType.values()) {
                if (!dupe.add(urlDisplayType.name())) continue;
                lst.add(urlDisplayType);
            }
            DISPLAY_URL_TYPE = lst.toArray(new UrlDisplayType[0]);
        }

        public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
            this.update();
        }

        public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
        }
    }
}

