/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import jd.controlling.downloadcontroller.BadDestinationException;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.PathTooLongException;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.controlling.FileCreationEvent;
import org.jdownloader.controlling.FileCreationEventSender;
import org.jdownloader.logging.LogController;
import org.jdownloader.translate._JDT;
import org.jdownloader.utils.JDFileUtils;

public class FileCreationManager {
    private static final FileCreationManager INSTANCE = new FileCreationManager();
    private FileCreationEventSender eventSender = new FileCreationEventSender();
    private LogSource logger = LogController.getInstance().getLogger(FileCreationManager.class.getName());

    public static FileCreationManager getInstance() {
        return INSTANCE;
    }

    public FileCreationEventSender getEventSender() {
        return this.eventSender;
    }

    private FileCreationManager() {
    }

    public boolean mkdir(File folder) {
        if (folder.exists()) {
            return false;
        }
        ArrayList<File> backlog = new ArrayList<File>();
        HashSet<String> loopcheck = new HashSet<String>();
        for (File copy = folder; copy != null && !copy.exists(); copy = copy.getParentFile()) {
            if (!loopcheck.add(copy.getAbsolutePath())) continue;
            backlog.add(copy);
        }
        for (int i = backlog.size() - 1; i >= 0; --i) {
            if (!this.mkdirInternal((File)backlog.get(i))) {
                return false;
            }
            this.getEventSender().fireEvent((DefaultEvent)new FileCreationEvent(this, FileCreationEvent.Type.NEW_FOLDER, (File)backlog.get(i)));
        }
        return true;
    }

    private boolean mkdirInternal(File file) {
        try {
            DownloadWatchDog.getInstance().validateDestination(file);
            return file.mkdir();
        }
        catch (PathTooLongException pathTooLongException) {
        }
        catch (BadDestinationException badDestinationException) {
            // empty catch block
        }
        return false;
    }

    @Deprecated
    public boolean delete(File file, DeleteOption deleteTo) {
        if (deleteTo == null) {
            deleteTo = DeleteOption.NULL;
        }
        if (!file.exists()) {
            return true;
        }
        switch (deleteTo) {
            case NULL: {
                if (file.delete()) {
                    return true;
                }
                if (Application.getJavaVersion() >= Application.JAVA17) {
                    try {
                        Files.delete(file.toPath());
                    }
                    catch (Exception e) {
                        this.logger.log((Throwable)e);
                    }
                }
                return !file.exists();
            }
            case RECYCLE: {
                if (JDFileUtils.isTrashSupported()) {
                    try {
                        JDFileUtils.moveToTrash(file);
                    }
                    catch (IOException e) {
                        this.logger.log((Throwable)e);
                    }
                }
                return !file.exists();
            }
        }
        return false;
    }

    public void moveFile(String oldPath, String newPath) {
        if (new File(oldPath).exists() && !new File(newPath).exists()) {
            FileCreationManager.getInstance().mkdir(new File(newPath).getParentFile());
            if (!new File(oldPath).renameTo(new File(newPath))) {
                try {
                    IO.copyFile((File)new File(oldPath), (File)new File(newPath));
                    FileCreationManager.getInstance().delete(new File(oldPath), null);
                }
                catch (IOException e) {
                    this.logger.log((Throwable)e);
                }
            }
        }
    }

    public static enum DeleteOption implements LabelInterface
    {
        NO_DELETE{

            public String getLabel() {
                return _JDT.T.DeleteOption_no_delete();
            }
        }
        ,
        RECYCLE{

            public String getLabel() {
                return _JDT.T.DeleteOption_recycle();
            }
        }
        ,
        NULL{

            public String getLabel() {
                return _JDT.T.DeleteOption_final_delete();
            }
        };

    }
}

