/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling;

import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import jd.plugins.DownloadLink;
import jd.plugins.download.HashInfo;
import org.appwork.storage.simplejson.MinimalMemoryMap;
import org.appwork.utils.StringUtils;
import org.jdownloader.controlling.DownloadLinkView;
import org.jdownloader.controlling.MirrorPackageSetup;
import org.jdownloader.plugins.FinalLinkState;

public class MirrorPackage {
    private final String id;
    private final ArrayList<DownloadLink> list = new ArrayList();
    private boolean finished = false;
    private long bytesLoaded = 0L;
    private long bytesTotal = -1L;
    private boolean online = false;
    private boolean offline = true;
    private boolean enabled = false;
    private Map<HashInfo.TYPE, String> knownHashes = null;
    private long speed;
    private final MirrorPackageSetup setup;

    public boolean isFinished() {
        return this.finished;
    }

    public long getBytesLoaded() {
        return this.bytesLoaded;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean isUnknownOnlineStatus() {
        return !this.offline && !this.online;
    }

    public boolean isOnline() {
        return this.online;
    }

    public MirrorPackage(String mirrorID, MirrorPackageSetup setup) {
        this.id = mirrorID;
        this.setup = setup;
    }

    public String add(DownloadLink link) {
        boolean isFinished;
        DownloadLinkView view = link.getView();
        long linkBytesTotal = view.getBytesTotal();
        if (this.bytesTotal > 0L && linkBytesTotal > 0L && linkBytesTotal != this.bytesTotal) {
            return this.id + "/" + linkBytesTotal;
        }
        HashInfo hashInfo = link.getHashInfo();
        if (hashInfo != null) {
            String existing;
            if (this.knownHashes == null) {
                this.knownHashes = new MinimalMemoryMap();
            }
            if ((existing = this.knownHashes.get((Object)hashInfo.getType())) == null) {
                this.knownHashes.put(hashInfo.getType(), hashInfo.getHash());
            } else if (!existing.equals(hashInfo.getHash())) {
                return this.id + "/" + hashInfo.getHash().toLowerCase(Locale.ENGLISH);
            }
        }
        if (isFinished = FinalLinkState.CheckFinished(link.getFinalLinkState())) {
            this.finished = true;
        }
        if (this.setup.isLocalFileUsageEnabled()) {
            String fileOutput = link.getFileOutput();
            if (StringUtils.isNotEmpty((String)fileOutput)) {
                File completeFile = new File(fileOutput);
                if (completeFile.exists()) {
                    this.bytesLoaded = Math.max(this.bytesLoaded, completeFile.length());
                } else {
                    File partFile = new File(fileOutput + ".part");
                    if (partFile.exists()) {
                        this.bytesLoaded = Math.max(this.bytesLoaded, partFile.length());
                    }
                }
            }
        } else {
            this.bytesLoaded = Math.max(this.bytesLoaded, view.getBytesLoaded());
        }
        this.bytesTotal = Math.max(this.bytesTotal, view.getBytesTotal());
        if (link.getAvailableStatus() == DownloadLink.AvailableStatus.TRUE) {
            this.online = true;
        } else {
            this.offline &= link.getAvailableStatus() == DownloadLink.AvailableStatus.FALSE;
        }
        if (link.isEnabled()) {
            this.enabled = true;
            if (!isFinished && link.getDownloadLinkController() != null) {
                this.speed = Math.max(this.speed, view.getSpeedBps());
            }
        }
        this.list.add(link);
        return null;
    }

    private String getFileOutput(DownloadLink link) {
        return link.getFileOutput();
    }

    public long getTotalBytes() {
        return this.bytesTotal;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getSpeed() {
        return this.speed;
    }
}

