/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.translate._JDT;

public class PasswordUtils {
    public static void main(String[] args) {
        Application.setApplication((String)".jd_home");
        try {
            String txt = Dialog.getInstance().showInputDialog("txt");
            System.out.println(PasswordUtils.getPasswords(txt));
        }
        catch (DialogClosedException e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
        }
        catch (DialogCanceledException e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
        }
    }

    public static HashSet<String> getPasswords(String data) {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        if (data != null) {
            String pass;
            String passwordPattern = _JDT.T.pattern_password();
            Pattern pattern = Pattern.compile("(" + passwordPattern + ")\\s+[\"']([[^\\:\"'\\s]][^\"'\\s])[\"']?", 2);
            Matcher matcher = pattern.matcher(data);
            while (matcher.find()) {
                pass = matcher.group(2);
                ret.add(pass);
            }
            pattern = Pattern.compile("(?:>\\s*|\"\\s*|'\\s*|\\s+)(" + passwordPattern + ")\\s+([[^\\:\"'\\s]][^\"'\\s]*)[\\s]?", 2);
            matcher = pattern.matcher(data);
            while (matcher.find()) {
                pass = matcher.group(2);
                ret.add(pass);
            }
            pattern = Pattern.compile("(" + passwordPattern + ")\\s*(?:\\:|=)\\s*[\"']([^\"']+)[\"']", 2);
            matcher = pattern.matcher(data);
            while (matcher.find()) {
                pass = matcher.group(2);
                ret.add(pass);
            }
            pattern = Pattern.compile("(" + passwordPattern + ")\\s*(?:\\:|\\-|=)\\s*([^\"'\\s]+)", 2);
            matcher = pattern.matcher(data);
            while (matcher.find()) {
                pass = matcher.group(2);
                ret.add(pass);
            }
            Iterator it = ret.iterator();
            while (it.hasNext()) {
                String next = (String)it.next();
                if (StringUtils.isEmpty((String)next)) {
                    it.remove();
                    continue;
                }
                if (next.length() < 2) {
                    it.remove();
                    continue;
                }
                if (next.matches("^\\s*</?span.*")) {
                    it.remove();
                    continue;
                }
                if (next.matches("^\\s*</?td.*")) {
                    it.remove();
                    continue;
                }
                if (!next.matches("(?i).*(rar|zip|jpg|gif|png|html|php|avi|mpg)$")) continue;
                it.remove();
            }
        }
        return ret;
    }
}

