/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling;

import javax.swing.Icon;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;

public enum Priority {
    HIGHEST(3, _GUI.T.gui_treetable_tooltip_priority3()),
    HIGHER(2, _GUI.T.gui_treetable_tooltip_priority2()),
    HIGH(1, _GUI.T.gui_treetable_tooltip_priority1()),
    DEFAULT(0, _GUI.T.gui_treetable_tooltip_priority0()),
    LOW(-1, _GUI.T.gui_treetable_tooltip_priority_1()),
    LOWER(-2, _GUI.T.gui_treetable_tooltip_priority_2()),
    LOWEST(-3, _GUI.T.gui_treetable_tooltip_priority_3());

    private final int id;
    private final String translation;

    public final int getId() {
        return this.id;
    }

    private Priority(int p, String translation) {
        this.id = p;
        this.translation = translation;
    }

    public final String T() {
        return this.translation;
    }

    public final String getIconKey() {
        switch (this) {
            case HIGHEST: {
                return "prio_3";
            }
            case HIGHER: {
                return "prio_2";
            }
            case HIGH: {
                return "prio_1";
            }
            case LOW: {
                return "prio_-1";
            }
            case LOWER: {
                return "prio_-2";
            }
            case LOWEST: {
                return "prio_-3";
            }
        }
        return "prio_0";
    }

    public final Icon loadIcon(int size) {
        return new AbstractIcon(this.getIconKey(), size);
    }

    public static Priority getPriority(int p) {
        if (p > 3) {
            p = 3;
        }
        if (p < -3) {
            p = -3;
        }
        switch (p) {
            case 3: {
                return HIGHEST;
            }
            case 2: {
                return HIGHER;
            }
            case 1: {
                return HIGH;
            }
            case -1: {
                return LOW;
            }
            case -2: {
                return LOWER;
            }
            case -3: {
                return LOWEST;
            }
        }
        return DEFAULT;
    }
}

