/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.controlling.contextmenu;

import java.util.TreeMap;
import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.storage.Storable;
import org.appwork.utils.StringUtils;
import org.jdownloader.extensions.AbstractExtension;
import org.jdownloader.extensions.ExtensionController;
import org.jdownloader.extensions.ExtensionNotLoadedException;
import org.jdownloader.myjdownloader.client.json.AbstractJsonData;

public class ActionData
extends AbstractJsonData
implements Storable {
    private Class<?> clazz;
    private static final String PACKAGE_NAME = AbstractExtension.class.getPackage().getName() + ".";
    private String data;
    private String clazzName;
    private String name;
    private String iconKey;
    private TreeMap<String, Object> setup;
    private String tooltip;

    public void setData(String data) {
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    public boolean _isValidDataForCreatingAnAction() {
        try {
            return this._getClazz() != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public Class<?> _getClazz() throws ClassNotFoundException, ExtensionNotLoadedException {
        if (this.clazz == null) {
            if (this.getClazzName() == null) {
                return null;
            }
            this.clazz = this._isExtensionAction() ? ExtensionController.getInstance().loadClass(this.getClazzName()) : Class.forName(this.getClazzName());
        } else if (this._isExtensionAction()) {
            this.clazz = ExtensionController.getInstance().loadClass(this.getClazzName());
        }
        return this.clazz;
    }

    private boolean _isExtensionAction() {
        String cn = this.getClazzName();
        if (cn == null) {
            return false;
        }
        int i = cn.lastIndexOf(".");
        String pkg = i >= 0 ? cn.substring(0, i) : "";
        boolean ret = pkg.startsWith(PACKAGE_NAME);
        return ret;
    }

    public ActionData() {
    }

    public ActionData(Class<?> class1) {
        this(class1, null);
    }

    public ActionData(Class<?> class1, String data) {
        this.data = data;
        this.clazz = class1;
        this.clazzName = class1.getName();
    }

    public String getClazzName() {
        return this.clazzName;
    }

    public void setClazzName(String clazzName) {
        this.clazzName = clazzName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getIconKey() {
        return this.iconKey;
    }

    public void setIconKey(String iconKey) {
        this.iconKey = iconKey;
    }

    public ActionData putSetup(String key, Object value) {
        if (this.setup == null) {
            this.setup = new TreeMap();
        }
        this.setup.put(StringUtils.toUpperCaseOrNull((String)key), value);
        return this;
    }

    @AllowNonStorableObjects
    public TreeMap<String, Object> getSetup() {
        return this.setup;
    }

    public void setSetup(TreeMap<String, Object> setup) {
        this.setup = setup;
    }

    public Object fetchSetup(String name2) {
        if (this.setup == null) {
            return null;
        }
        return this.setup.get(StringUtils.toUpperCaseOrNull((String)name2));
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getTooltip() {
        return this.tooltip;
    }
}

